/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.base.data.struct.table;

import de.mn77.base.data.form.FormString;
import de.mn77.base.data.struct.I_Sequence;
import de.mn77.base.data.struct.list.I_List;
import de.mn77.base.data.struct.list.MList;
import de.mn77.base.data.struct.table.A_Table;
import de.mn77.base.data.struct.table.ArrayTable;
import de.mn77.base.error.Err;
import java.util.ArrayList;

public class MTable<T>
extends A_Table<T> {
    private static final String ERR_ADD_WIDTH = "The number of items does not match the width of the table";
    private final I_List<T>[] cols;

    public MTable(int width) {
        Err.ifToSmall(1.0, width);
        this.cols = new I_List[width];
        int i = 0;
        while (i < width) {
            this.cols[i] = new MList();
            ++i;
        }
    }

    public MTable(ArrayTable<T> tab) {
        this(tab.size());
        for (T[] row : tab) {
            this.add(row);
        }
    }

    @Override
    public int getWidth() {
        return this.cols.length;
    }

    @Override
    public MTable<T> copy() {
        MTable result = new MTable(this.getWidth());
        for (I_Sequence row : this) {
            result.add(row);
        }
        return result;
    }

    @Override
    public String toStringDebug() {
        StringBuilder sb = new StringBuilder();
        sb.append("\n");
        int[] width = new int[this.getWidth()];
        int i = 0;
        while (i < this.getWidth()) {
            for (Object o : this.getCol(i + 1)) {
                if (("" + o).length() <= width[i]) continue;
                width[i] = ("" + o).length();
            }
            ++i;
        }
        int y = 1;
        while (y <= this.size()) {
            sb.append("| ");
            int x = 1;
            while (x <= this.getWidth()) {
                if (x > 1) {
                    sb.append(" | ");
                }
                sb.append(FormString.width(width[x - 1], "" + this.get(x, y), false));
                ++x;
            }
            sb.append(" |");
            if (y != this.size()) {
                sb.append("\n");
            }
            ++y;
        }
        return sb.toString();
    }

    @Override
    public void sortLike(int[] order) {
        I_List<T>[] i_ListArray = this.cols;
        int n = this.cols.length;
        int n2 = 0;
        while (n2 < n) {
            I_List<T> col = i_ListArray[n2];
            col.sortLike(order);
            ++n2;
        }
    }

    @Override
    public void add(T ... row) {
        Err.ifNot(this.getWidth(), row.length, ERR_ADD_WIDTH);
        int z = 0;
        T[] TArray = row;
        int n = row.length;
        int n2 = 0;
        while (n2 < n) {
            T t = TArray[n2];
            this.cols[z++].add(t);
            ++n2;
        }
    }

    @Override
    public void add(I_Sequence<? extends T> row) {
        Err.ifNot(this.getWidth(), row.size(), ERR_ADD_WIDTH);
        int z = 0;
        for (Object t : row) {
            this.cols[z++].add(t);
        }
    }

    @Override
    public void insert(int row, T ... objects) {
        Err.ifNot(this.getWidth(), objects.length, ERR_ADD_WIDTH);
        Err.ifEqual(row, 0);
        int i = 1;
        while (i <= this.getWidth()) {
            this.cols[i - 1].insert(row, objects[i - 1]);
            ++i;
        }
    }

    @Override
    public void insert(int row, I_Sequence<? extends T> objects) {
        Err.ifNot(this.getWidth(), objects.size(), ERR_ADD_WIDTH);
        Err.ifEqual(row, 0);
        int i = 1;
        while (i <= this.getWidth()) {
            this.cols[i - 1].insert(row, objects.get(i));
            ++i;
        }
    }

    @Override
    protected T pGet(int col, int row) {
        return (T)this.cols[col - 1].get(row);
    }

    @Override
    protected I_List<T> pGetCol(int col) {
        ArrayList copy = new ArrayList(this.getWidth());
        for (Object t : this.cols[col - 1]) {
            copy.add(t);
        }
        return new MList(copy);
    }

    @Override
    protected void pSet(int col, int row, T object) {
        this.cols[col - 1].set(row, object);
    }

    @Override
    protected void pExchange(int row_a, int row_b) {
        I_List<T>[] i_ListArray = this.cols;
        int n = this.cols.length;
        int n2 = 0;
        while (n2 < n) {
            I_List<T> col = i_ListArray[n2];
            col.exchange(row_a, row_b);
            ++n2;
        }
    }

    @Override
    protected void pRemove(int pos) {
        I_List<T>[] i_ListArray = this.cols;
        int n = this.cols.length;
        int n2 = 0;
        while (n2 < n) {
            I_List<T> col = i_ListArray[n2];
            col.removePosition(pos);
            ++n2;
        }
    }
}

