/*
 * Decompiled with CFR 0.152.
 */
package marytts.language.ru;

import java.util.Locale;
import marytts.datatypes.MaryData;
import marytts.datatypes.MaryDataType;
import marytts.datatypes.MaryXML;
import marytts.modules.JTokeniser;
import marytts.util.dom.MaryDomUtils;
import marytts.util.dom.NameNodeFilter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.NodeIterator;

public class Tokenizer
extends JTokeniser {
    public Tokenizer() {
        super(MaryDataType.RAWMARYXML, MaryDataType.TOKENS, new Locale("ru"));
        this.setTokenizerLanguage("en");
    }

    public MaryData process(MaryData d) throws Exception {
        MaryData result = super.process(d);
        this.splitOffDots(result);
        return result;
    }

    protected void splitOffDots(MaryData d) {
        Document doc = d.getDocument();
        NodeIterator ni = ((DocumentTraversal)((Object)doc)).createNodeIterator(doc, 1, (NodeFilter)new NameNodeFilter(new String[]{"t"}), false);
        Element t = null;
        while ((t = (Element)ni.nextNode()) != null) {
            String s = MaryDomUtils.tokenText((Element)t);
            if (s.length() <= 1 || !s.endsWith(".")) continue;
            String s1 = s.substring(0, s.length() - 1);
            MaryDomUtils.setTokenText((Element)t, (String)s1);
            Element sentence = (Element)MaryDomUtils.getAncestor((Node)t, (String)"s");
            assert (sentence != null);
            if (!MaryDomUtils.isLastOfItsKindIn((Node)t, (Node)sentence)) {
                Element firstInSentence = MaryDomUtils.getFirstElementByTagName((Node)sentence, (String)"t");
                Element newSentence = MaryDomUtils.encloseNodesWithNewElement((Node)firstInSentence, (Node)t, (String)"s");
                sentence.getParentNode().insertBefore(newSentence, sentence);
                sentence = newSentence;
            }
            Element newT = MaryXML.appendChildElement((Node)sentence, (String)"t");
            MaryDomUtils.setTokenText((Element)newT, (String)".");
        }
    }
}

