/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.ext.marytts;

import de.mn77.base.data.filter.FilterString;
import de.mn77.base.data.struct.table.I_Table;
import de.mn77.base.data.struct.table.MTable;
import de.mn77.base.error.Err;
import de.mn77.base.error.Err_Runtime;
import java.io.IOException;
import java.util.Locale;
import java.util.Set;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.LineListener;
import marytts.LocalMaryInterface;
import marytts.MaryInterface;
import marytts.exceptions.MaryConfigurationException;
import marytts.exceptions.SynthesisException;
import marytts.util.data.audio.AudioPlayer;
import marytts.util.data.audio.MaryAudioUtils;

public class MaryTTS {
    private MaryInterface marytts;
    private String outputFile = null;
    private String voiceName = null;

    public I_Table<String> getVoices() {
        if (this.marytts == null) {
            throw Err.invalid((Object[])new Object[]{"First start the Service!"});
        }
        MTable tab = new MTable(2);
        Set locales = this.marytts.getAvailableLocales();
        for (Locale locale : locales) {
            Set voices = this.marytts.getAvailableVoices(locale);
            for (String voice : voices) {
                tab.add((Object[])new String[]{locale.toString(), voice});
            }
        }
        return tab;
    }

    public void setOutputFile(String outputFile) {
        this.outputFile = outputFile;
    }

    public void setVoiceName(String voiceName) {
        this.voiceName = voiceName;
    }

    public void startService() {
        if (this.marytts != null) {
            throw Err.invalid((Object[])new Object[]{"MaryTTS is allready started!"});
        }
        try {
            this.marytts = new LocalMaryInterface();
        }
        catch (MaryConfigurationException e) {
            throw new Err_Runtime((Throwable)e, new Object[0]);
        }
    }

    public void stopService() {
        this.marytts = null;
    }

    public void textToSpeach(String text, boolean wait) {
        if (this.marytts == null) {
            throw Err.invalid((Object[])new Object[]{"MaryTTS-Process not started!"});
        }
        if (text.trim().length() == 0) {
            return;
        }
        if (this.voiceName != null && !this.voiceName.isEmpty()) {
            this.marytts.setVoice(this.voiceName);
            this.voiceName = null;
        }
        AudioInputStream audio = null;
        String toSpeak = FilterString.removeEmptyLines((String)text);
        try {
            audio = this.marytts.generateAudio(toSpeak);
        }
        catch (SynthesisException e) {
            throw new Err_Runtime((Throwable)e, new Object[0]);
        }
        if (this.outputFile != null && !this.outputFile.isEmpty()) {
            try {
                MaryAudioUtils.writeWavFile((double[])MaryAudioUtils.getSamplesAsDoubleArray((AudioInputStream)audio), (String)this.outputFile, (AudioFormat)audio.getFormat());
            }
            catch (IOException e) {
                throw new Err_Runtime((Throwable)e, new Object[0]);
            }
        } else {
            this.iPlayAudio(audio, wait);
        }
    }

    private void iPlayAudio(AudioInputStream audio, boolean wait) {
        LineListener lineListener = event -> {};
        AudioPlayer ap = new AudioPlayer(audio, lineListener);
        try {
            ap.start();
            if (wait) {
                ap.join();
            }
        }
        catch (InterruptedException e) {
            Err.show((Throwable)e);
        }
    }
}

