/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline.postag;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import opennlp.tools.cmdline.BasicCmdLineTool;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.PerformanceMonitor;
import opennlp.tools.cmdline.postag.POSModelLoader;
import opennlp.tools.postag.POSModel;
import opennlp.tools.postag.POSSample;
import opennlp.tools.postag.POSTaggerME;
import opennlp.tools.tokenize.WhitespaceTokenizer;
import opennlp.tools.util.PlainTextByLineStream;

public final class POSTaggerTool
extends BasicCmdLineTool {
    public String getShortDescription() {
        return "learnable part of speech tagger";
    }

    public String getHelp() {
        return "Usage: opennlp " + this.getName() + " model < sentences";
    }

    public void run(String[] args) {
        if (args.length != 1) {
            System.out.println(this.getHelp());
        } else {
            POSModel model = (POSModel)new POSModelLoader().load(new File(args[0]));
            POSTaggerME tagger = new POSTaggerME(model);
            PlainTextByLineStream lineStream = new PlainTextByLineStream(new InputStreamReader(System.in));
            PerformanceMonitor perfMon = new PerformanceMonitor(System.err, "sent");
            perfMon.start();
            try {
                String line;
                while ((line = (String)lineStream.read()) != null) {
                    String[] whitespaceTokenizerLine = WhitespaceTokenizer.INSTANCE.tokenize(line);
                    String[] tags = tagger.tag(whitespaceTokenizerLine);
                    POSSample sample = new POSSample(whitespaceTokenizerLine, tags);
                    System.out.println(sample.toString());
                    perfMon.incrementCounter();
                }
            }
            catch (IOException e) {
                CmdLineUtil.handleStdinIoError(e);
            }
            perfMon.stopAndPrintFinalResult();
        }
    }
}

