/*
 * Decompiled with CFR 0.152.
 */
package marytts.util.math;

import java.io.FileNotFoundException;
import java.io.IOException;
import marytts.util.io.MaryRandomAccessFile;

public class DoubleMatrix {
    public double[][] vectors;
    public int numVectors;
    public int dimension;

    public DoubleMatrix() {
        this.vectors = null;
        this.allocate(0, 0);
    }

    public DoubleMatrix(int numVectorsIn, int dimensionIn) {
        this.vectors = null;
        this.allocate(numVectorsIn, dimensionIn);
    }

    public DoubleMatrix(String dataFile) {
        this.vectors = null;
        this.read(dataFile);
    }

    public DoubleMatrix(double[][] x) {
        this.setVectors(x);
    }

    public void setVectors(double[][] x) {
        if (x != null) {
            int dimensionIn = x[0].length;
            int i = 1;
            while (i < x.length) {
                assert (x[i].length == dimensionIn);
                ++i;
            }
            this.allocate(x.length, dimensionIn);
            i = 0;
            while (i < this.numVectors) {
                System.arraycopy(x[i], 0, this.vectors[i], 0, this.dimension);
                ++i;
            }
        } else {
            this.allocate(0, 0);
        }
    }

    public void allocate(int numVectorsIn, int dimensionIn) {
        if (numVectorsIn > 0) {
            if (this.numVectors != numVectorsIn) {
                this.numVectors = numVectorsIn;
                this.vectors = new double[this.numVectors][];
            }
            if (dimensionIn > 0) {
                if (this.dimension != dimensionIn) {
                    this.dimension = dimensionIn;
                    int i = 0;
                    while (i < this.numVectors) {
                        this.vectors[i] = new double[this.dimension];
                        ++i;
                    }
                }
                this.dimension = dimensionIn;
            } else {
                this.dimension = 0;
            }
        } else {
            this.vectors = null;
            this.numVectors = 0;
            this.dimension = 0;
        }
    }

    public void write(String dataFile) {
        MaryRandomAccessFile fp = null;
        try {
            fp = new MaryRandomAccessFile(dataFile, "rw");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        if (fp != null) {
            try {
                fp.writeIntEndian(this.numVectors);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                fp.writeIntEndian(this.dimension);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (this.numVectors > 0 && this.dimension > 0) {
                int i = 0;
                while (i < this.numVectors) {
                    try {
                        fp.writeDoubleEndian(this.vectors[i]);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    ++i;
                }
            }
            try {
                fp.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void read(String dataFile) {
        MaryRandomAccessFile fp = null;
        try {
            fp = new MaryRandomAccessFile(dataFile, "r");
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
        }
        if (fp != null) {
            int numVectorsIn = 0;
            int dimensionIn = 0;
            try {
                numVectorsIn = fp.readIntEndian();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                dimensionIn = fp.readIntEndian();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (numVectorsIn > 0) {
                if (this.numVectors != numVectorsIn) {
                    this.vectors = new double[numVectorsIn][];
                }
                this.numVectors = numVectorsIn;
                this.dimension = dimensionIn;
                if (this.dimension > 0) {
                    int i = 0;
                    while (i < this.numVectors) {
                        try {
                            this.vectors[i] = fp.readDoubleEndian(this.dimension);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        ++i;
                    }
                } else {
                    int i = 0;
                    while (i < this.numVectors) {
                        this.vectors[i] = null;
                        ++i;
                    }
                    this.dimension = 0;
                }
            } else {
                this.vectors = null;
                this.numVectors = 0;
                this.dimension = 0;
            }
            try {
                fp.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            this.allocate(0, 0);
        }
    }
}

