/*
 * Decompiled with CFR 0.152.
 */
package marytts.modules;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.StringReader;
import java.util.Locale;
import java.util.Scanner;
import marytts.datatypes.MaryData;
import marytts.datatypes.MaryDataType;
import marytts.features.FeatureDefinition;
import marytts.features.FeatureProcessorManager;
import marytts.features.FeatureRegistry;
import marytts.features.TargetFeatureComputer;
import marytts.machinelearning.SoP;
import marytts.modules.InternalModule;
import marytts.modules.phonemiser.AllophoneSet;
import marytts.modules.synthesis.Voice;
import marytts.server.MaryProperties;
import marytts.unitselection.select.Target;
import marytts.unitselection.select.UnitSelector;
import marytts.util.MaryRuntimeUtils;
import marytts.util.MaryUtils;
import marytts.util.dom.MaryDomUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeIterator;
import org.w3c.dom.traversal.TreeWalker;

public class SoPDurationModeller
extends InternalModule {
    private String sopFileName;
    private SoP vowelSop;
    private SoP consonantSop;
    private SoP pauseSop;
    private boolean logDuration = true;
    protected TargetFeatureComputer featureComputer;
    private FeatureProcessorManager featureProcessorManager;
    private AllophoneSet allophoneSet;
    private FeatureDefinition voiceFeatDef;

    public SoPDurationModeller(String locale, String sopFile) throws Exception {
        this(MaryUtils.string2locale(locale), sopFile, FeatureRegistry.getFeatureProcessorManager(MaryUtils.string2locale(locale)));
    }

    public SoPDurationModeller(String locale, String sopFile, String featprocClassInfo) throws Exception {
        this(MaryUtils.string2locale(locale), sopFile, (FeatureProcessorManager)MaryRuntimeUtils.instantiateObject(featprocClassInfo));
    }

    protected SoPDurationModeller(Locale locale, String sopFile, FeatureProcessorManager featureProcessorManager) {
        super("SoPDurationModeller", MaryDataType.ALLOPHONES, MaryDataType.DURATIONS, locale);
        this.sopFileName = sopFile;
        this.featureProcessorManager = featureProcessorManager;
    }

    @Override
    public void startup() throws Exception {
        super.startup();
        String sopFile = MaryProperties.getFilename(this.sopFileName);
        String strContext = "";
        try (Scanner s = null;){
            String nextLine;
            s = new Scanner(new BufferedReader(new FileReader(sopFile)));
            while (s.hasNext()) {
                nextLine = s.nextLine();
                if (nextLine.trim().equals("")) break;
                strContext = String.valueOf(strContext) + nextLine + "\n";
            }
            this.voiceFeatDef = new FeatureDefinition(new BufferedReader(new StringReader(strContext)), false);
            if (s.hasNext()) {
                nextLine = s.nextLine();
                this.vowelSop = new SoP(nextLine, this.voiceFeatDef);
            }
            if (s.hasNext()) {
                nextLine = s.nextLine();
                this.consonantSop = new SoP(nextLine, this.voiceFeatDef);
            }
            if (s.hasNext()) {
                nextLine = s.nextLine();
                this.pauseSop = new SoP(nextLine, this.voiceFeatDef);
            }
        }
        this.featureComputer = FeatureRegistry.getTargetFeatureComputer(this.featureProcessorManager, this.voiceFeatDef.getFeatureNames());
    }

    @Override
    public MaryData process(MaryData d) throws Exception {
        Document doc = d.getDocument();
        NodeIterator sentenceIt = MaryDomUtils.createNodeIterator((Node)doc, "s");
        Element sentence = null;
        while ((sentence = (Element)sentenceIt.nextNode()) != null) {
            Element segmentOrBoundary;
            Element voice = (Element)MaryDomUtils.getAncestor((Node)sentence, "voice");
            Voice maryVoice = Voice.getVoice(voice);
            if (maryVoice == null) {
                maryVoice = d.getDefaultVoice();
            }
            if (maryVoice == null) {
                Locale locale = MaryUtils.string2locale(doc.getDocumentElement().getAttribute("xml:lang"));
                maryVoice = Voice.getDefaultVoice(locale);
            }
            this.allophoneSet = maryVoice.getAllophoneSet();
            TargetFeatureComputer currentFeatureComputer = this.featureComputer;
            float end = 0.0f;
            TreeWalker tw = MaryDomUtils.createTreeWalker(sentence, "ph", "boundary");
            while ((segmentOrBoundary = (Element)tw.nextNode()) != null) {
                float durInSeconds;
                String phone = UnitSelector.getPhoneSymbol(segmentOrBoundary);
                Target t = new Target(phone, segmentOrBoundary);
                t.setFeatureVector(currentFeatureComputer.computeFeatureVector(t));
                if (segmentOrBoundary.getTagName().equals("boundary")) {
                    System.out.print("Pause PHONE: " + phone);
                    durInSeconds = (float)this.pauseSop.solve(t, this.voiceFeatDef, this.logDuration, false);
                    if ((double)durInSeconds < 0.0) {
                        System.out.println("\nWARNING: duration < 0.0");
                        durInSeconds = (float)this.pauseSop.solve(t, this.voiceFeatDef, this.logDuration, true);
                    }
                } else if (this.allophoneSet.getAllophone(phone).isVowel()) {
                    System.out.print("Vowel PHONE: " + phone);
                    durInSeconds = (float)this.vowelSop.solve(t, this.voiceFeatDef, this.logDuration, false);
                    if ((double)durInSeconds < 0.0) {
                        System.out.println("\nWARNING: duration < 0.0");
                        durInSeconds = (float)this.vowelSop.solve(t, this.voiceFeatDef, this.logDuration, true);
                    }
                } else {
                    System.out.print("Cons. PHONE: " + phone);
                    durInSeconds = (float)this.consonantSop.solve(t, this.voiceFeatDef, this.logDuration, false);
                    if ((double)durInSeconds < 0.0) {
                        System.out.println("\nWARNING: duration < 0.0");
                        durInSeconds = (float)this.consonantSop.solve(t, this.voiceFeatDef, this.logDuration, true);
                    }
                }
                System.out.format(" = %.3f\n", Float.valueOf(durInSeconds));
                if (durInSeconds < 0.0f) {
                    throw new Exception("Error generating SoP Duration: durInSeconds < 0.0 ");
                }
                end += durInSeconds;
                int durInMillis = (int)(1000.0f * durInSeconds);
                if (segmentOrBoundary.getTagName().equals("boundary")) {
                    segmentOrBoundary.setAttribute("duration", String.valueOf(durInMillis));
                    continue;
                }
                segmentOrBoundary.setAttribute("d", String.valueOf(durInMillis));
                segmentOrBoundary.setAttribute("end", String.valueOf(end));
            }
        }
        MaryData output = new MaryData(this.outputType(), d.getLocale());
        output.setDocument(doc);
        return output;
    }
}

