/*
 * Decompiled with CFR 0.152.
 */
package marytts.features;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import marytts.exceptions.MaryConfigurationException;
import marytts.features.ByteValuedFeatureProcessor;
import marytts.features.ContinuousFeatureProcessor;
import marytts.features.MaryFeatureProcessor;
import marytts.features.MaryGenericFeatureProcessors;
import marytts.features.MaryLanguageFeatureProcessors;
import marytts.features.ShortValuedFeatureProcessor;
import marytts.modules.acoustic.Model;
import marytts.modules.phonemiser.AllophoneSet;
import marytts.modules.synthesis.Voice;
import marytts.server.MaryProperties;
import marytts.util.MaryRuntimeUtils;
import marytts.util.MaryUtils;

public class FeatureProcessorManager {
    protected Map<String, MaryFeatureProcessor> processors;
    protected Map<String, String[]> phonefeatures2values;
    protected Locale locale;

    public FeatureProcessorManager(String localeString) throws MaryConfigurationException {
        this(MaryUtils.string2locale(localeString));
    }

    public FeatureProcessorManager(Locale locale) throws MaryConfigurationException {
        this.locale = locale;
        this.setupGenericFeatureProcessors();
        AllophoneSet allophoneSet = MaryRuntimeUtils.needAllophoneSet(String.valueOf(MaryProperties.localePrefix(locale)) + ".allophoneset");
        this.setupPhoneFeatureProcessors(allophoneSet, null, null, null);
    }

    public FeatureProcessorManager(Voice voice) throws MaryConfigurationException {
        this(voice.getLocale());
        this.registerAcousticModels(voice);
    }

    protected void registerAcousticModels(Voice voice) {
        Map<String, Model> acousticModels = voice.getAcousticModels();
        if (acousticModels == null) {
            return;
        }
        for (Model model : acousticModels.values()) {
            String modelFeatureName = model.getFeatureName();
            if (modelFeatureName == null || this.listContinuousFeatureProcessorNames().contains(modelFeatureName)) continue;
            String modelAttributeName = model.getTargetAttributeName();
            MaryGenericFeatureProcessors.GenericContinuousFeature featureProcessor = new MaryGenericFeatureProcessors.GenericContinuousFeature(modelFeatureName, modelAttributeName);
            this.addFeatureProcessor(featureProcessor);
        }
    }

    @Deprecated
    public FeatureProcessorManager() {
        this.setupGenericFeatureProcessors();
    }

    @Deprecated
    protected void setupHardcodedPhoneFeatureValues() {
        this.phonefeatures2values = new HashMap<String, String[]>();
        this.phonefeatures2values.put("cplace", new String[]{"0", "l", "a", "p", "b", "d", "v", "g"});
        this.phonefeatures2values.put("ctype", new String[]{"0", "s", "f", "a", "n", "l", "r"});
        this.phonefeatures2values.put("cvox", new String[]{"0", "+", "-"});
        this.phonefeatures2values.put("vc", new String[]{"0", "+", "-"});
        this.phonefeatures2values.put("vfront", new String[]{"0", "1", "2", "3"});
        this.phonefeatures2values.put("vheight", new String[]{"0", "1", "2", "3"});
        this.phonefeatures2values.put("vlng", new String[]{"0", "s", "l", "d", "a"});
        this.phonefeatures2values.put("vrnd", new String[]{"0", "+", "-"});
    }

    protected void setupGenericFeatureProcessors() {
        this.processors = new TreeMap<String, MaryFeatureProcessor>();
        new MaryGenericFeatureProcessors.SegmentNavigator();
        MaryGenericFeatureProcessors.PrevSegmentNavigator prevSegment = new MaryGenericFeatureProcessors.PrevSegmentNavigator();
        MaryGenericFeatureProcessors.NextSegmentNavigator nextSegment = new MaryGenericFeatureProcessors.NextSegmentNavigator();
        MaryGenericFeatureProcessors.SyllableNavigator syllable = new MaryGenericFeatureProcessors.SyllableNavigator();
        MaryGenericFeatureProcessors.PrevSyllableNavigator prevSyllable = new MaryGenericFeatureProcessors.PrevSyllableNavigator();
        MaryGenericFeatureProcessors.NextSyllableNavigator nextSyllable = new MaryGenericFeatureProcessors.NextSyllableNavigator();
        MaryGenericFeatureProcessors.NextNextSyllableNavigator nextNextSyllable = new MaryGenericFeatureProcessors.NextNextSyllableNavigator();
        MaryGenericFeatureProcessors.LastWordInSentenceNavigator lastWord = new MaryGenericFeatureProcessors.LastWordInSentenceNavigator();
        this.addFeatureProcessor(new MaryGenericFeatureProcessors.Edge());
        this.addFeatureProcessor(new MaryGenericFeatureProcessors.HalfPhoneLeftRight());
        this.addFeatureProcessor(new MaryGenericFeatureProcessors.Accented("accented", syllable));
        this.addFeatureProcessor(new MaryGenericFeatureProcessors.Stressed("stressed", syllable));
        this.addFeatureProcessor(new MaryGenericFeatureProcessors.Stressed("prev_stressed", prevSyllable));
        this.addFeatureProcessor(new MaryGenericFeatureProcessors.Stressed("next_stressed", nextSyllable));
        this.addFeatureProcessor(new MaryGenericFeatureProcessors.WordNumSyls());
        this.addFeatureProcessor(new MaryGenericFeatureProcessors.PosInSyl());
        this.addFeatureProcessor(new MaryGenericFeatureProcessors.SylBreak("syl_break", syllable));
        this.addFeatureProcessor(new MaryGenericFeatureProcessors.SylBreak("prev_syl_break", prevSyllable));
        this.addFeatureProcessor(new MaryGenericFeatureProcessors.PositionType());
        this.addFeatureProcessor(new MaryGenericFeatureProcessors.BreakIndex());
        this.addFeatureProcessor(new MaryGenericFeatureProcessors.IsPause("prev_is_pause", prevSegment));
        this.addFeatureProcessor(new MaryGenericFeatureProcessors.IsPause("next_is_pause", nextSegment));
        this.addFeatureProcessor(new MaryGenericFeatureProcessors.TobiAccent("tobi_accent", syllable));
        this.addFeatureProcessor(new MaryGenericFeatureProcessors.TobiAccent("next_tobi_accent", nextSyllable));
        this.addFeatureProcessor(new MaryGenericFeatureProcessors.TobiAccent("nextnext_tobi_accent", nextNextSyllable));
        this.addFeatureProcessor(new MaryGenericFeatureProcessors.TobiEndtone("tobi_endtone", syllable));
        this.addFeatureProcessor(new MaryGenericFeatureProcessors.TobiEndtone("next_tobi_endtone", nextSyllable));
        this.addFeatureProcessor(new MaryGenericFeatureProcessors.TobiEndtone("nextnext_tobi_endtone", nextNextSyllable));
        this.addFeatureProcessor(new MaryGenericFeatureProcessors.WordPunc("sentence_punc", lastWord));
        this.addFeatureProcessor(new MaryGenericFeatureProcessors.SylsFromPhraseStart());
        this.addFeatureProcessor(new MaryGenericFeatureProcessors.SylsFromPhraseEnd());
        this.addFeatureProcessor(new MaryGenericFeatureProcessors.StressedSylsFromPhraseStart());
        this.addFeatureProcessor(new MaryGenericFeatureProcessors.StressedSylsFromPhraseEnd());
        this.addFeatureProcessor(new MaryGenericFeatureProcessors.AccentedSylsFromPhraseStart());
        this.addFeatureProcessor(new MaryGenericFeatureProcessors.AccentedSylsFromPhraseEnd());
        this.addFeatureProcessor(new MaryGenericFeatureProcessors.SylsFromPrevStressed());
        this.addFeatureProcessor(new MaryGenericFeatureProcessors.SylsToNextStressed());
        this.addFeatureProcessor(new MaryGenericFeatureProcessors.SylsFromPrevAccent());
        this.addFeatureProcessor(new MaryGenericFeatureProcessors.SylsToNextAccent());
        this.addFeatureProcessor(new MaryGenericFeatureProcessors.WordNumSegs());
        this.addFeatureProcessor(new MaryGenericFeatureProcessors.SegsFromSylStart());
        this.addFeatureProcessor(new MaryGenericFeatureProcessors.SegsFromSylEnd());
        this.addFeatureProcessor(new MaryGenericFeatureProcessors.SylNumSegs());
        this.addFeatureProcessor(new MaryGenericFeatureProcessors.SentenceNumPhrases());
        this.addFeatureProcessor(new MaryGenericFeatureProcessors.SentenceNumWords());
        this.addFeatureProcessor(new MaryGenericFeatureProcessors.PhraseNumWords());
        this.addFeatureProcessor(new MaryGenericFeatureProcessors.PhraseNumSyls());
        this.addFeatureProcessor(new MaryGenericFeatureProcessors.SegsFromWordStart());
        this.addFeatureProcessor(new MaryGenericFeatureProcessors.SegsFromWordEnd());
        this.addFeatureProcessor(new MaryGenericFeatureProcessors.SylsFromWordStart());
        this.addFeatureProcessor(new MaryGenericFeatureProcessors.SylsFromWordEnd());
        this.addFeatureProcessor(new MaryGenericFeatureProcessors.WordsFromPhraseStart());
        this.addFeatureProcessor(new MaryGenericFeatureProcessors.WordsFromPhraseEnd());
        this.addFeatureProcessor(new MaryGenericFeatureProcessors.WordsFromSentenceStart());
        this.addFeatureProcessor(new MaryGenericFeatureProcessors.WordsFromSentenceEnd());
        this.addFeatureProcessor(new MaryGenericFeatureProcessors.PhrasesFromSentenceStart());
        this.addFeatureProcessor(new MaryGenericFeatureProcessors.PhrasesFromSentenceEnd());
        this.addFeatureProcessor(new MaryGenericFeatureProcessors.NextAccent());
        this.addFeatureProcessor(new MaryGenericFeatureProcessors.PrevAccent());
        this.addFeatureProcessor(new MaryGenericFeatureProcessors.PhraseEndtone());
        this.addFeatureProcessor(new MaryGenericFeatureProcessors.PrevPhraseEndtone());
        this.addFeatureProcessor(new MaryGenericFeatureProcessors.PrevPunctuation());
        this.addFeatureProcessor(new MaryGenericFeatureProcessors.NextPunctuation());
        this.addFeatureProcessor(new MaryGenericFeatureProcessors.WordsFromPrevPunctuation());
        this.addFeatureProcessor(new MaryGenericFeatureProcessors.WordsToNextPunctuation());
        this.addFeatureProcessor(new MaryGenericFeatureProcessors.Selection_Prosody(syllable));
        this.addFeatureProcessor(new MaryGenericFeatureProcessors.Style());
        this.addFeatureProcessor(new MaryGenericFeatureProcessors.UnitDuration());
        this.addFeatureProcessor(new MaryGenericFeatureProcessors.UnitLogF0());
        this.addFeatureProcessor(new MaryGenericFeatureProcessors.UnitLogF0Delta());
    }

    public Locale getLocale() {
        return this.locale;
    }

    public String listFeatureProcessorNames() {
        String bytes = this.listByteValuedFeatureProcessorNames();
        String shorts = this.listShortValuedFeatureProcessorNames();
        String conts = this.listContinuousFeatureProcessorNames();
        StringBuilder sb = new StringBuilder(bytes.length() + shorts.length() + conts.length() + 2);
        sb.append(bytes);
        if (bytes.length() > 0 && shorts.length() > 0) {
            sb.append(" ");
        }
        sb.append(shorts);
        if (conts.length() > 0) {
            sb.append(" ");
        }
        sb.append(conts);
        return sb.toString();
    }

    public String listByteValuedFeatureProcessorNames() {
        StringBuilder sb = new StringBuilder();
        for (String name : this.processors.keySet()) {
            MaryFeatureProcessor fp = this.processors.get(name);
            if (!(fp instanceof ByteValuedFeatureProcessor)) continue;
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(name);
        }
        return sb.toString();
    }

    public String listShortValuedFeatureProcessorNames() {
        StringBuilder sb = new StringBuilder();
        for (String name : this.processors.keySet()) {
            MaryFeatureProcessor fp = this.processors.get(name);
            if (!(fp instanceof ShortValuedFeatureProcessor)) continue;
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(name);
        }
        return sb.toString();
    }

    public String listContinuousFeatureProcessorNames() {
        StringBuilder sb = new StringBuilder();
        for (String name : this.processors.keySet()) {
            MaryFeatureProcessor fp = this.processors.get(name);
            if (!(fp instanceof ContinuousFeatureProcessor)) continue;
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(name);
        }
        return sb.toString();
    }

    protected void addFeatureProcessor(MaryFeatureProcessor fp) {
        this.processors.put(fp.getName(), fp);
    }

    public MaryFeatureProcessor getFeatureProcessor(String name) {
        return this.processors.get(name);
    }

    protected void setupPhoneFeatureProcessors(AllophoneSet phoneset, String[] phoneValues, String pauseSymbol, Map<String, String[]> featuresToValues) {
        MaryGenericFeatureProcessors.SegmentNavigator segment = new MaryGenericFeatureProcessors.SegmentNavigator();
        if (phoneValues == null) {
            String[] pValues = phoneset.getAllophoneNames().toArray(new String[0]);
            phoneValues = new String[pValues.length + 1];
            phoneValues[0] = "0";
            System.arraycopy(pValues, 0, phoneValues, 1, pValues.length);
        }
        if (pauseSymbol == null) {
            pauseSymbol = phoneset.getSilence().name();
        }
        this.addFeatureProcessor(new MaryLanguageFeatureProcessors.Phone("phone", phoneValues, pauseSymbol, segment));
        this.addFeatureProcessor(new MaryLanguageFeatureProcessors.HalfPhoneUnitName(phoneValues, pauseSymbol));
        this.addFeatureProcessor(new MaryLanguageFeatureProcessors.SegOnsetCoda(phoneset));
        Set<String> featureNames = featuresToValues != null ? featuresToValues.keySet() : phoneset.getPhoneFeatures();
        for (String feature : featureNames) {
            String[] values = featuresToValues != null ? featuresToValues.get(feature) : phoneset.getPossibleFeatureValues(feature);
            this.addFeatureProcessor(new MaryLanguageFeatureProcessors.PhoneFeature(phoneset, "ph_" + feature, feature, values, pauseSymbol, segment));
        }
        HashMap<String, MaryGenericFeatureProcessors.TargetElementNavigator> segments = new HashMap<String, MaryGenericFeatureProcessors.TargetElementNavigator>();
        segments.put("prev", new MaryGenericFeatureProcessors.PrevSegmentNavigator());
        segments.put("prev_prev", new MaryGenericFeatureProcessors.PrevPrevSegmentNavigator());
        segments.put("next", new MaryGenericFeatureProcessors.NextSegmentNavigator());
        segments.put("next_next", new MaryGenericFeatureProcessors.NextNextSegmentNavigator());
        for (String position : segments.keySet()) {
            MaryGenericFeatureProcessors.TargetElementNavigator navi = (MaryGenericFeatureProcessors.TargetElementNavigator)segments.get(position);
            this.addFeatureProcessor(new MaryLanguageFeatureProcessors.Phone(String.valueOf(position) + "_phone", phoneValues, pauseSymbol, navi));
            for (String feature : featureNames) {
                String[] values = featuresToValues != null ? featuresToValues.get(feature) : phoneset.getPossibleFeatureValues(feature);
                this.addFeatureProcessor(new MaryLanguageFeatureProcessors.PhoneFeature(phoneset, String.valueOf(position) + "_" + feature, feature, values, pauseSymbol, navi));
            }
        }
    }
}

