/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.util.data.norm;

import java.io.Serializable;
import org.neuroph.core.data.DataSet;
import org.neuroph.core.data.DataSetRow;
import org.neuroph.util.data.norm.Normalizer;

public final class MaxMinNormalizer
implements Normalizer,
Serializable {
    private double[] maxIn;
    private double[] maxOut;
    private double[] minIn;
    private double[] minOut;

    public MaxMinNormalizer(DataSet dataSet) {
        this.init(dataSet);
    }

    @Override
    public void normalize(DataSet dataSet) {
        for (DataSetRow row : dataSet.getRows()) {
            this.normalizeVector(row.getInput(), this.minIn, this.maxIn);
            if (!dataSet.isSupervised()) continue;
            this.normalizeVector(row.getDesiredOutput(), this.minOut, this.maxOut);
        }
    }

    private void init(DataSet dataSet) {
        int i;
        int numInputs = dataSet.getInputSize();
        int numOutputs = dataSet.getOutputSize();
        this.maxIn = new double[numInputs];
        this.minIn = new double[numInputs];
        for (i = 0; i < numInputs; ++i) {
            this.maxIn[i] = Double.MIN_VALUE;
            this.minIn[i] = Double.MAX_VALUE;
        }
        this.maxOut = new double[numOutputs];
        this.minOut = new double[numOutputs];
        for (i = 0; i < numOutputs; ++i) {
            this.maxOut[i] = Double.MIN_VALUE;
            this.minOut[i] = Double.MAX_VALUE;
        }
        for (DataSetRow dataSetRow : dataSet.getRows()) {
            double[] input = dataSetRow.getInput();
            for (int i2 = 0; i2 < numInputs; ++i2) {
                if (Math.abs(input[i2]) > this.maxIn[i2]) {
                    this.maxIn[i2] = Math.abs(input[i2]);
                }
                if (!(Math.abs(input[i2]) < this.minIn[i2])) continue;
                this.minIn[i2] = Math.abs(input[i2]);
            }
            double[] output = dataSetRow.getDesiredOutput();
            for (int i3 = 0; i3 < numOutputs; ++i3) {
                if (Math.abs(output[i3]) > this.maxOut[i3]) {
                    this.maxOut[i3] = Math.abs(output[i3]);
                }
                if (!(Math.abs(output[i3]) < this.minOut[i3])) continue;
                this.minOut[i3] = Math.abs(output[i3]);
            }
        }
    }

    private void normalizeVector(double[] vector, double[] min, double[] max) {
        for (int i = 0; i < vector.length; ++i) {
            vector[i] = (vector[i] - min[i]) / (max[i] - min[i]);
        }
    }

    public double[] getMaxIn() {
        return this.maxIn;
    }

    public double[] getMaxOut() {
        return this.maxOut;
    }

    public double[] getMinIn() {
        return this.minIn;
    }

    public double[] getMinOut() {
        return this.minOut;
    }
}

