/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.util;

import java.util.Iterator;
import org.neuroph.core.Neuron;
import org.neuroph.core.input.InputFunction;
import org.neuroph.core.input.WeightedSum;
import org.neuroph.core.transfer.Linear;
import org.neuroph.core.transfer.TransferFunction;
import org.neuroph.util.NeurophProperties;
import org.neuroph.util.TransferFunctionType;

public class NeuronProperties
extends NeurophProperties {
    private static final long serialVersionUID = 3L;
    public static final String INPUT_FUNCTION = "inputFunction";
    public static final String TRANSFER_FUNCTION = "transferFunction";
    public static final String NEURON_TYPE = "neuronType";
    public static final String USE_BIAS = "useBias";

    public NeuronProperties() {
        this.initKeys();
        this.setProperty(INPUT_FUNCTION, WeightedSum.class);
        this.setProperty(TRANSFER_FUNCTION, Linear.class);
        this.setProperty(NEURON_TYPE, Neuron.class);
    }

    public NeuronProperties(Class<? extends Neuron> neuronClass) {
        this.initKeys();
        this.setProperty(INPUT_FUNCTION, WeightedSum.class);
        this.setProperty(TRANSFER_FUNCTION, Linear.class);
        this.setProperty(NEURON_TYPE, neuronClass);
    }

    public NeuronProperties(Class<? extends Neuron> neuronClass, Class<? extends TransferFunction> transferFunctionClass) {
        this.initKeys();
        this.setProperty(INPUT_FUNCTION, WeightedSum.class);
        this.setProperty(TRANSFER_FUNCTION, transferFunctionClass);
        this.setProperty(NEURON_TYPE, neuronClass);
    }

    public NeuronProperties(Class<? extends Neuron> neuronClass, Class<? extends InputFunction> inputFunctionClass, Class<? extends TransferFunction> transferFunctionClass) {
        this.initKeys();
        this.setProperty(INPUT_FUNCTION, inputFunctionClass);
        this.setProperty(TRANSFER_FUNCTION, transferFunctionClass);
        this.setProperty(NEURON_TYPE, neuronClass);
    }

    public NeuronProperties(Class<? extends Neuron> neuronClass, TransferFunctionType transferFunctionType) {
        this.initKeys();
        this.setProperty(INPUT_FUNCTION, WeightedSum.class);
        this.setProperty(TRANSFER_FUNCTION, transferFunctionType.getTypeClass());
        this.setProperty(NEURON_TYPE, neuronClass);
    }

    public NeuronProperties(TransferFunctionType transferFunctionType, boolean useBias) {
        this.initKeys();
        this.setProperty(INPUT_FUNCTION, WeightedSum.class);
        this.setProperty(TRANSFER_FUNCTION, transferFunctionType.getTypeClass());
        this.setProperty(USE_BIAS, useBias);
        this.setProperty(NEURON_TYPE, Neuron.class);
    }

    private void initKeys() {
        this.createKeys(INPUT_FUNCTION, TRANSFER_FUNCTION, NEURON_TYPE, USE_BIAS);
    }

    public Class getInputFunction() {
        Object val = this.get(INPUT_FUNCTION);
        if (!val.equals("")) {
            return (Class)val;
        }
        return null;
    }

    public Class getTransferFunction() {
        return (Class)this.get(TRANSFER_FUNCTION);
    }

    public Class getNeuronType() {
        return (Class)this.get(NEURON_TYPE);
    }

    public NeurophProperties getTransferFunctionProperties() {
        NeurophProperties tfProperties = new NeurophProperties();
        Iterator iterator = this.keySet().iterator();
        while (iterator.hasNext()) {
            String name = iterator.next().toString();
            if (!name.contains(TRANSFER_FUNCTION)) continue;
            tfProperties.setProperty(name, this.get(name));
        }
        return tfProperties;
    }

    @Override
    public final void setProperty(String key, Object value) {
        if (value instanceof TransferFunctionType) {
            value = ((TransferFunctionType)((Object)value)).getTypeClass();
        }
        this.put(key, value);
    }
}

