/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.util;

import org.neuroph.core.data.DataSet;
import org.neuroph.core.data.DataSetRow;
import org.neuroph.util.DataSetColumnType;

public class DataSetStatistics {
    private final DataSet dataSet;
    private final int rowLength;
    private final int rowsCount;
    private final double[] mean;
    private final double[] max;
    private final double[] min;
    private final double[] sum;
    private final double[] variance;
    private final double[] stdDeviation;
    private final double[] frequency;
    public static final String MIN = "min";
    public static final String MAX = "max";
    public static final String MEAN = "mean";
    public static final String SUM = "sum";
    public static final String STD_DEV = "std dev";
    public static final String VAR = "var";
    public static final String FREQ = "freq";

    public DataSetStatistics(DataSet dataSet) {
        this.dataSet = dataSet;
        this.rowLength = dataSet.getInputSize() + dataSet.getOutputSize();
        this.rowsCount = dataSet.getRows().size();
        this.mean = new double[this.rowLength];
        this.max = new double[this.rowLength];
        this.min = new double[this.rowLength];
        this.sum = new double[this.rowLength];
        this.variance = new double[this.rowLength];
        this.stdDeviation = new double[this.rowLength];
        this.frequency = new double[this.rowLength];
        this.setDefaultValues();
    }

    private void setDefaultValues() {
        for (int i = 0; i < this.rowLength; ++i) {
            this.max[i] = -1.7976931348623157E308;
            this.min[i] = Double.MAX_VALUE;
        }
    }

    private void resetValues() {
        for (int i = 0; i < this.rowLength; ++i) {
            this.sum[i] = 0.0;
            this.variance[i] = 0.0;
            this.frequency[i] = -0.0;
        }
    }

    public void calculateStatistics() {
        int i;
        double[] row;
        this.resetValues();
        DataSetColumnType[] columnTypes = this.dataSet.getColumnTypes();
        for (DataSetRow dataSetRow : this.dataSet.getRows()) {
            row = dataSetRow.toArray();
            for (i = 0; i < this.rowLength; ++i) {
                this.max[i] = Math.max(this.max[i], row[i]);
                this.min[i] = Math.min(this.min[i], row[i]);
                int n = i;
                this.sum[n] = this.sum[n] + row[i];
                if (columnTypes[i] != DataSetColumnType.NOMINAL) continue;
                int n2 = i;
                this.frequency[n2] = this.frequency[n2] + row[i];
            }
        }
        for (int i2 = 0; i2 < this.rowLength; ++i2) {
            this.mean[i2] = this.sum[i2] / (double)this.rowsCount;
        }
        for (DataSetRow dataSetRow : this.dataSet.getRows()) {
            row = dataSetRow.toArray();
            i = 0;
            while (i < this.rowLength) {
                double delta = row[i] - this.mean[i];
                int n = i++;
                this.variance[n] = this.variance[n] + delta * delta;
            }
        }
        for (int i3 = 0; i3 < this.rowLength; ++i3) {
            int n = i3;
            this.variance[n] = this.variance[n] / (double)this.rowsCount;
            this.stdDeviation[i3] = Math.sqrt(this.variance[i3]);
        }
    }

    public DataSet getDataSet() {
        return this.dataSet;
    }

    public double[] getMean() {
        return this.mean;
    }

    public double[] getMax() {
        return this.max;
    }

    public double[] getMin() {
        return this.min;
    }

    public double[] getVar() {
        return this.variance;
    }

    public double[] getStdDev() {
        return this.stdDeviation;
    }

    public double[] getFrequency() {
        return this.frequency;
    }

    @Deprecated
    public double[] inputsMean() {
        double[] mean = new double[this.dataSet.getInputSize()];
        for (DataSetRow row : this.dataSet.getRows()) {
            double[] currentInput = row.getInput();
            for (int i = 0; i < this.dataSet.getInputSize(); ++i) {
                int n = i;
                mean[n] = mean[n] + currentInput[i];
            }
        }
        int i = 0;
        while (i < this.dataSet.getInputSize()) {
            int n = i++;
            mean[n] = mean[n] / (double)this.dataSet.getRows().size();
        }
        return mean;
    }

    @Deprecated
    public double[] inputsMax() {
        int inputSize = this.dataSet.getInputSize();
        double[] maxColumnElements = new double[inputSize];
        for (int i = 0; i < inputSize; ++i) {
            maxColumnElements[i] = -1.7976931348623157E308;
        }
        for (DataSetRow dataSetRow : this.dataSet.getRows()) {
            double[] input = dataSetRow.getInput();
            for (int i = 0; i < inputSize; ++i) {
                maxColumnElements[i] = Math.max(maxColumnElements[i], input[i]);
            }
        }
        return maxColumnElements;
    }

    @Deprecated
    public double[] inputsMin() {
        int inputSize = this.dataSet.getInputSize();
        double[] minColumnElements = new double[inputSize];
        for (int i = 0; i < inputSize; ++i) {
            minColumnElements[i] = Double.MAX_VALUE;
        }
        for (DataSetRow dataSetRow : this.dataSet.getRows()) {
            double[] input = dataSetRow.getInput();
            for (int i = 0; i < inputSize; ++i) {
                minColumnElements[i] = Math.min(minColumnElements[i], input[i]);
            }
        }
        return minColumnElements;
    }

    @Deprecated
    public double[] inputsStandardDeviation(double[] mean2) {
        double[] sum = new double[mean2.length];
        for (DataSetRow dataSetRow : this.dataSet.getRows()) {
            double[] input = dataSetRow.getInput();
            for (int i = 0; i < input.length; ++i) {
                sum[i] = (input[i] - mean2[i]) * (input[i] - mean2[i]);
            }
        }
        double[] std = new double[mean2.length];
        for (int i = 0; i < mean2.length; ++i) {
            std[i] = Math.sqrt(sum[i] / (double)(this.dataSet.size() - 1));
        }
        return std;
    }
}

