/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.nnet;

import org.neuroph.core.Layer;
import org.neuroph.core.NeuralNetwork;
import org.neuroph.nnet.comp.layer.InputLayer;
import org.neuroph.nnet.comp.neuron.BiasNeuron;
import org.neuroph.nnet.learning.LMS;
import org.neuroph.util.ConnectionFactory;
import org.neuroph.util.LayerFactory;
import org.neuroph.util.NeuralNetworkFactory;
import org.neuroph.util.NeuralNetworkType;
import org.neuroph.util.NeuronProperties;
import org.neuroph.util.TransferFunctionType;

public class Adaline
extends NeuralNetwork<LMS> {
    private static final long serialVersionUID = 1L;

    public Adaline(int inputNeuronsCount) {
        this.createNetwork(inputNeuronsCount);
    }

    private void createNetwork(int inputNeuronsCount) {
        this.setNetworkType(NeuralNetworkType.ADALINE);
        NeuronProperties inNeuronProperties = new NeuronProperties();
        inNeuronProperties.setProperty("transferFunction", (Object)TransferFunctionType.LINEAR);
        InputLayer inputLayer = new InputLayer(inputNeuronsCount);
        inputLayer.addNeuron(new BiasNeuron());
        this.addLayer(inputLayer);
        NeuronProperties outNeuronProperties = new NeuronProperties();
        outNeuronProperties.setProperty("transferFunction", (Object)TransferFunctionType.LINEAR);
        Layer outputLayer = LayerFactory.createLayer(1, outNeuronProperties);
        this.addLayer(outputLayer);
        ConnectionFactory.fullConnect((Layer)inputLayer, outputLayer);
        NeuralNetworkFactory.setDefaultIO(this);
        this.setLearningRule(new LMS());
    }
}

