/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.eval;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.lang3.SerializationUtils;
import org.neuroph.core.NeuralNetwork;
import org.neuroph.core.data.DataSet;
import org.neuroph.core.learning.error.MeanSquaredError;
import org.neuroph.eval.ClassifierEvaluator;
import org.neuroph.eval.ErrorEvaluator;
import org.neuroph.eval.Evaluation;
import org.neuroph.eval.EvaluationResult;
import org.neuroph.eval.Evaluator;
import org.neuroph.util.data.sample.Sampling;
import org.neuroph.util.data.sample.SubSampling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrossValidationBak {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)CrossValidationBak.class.getName());
    private NeuralNetwork neuralNetwork;
    private DataSet dataSet;
    private Sampling sampling;
    private int numberOfFolds;
    private int foldSize;
    private final Evaluation evaluation = new Evaluation();

    private void initialize(NeuralNetwork neuralNetwork, DataSet dataSet, int numberOfFolds) {
        this.neuralNetwork = neuralNetwork;
        this.numberOfFolds = numberOfFolds;
        this.dataSet = dataSet;
        if (neuralNetwork.getOutputsCount() == 1) {
            this.evaluation.addEvaluator(new ClassifierEvaluator.Binary(0.5));
        } else {
            this.evaluation.addEvaluator(new ClassifierEvaluator.MultiClass(dataSet.getColumnNames()));
        }
        this.evaluation.addEvaluator(new ErrorEvaluator(new MeanSquaredError()));
    }

    public CrossValidationBak(NeuralNetwork neuralNetwork, DataSet dataSet, int foldCount) {
        this.initialize(neuralNetwork, dataSet, foldCount);
        this.sampling = new SubSampling(foldCount);
    }

    public Sampling getSampling() {
        return this.sampling;
    }

    public void setSampling(Sampling sampling) {
        this.sampling = sampling;
    }

    public Evaluation getEvaluation() {
        return this.evaluation;
    }

    public void run() throws InterruptedException, ExecutionException {
        this.dataSet.shuffle();
        this.foldSize = this.dataSet.size() / this.numberOfFolds;
        ArrayList<CrossValidationWorker> workersTasks = new ArrayList<CrossValidationWorker>();
        for (int foldIdx = 0; foldIdx < this.numberOfFolds; ++foldIdx) {
            workersTasks.add(new CrossValidationWorker(this.neuralNetwork, this.dataSet, foldIdx));
        }
        ExecutorService executor = Executors.newFixedThreadPool(4);
        List evaluationResults = executor.invokeAll(workersTasks);
        executor.shutdown();
    }

    public void addEvaluator(Evaluator eval) {
        this.evaluation.addEvaluator(eval);
    }

    public <T extends Evaluator> T getEvaluator(Class<T> type) {
        return this.evaluation.getEvaluator(type);
    }

    private class CrossValidationWorker
    implements Callable<EvaluationResult> {
        private final NeuralNetwork neuralNetwork;
        private final DataSet dataSet;
        private final int foldIndex;

        public Evaluation getEvaluation() {
            return CrossValidationBak.this.evaluation;
        }

        public CrossValidationWorker(NeuralNetwork neuralNetwork, DataSet dataSet, int foldIndex) {
            this.neuralNetwork = neuralNetwork;
            this.dataSet = dataSet;
            this.foldIndex = foldIndex;
        }

        @Override
        public EvaluationResult call() {
            NeuralNetwork neuralNet = (NeuralNetwork)SerializationUtils.clone((Serializable)this.neuralNetwork);
            DataSet trainingSet = new DataSet(this.dataSet.size() - CrossValidationBak.this.foldSize);
            DataSet testSet = new DataSet(CrossValidationBak.this.foldSize);
            int startIndex = CrossValidationBak.this.foldSize * this.foldIndex;
            int endIndex = CrossValidationBak.this.foldSize * (this.foldIndex + 1);
            for (int i = 0; i < this.dataSet.size(); ++i) {
                if (i >= startIndex && i < endIndex) {
                    testSet.add(this.dataSet.getRowAt(i));
                    continue;
                }
                trainingSet.add(this.dataSet.getRowAt(i));
            }
            neuralNet.learn(trainingSet);
            EvaluationResult evaluationResult = new EvaluationResult();
            evaluationResult.setNeuralNetwork(neuralNet);
            evaluationResult = CrossValidationBak.this.evaluation.evaluate(neuralNet, testSet);
            return evaluationResult;
        }
    }
}

