/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.core.transfer;

import java.io.Serializable;
import org.neuroph.core.transfer.TransferFunction;
import org.neuroph.util.NeurophProperties;

public class Trapezoid
extends TransferFunction
implements Serializable {
    private static final long serialVersionUID = 1L;
    double leftLow;
    double leftHigh;
    double rightLow;
    double rightHigh;

    public Trapezoid() {
        this.leftLow = 0.0;
        this.leftHigh = 1.0;
        this.rightLow = 3.0;
        this.rightHigh = 2.0;
    }

    public Trapezoid(double leftLow, double leftHigh, double rightLow, double rightHigh) {
        this.leftLow = leftLow;
        this.leftHigh = leftHigh;
        this.rightLow = rightLow;
        this.rightHigh = rightHigh;
    }

    public Trapezoid(NeurophProperties properties) {
        try {
            this.leftLow = (Double)properties.getProperty("transferFunction.leftLow");
            this.leftHigh = (Double)properties.getProperty("transferFunction.leftHigh");
            this.rightLow = (Double)properties.getProperty("transferFunction.rightLow");
            this.rightHigh = (Double)properties.getProperty("transferFunction.rightHigh");
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (NumberFormatException e) {
            System.err.println("Invalid transfer function properties! Using default values.");
        }
    }

    @Override
    public double getOutput(double net) {
        if (net >= this.leftHigh && net <= this.rightHigh) {
            return 1.0;
        }
        if (net > this.leftLow && net < this.leftHigh) {
            return (net - this.leftLow) / (this.leftHigh - this.leftLow);
        }
        if (net > this.rightHigh && net < this.rightLow) {
            return (this.rightLow - net) / (this.rightLow - this.rightHigh);
        }
        return 0.0;
    }

    public void setLeftLow(double leftLow) {
        this.leftLow = leftLow;
    }

    public void setLeftHigh(double leftHigh) {
        this.leftHigh = leftHigh;
    }

    public void setRightLow(double rightLow) {
        this.rightLow = rightLow;
    }

    public void setRightHigh(double rightHigh) {
        this.rightHigh = rightHigh;
    }

    public double getLeftLow() {
        return this.leftLow;
    }

    public double getLeftHigh() {
        return this.leftHigh;
    }

    public double getRightLow() {
        return this.rightLow;
    }

    public double getRightHigh() {
        return this.rightHigh;
    }
}

