/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.core.transfer;

import java.io.Serializable;
import org.neuroph.core.transfer.TransferFunction;
import org.neuroph.util.NeurophProperties;

public class Sigmoid
extends TransferFunction
implements Serializable {
    private static final long serialVersionUID = 2L;
    private double slope = 1.0;

    public Sigmoid() {
    }

    public Sigmoid(double slope) {
        this.slope = slope;
    }

    public Sigmoid(NeurophProperties properties) {
        try {
            this.slope = (Double)properties.getProperty("transferFunction.slope");
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (NumberFormatException e) {
            System.err.println("Invalid transfer function properties! Using default values.");
        }
    }

    public double getSlope() {
        return this.slope;
    }

    public void setSlope(double slope) {
        this.slope = slope;
    }

    @Override
    public double getOutput(double netInput) {
        if (netInput > 100.0) {
            return 1.0;
        }
        if (netInput < -100.0) {
            return 0.0;
        }
        double den = 1.0 + Math.exp(-this.slope * netInput);
        this.output = 1.0 / den;
        return this.output;
    }

    @Override
    public double getDerivative(double net) {
        double derivative = this.slope * this.output * (1.0 - this.output);
        return derivative;
    }
}

