/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.core.learning;

import java.io.Serializable;
import java.util.Iterator;
import org.neuroph.core.data.DataSet;
import org.neuroph.core.data.DataSetRow;
import org.neuroph.core.learning.IterativeLearning;

public abstract class UnsupervisedLearning
extends IterativeLearning
implements Serializable {
    private static final long serialVersionUID = 1L;

    @Override
    public void doLearningEpoch(DataSet trainingSet) {
        Iterator<DataSetRow> iterator = trainingSet.iterator();
        while (iterator.hasNext() && !this.isStopped()) {
            DataSetRow trainingSetRow = iterator.next();
            this.learnPattern(trainingSetRow);
        }
    }

    protected void learnPattern(DataSetRow trainingElement) {
        double[] input = trainingElement.getInput();
        this.neuralNetwork.setInput(input);
        this.neuralNetwork.calculate();
        this.updateNetworkWeights();
    }

    protected abstract void updateNetworkWeights();
}

