/*
 * Decompiled with CFR 0.152.
 */
package javax.visrec.ml.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.visrec.ml.data.Column;
import javax.visrec.ml.data.DataSet;

public class BasicDataSet<E>
implements DataSet<E> {
    protected List<E> items;
    private List<Column> columns = new ArrayList<Column>();

    protected BasicDataSet() {
        this.items = new ArrayList();
    }

    public BasicDataSet(Column ... cols) {
        this.columns = new ArrayList<Column>();
        Arrays.stream(cols).forEach(col -> this.columns.add((Column)col));
        this.items = new ArrayList();
    }

    public BasicDataSet(String ... cols) {
        this.columns = new ArrayList<Column>();
        Arrays.stream(cols).forEach(col -> this.columns.add(new Column((String)col)));
        this.items = new ArrayList();
    }

    public BasicDataSet(List<E> elements) {
        this.items = elements;
    }

    @Override
    public List<E> getItems() {
        return this.items;
    }

    @Override
    public List<Column> getColumns() {
        return this.columns;
    }

    public void setColumnNames(String[] columnNames) {
        for (int i = 0; i < columnNames.length; ++i) {
            this.columns.get(i).setName(columnNames[i]);
        }
    }

    public String[] getColumnNames() {
        String[] colNames = new String[this.columns.size()];
        for (int i = 0; i < this.columns.size(); ++i) {
            colNames[i] = this.columns.get(i).getName();
        }
        return colNames;
    }

    public void setAsTargetColumns(int ... targetIdxs) {
        this.columns.stream().forEach(c -> c.setAsTarget(false));
        for (int idx : targetIdxs) {
            this.columns.get(idx).setAsTarget(true);
        }
    }

    public void setAsTargetColumns(String ... targetColNames) {
        this.columns.stream().forEach(c -> c.setAsTarget(false));
        this.columns.stream().forEach(col -> {
            for (String name : targetColNames) {
                if (!col.getName().equals(name)) continue;
                col.setAsTarget(true);
            }
        });
    }

    @Override
    public String[] getTargetColumnsNames() {
        List<String> targetLabels = this.columns.stream().filter(col -> col.isTarget()).map(col -> col.getName()).collect(Collectors.toList());
        return targetLabels.toArray(new String[0]);
    }

    @Override
    public DataSet<E>[] split(double ... parts) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setColumns(List<Column> columns) {
        this.columns = columns;
    }
}

