/*
 * Decompiled with CFR 0.152.
 */
package marytts.util.string;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class ByteStringTranslator {
    public static final int MAXNUM = 255;
    private ArrayList<String> list;
    private Map<String, Byte> map;

    public ByteStringTranslator() {
        this.list = new ArrayList();
        this.map = new HashMap<String, Byte>();
    }

    public ByteStringTranslator(int initialRange) {
        int range = initialRange & 0xFF;
        this.list = new ArrayList(range);
        this.map = new HashMap<String, Byte>();
    }

    public ByteStringTranslator(String[] strings) {
        if (strings.length > 255) {
            StringBuilder buf = new StringBuilder();
            int i = 0;
            while (i < strings.length) {
                buf.append("\"" + strings[i] + "\" ");
                ++i;
            }
            throw new IllegalArgumentException("Too many strings for a byte-string translator: \n" + buf.toString() + "(" + strings.length + " strings)");
        }
        this.list = new ArrayList<String>(Arrays.asList(strings));
        this.map = new HashMap<String, Byte>();
        int i = 0;
        while (i < strings.length) {
            this.map.put(strings[i], (byte)i);
            ++i;
        }
    }

    public void set(byte b, String s) {
        int index = b & 0xFF;
        this.list.add(index, s);
        this.map.put(s, b);
    }

    public boolean contains(String s) {
        return this.map.containsKey(s);
    }

    public boolean contains(byte b) {
        int index = b & 0xFF;
        return index >= 0 && index < this.list.size();
    }

    public byte get(String s) {
        Byte b = this.map.get(s);
        if (b == null) {
            throw new IllegalArgumentException("No byte value known for string [" + s + "]");
        }
        return b;
    }

    public String get(byte b) {
        int index = b & 0xFF;
        if (index < 0 || index >= this.list.size()) {
            throw new IndexOutOfBoundsException("Byte value out of range: " + index);
        }
        return this.list.get(index);
    }

    public String[] getStringValues() {
        return this.list.toArray(new String[0]);
    }

    public int getNumberOfValues() {
        return this.list.size();
    }
}

