/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.sinusoidal.hntm.analysis;

import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import marytts.signalproc.sinusoidal.hntm.analysis.FrameNoisePart;
import marytts.util.math.ArrayUtils;

public class FrameNoisePartPseudoHarmonic
implements FrameNoisePart {
    public float[] ceps = null;

    public FrameNoisePartPseudoHarmonic() {
    }

    public FrameNoisePartPseudoHarmonic(FrameNoisePartPseudoHarmonic existing) {
        this();
        this.ceps = ArrayUtils.copy(existing.ceps);
    }

    public FrameNoisePartPseudoHarmonic(DataInputStream dis, int cepsLen) {
        this();
        if (cepsLen > 0) {
            this.ceps = new float[cepsLen];
            int i = 0;
            while (i < cepsLen) {
                try {
                    this.ceps[i] = dis.readFloat();
                }
                catch (IOException iOException) {
                    System.out.println("Error! At least " + String.valueOf(cepsLen) + " cepstrum coefficients required!");
                }
                ++i;
            }
        }
    }

    public FrameNoisePartPseudoHarmonic(ByteBuffer bb, int cepsLen) {
        this();
        if (cepsLen > 0) {
            this.ceps = new float[cepsLen];
            int i = 0;
            while (i < cepsLen) {
                try {
                    this.ceps[i] = bb.getFloat();
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("At least " + String.valueOf(cepsLen) + " cepstrum coefficients required!", e);
                }
                ++i;
            }
        }
    }

    @Override
    public void write(DataOutput out) throws IOException {
        int cepsLen = 0;
        if (this.ceps != null && this.ceps.length > 0) {
            cepsLen = this.ceps.length;
        }
        if (cepsLen > 0) {
            int i = 0;
            while (i < this.ceps.length) {
                out.writeFloat(this.ceps[i]);
                ++i;
            }
        }
    }

    public boolean equals(FrameNoisePartPseudoHarmonic other) {
        if (this.ceps != null || other.ceps != null) {
            if (this.ceps != null && other.ceps == null) {
                return false;
            }
            if (this.ceps == null && other.ceps != null) {
                return false;
            }
            if (this.ceps.length != other.ceps.length) {
                return false;
            }
            int i = 0;
            while (i < this.ceps.length) {
                if (this.ceps[i] != other.ceps[i]) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    @Override
    public int getVectorSize() {
        int cepsLen = 0;
        if (this.ceps != null && this.ceps.length > 0) {
            cepsLen = this.ceps.length;
        }
        return cepsLen;
    }

    @Override
    public int getLength() {
        return 4 * this.getVectorSize();
    }
}

