/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.process;

import java.io.File;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import marytts.signalproc.analysis.LpcAnalyser;
import marytts.signalproc.process.FrameOverlapAddSource;
import marytts.signalproc.process.LPCAnalysisResynthesis;
import marytts.util.data.BufferedDoubleDataSource;
import marytts.util.data.audio.AudioDoubleDataSource;
import marytts.util.data.audio.DDSAudioInputStream;
import marytts.util.math.MathUtils;

public class LPCWhisperiser
extends LPCAnalysisResynthesis {
    protected double whisperAmount;
    protected double oneMinusWhisperAmount;

    public LPCWhisperiser(int predictionOrder, double amount) {
        super(predictionOrder);
        this.whisperAmount = MathUtils.trimToRange(amount, 0.0, 1.0);
        this.oneMinusWhisperAmount = 1.0 - this.whisperAmount;
    }

    public LPCWhisperiser(int predictionOrder) {
        super(predictionOrder);
        this.whisperAmount = 1.0;
    }

    @Override
    protected void processLPC(LpcAnalyser.LpCoeffs coeffs, double[] residual) {
        double totalResidualEnergy = coeffs.getGain() * coeffs.getGain();
        double avgAbsAmplitude = Math.sqrt(totalResidualEnergy / (double)residual.length);
        double maxAbsAmplitude = 2.0 * avgAbsAmplitude;
        double spread = 2.0 * maxAbsAmplitude;
        int i = 0;
        while (i < residual.length) {
            residual[i] = this.whisperAmount * spread * (Math.random() - 0.5) + this.oneMinusWhisperAmount * residual[i];
            ++i;
        }
    }

    public static void main(String[] args) throws Exception {
        int i = 0;
        while (i < args.length) {
            AudioInputStream inputAudio = AudioSystem.getAudioInputStream(new File(args[i]));
            int samplingRate = (int)inputAudio.getFormat().getSampleRate();
            AudioDoubleDataSource signal = new AudioDoubleDataSource(inputAudio);
            int frameLength = Integer.getInteger("signalproc.lpcanalysissynthesis.framelength", 512);
            int predictionOrder = Integer.getInteger("signalproc.lpcwhisperiser.predictionorder", 20);
            FrameOverlapAddSource foas = new FrameOverlapAddSource(signal, 3, true, frameLength, samplingRate, new LPCWhisperiser(predictionOrder));
            DDSAudioInputStream outputAudio = new DDSAudioInputStream(new BufferedDoubleDataSource(foas), inputAudio.getFormat());
            String outFileName = String.valueOf(args[i].substring(0, args[i].length() - 4)) + "_lpcwhisperised.wav";
            AudioSystem.write((AudioInputStream)outputAudio, AudioFileFormat.Type.WAVE, new File(outFileName));
            ++i;
        }
    }
}

