/*
 * Decompiled with CFR 0.152.
 */
package marytts.client;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import marytts.client.AudioEffectControlData;

public class AudioEffectControlGUI {
    private AudioEffectControlData data;
    public JPanel mainPanel;
    public JCheckBox chkEnabled;
    public JTextField txtParams;
    public JButton btnHelp;
    private boolean isVisible;
    public boolean isHelpWindowOpen;
    private JFrame helpWindow;

    public AudioEffectControlGUI(AudioEffectControlData dataIn) {
        this.data = dataIn;
        this.mainPanel = new JPanel();
        this.chkEnabled = new JCheckBox();
        this.txtParams = new JTextField("Parameters");
        this.btnHelp = new JButton("?");
        this.isVisible = true;
        this.isHelpWindowOpen = false;
    }

    public void setVisible(boolean bShow) {
        this.isVisible = bShow;
    }

    public boolean getVisible() {
        return this.isVisible;
    }

    public AudioEffectControlData getData() {
        return this.data;
    }

    public void show() {
        this.mainPanel.removeAll();
        this.mainPanel.validate();
        if (this.isVisible) {
            GridBagLayout g = new GridBagLayout();
            GridBagConstraints c = new GridBagConstraints();
            this.mainPanel.setLayout(g);
            c.fill = 2;
            c.gridx = 0;
            c.gridy = 0;
            g.setConstraints(this.chkEnabled, c);
            this.chkEnabled.setPreferredSize(new Dimension(100, 25));
            this.chkEnabled.setText(this.data.getEffectName());
            this.chkEnabled.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AudioEffectControlGUI.this.data.setSelected(((JCheckBox)e.getSource()).isSelected());
                }
            });
            this.mainPanel.add(this.chkEnabled);
            c.gridx = 1;
            g.setConstraints(this.chkEnabled, c);
            this.txtParams.setPreferredSize(new Dimension(150, 25));
            this.txtParams.setText(this.data.getParams());
            this.mainPanel.add(this.txtParams);
            c.gridx = -1;
            g.setConstraints(this.btnHelp, c);
            this.btnHelp.setPreferredSize(new Dimension(45, 25));
            this.mainPanel.add(this.btnHelp);
            this.btnHelp.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (!AudioEffectControlGUI.this.isHelpWindowOpen) {
                        AudioEffectControlGUI.this.isHelpWindowOpen = true;
                        AudioEffectControlGUI.this.helpWindow = new JFrame("Help: " + AudioEffectControlGUI.this.chkEnabled.getText() + " Effect");
                        JTextArea helpTextArea = new JTextArea(AudioEffectControlGUI.this.data.getHelpText());
                        helpTextArea.setEditable(false);
                        AudioEffectControlGUI.this.helpWindow.getContentPane().add((Component)helpTextArea, "West");
                        AudioEffectControlGUI.this.helpWindow.pack();
                        AudioEffectControlGUI.this.helpWindow.setLocation(AudioEffectControlGUI.this.btnHelp.getLocation().x, AudioEffectControlGUI.this.btnHelp.getLocation().y);
                        AudioEffectControlGUI.this.helpWindow.setVisible(true);
                        AudioEffectControlGUI.this.helpWindow.addWindowListener(new WindowAdapter(){

                            @Override
                            public void windowClosing(WindowEvent winEvt) {
                                (this).AudioEffectControlGUI.this.isHelpWindowOpen = false;
                            }
                        });
                    } else if (AudioEffectControlGUI.this.helpWindow != null) {
                        AudioEffectControlGUI.this.helpWindow.requestFocus();
                    }
                }
            });
        }
        this.mainPanel.validate();
    }
}

