/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.util;

import de.mn77.base.data.type.Lib_Class;
import de.mn77.base.error.Err;
import de.mn77.base.sys.MOut;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.jaymo_lang.api.JMo_Object;
import org.jaymo_lang.error.DebugInfo;
import org.jaymo_lang.error.ParseError;
import org.jaymo_lang.object.I_Object;

public class ClassFinder {
    private static ClassFinder singleton = null;
    private HashMap<String, Class<?>> javaJMoClasses = null;
    private final ArrayList<String> javaImportPackage = new ArrayList();
    private final ArrayList<String> javaImportClass = new ArrayList();

    public static ClassFinder getInstance() {
        if (singleton == null) {
            singleton = new ClassFinder();
        }
        return singleton;
    }

    private ClassFinder() {
        this.reset();
    }

    public void describe() {
        MOut.print("Import packages:");
        MOut.print(this.javaImportPackage);
        MOut.print("Import classes:");
        MOut.print(this.javaImportClass);
        MOut.print("Classes:");
        MOut.print(this.javaJMoClasses);
    }

    public void reset() {
        this.javaJMoClasses = null;
        this.javaImportPackage.clear();
        this.javaImportClass.clear();
        this.javaImportPackage.add("java.lang");
        this.javaImportPackage.add("java.util");
    }

    public Class<?> searchJMoClass(String name) {
        if (this.javaJMoClasses == null) {
            try {
                this.javaJMoClasses = this.iSearchJMoClasses();
            }
            catch (Exception e) {
                throw Err.exit(e);
            }
        }
        return this.javaJMoClasses.get(name);
    }

    public Class<?> searchJavaClass(String name) {
        Class<?> result = Lib_Class.getClassByPath(this.javaImportClass, name);
        if (result != null) {
            return result;
        }
        result = Lib_Class.getClassByPackage(this.javaImportPackage, name);
        if (result != null) {
            this.javaImportClass.add(result.getCanonicalName());
        }
        return result;
    }

    public Class<?> searchJavaClassPath(String path) {
        try {
            return Class.forName(path);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public void addJavaImportClass(String path, DebugInfo debug) {
        this.iCheckJavaClassPath(path, true, debug);
        this.javaImportClass.add(path);
    }

    public void addJavaImportPackage(String path, DebugInfo debug) {
        this.iCheckJavaClassPath(path, false, debug);
        this.javaImportPackage.add(path);
    }

    private void iCheckJavaClassPath(String path, boolean isClass, DebugInfo debug) {
        int len = path.length();
        if (len <= 1) {
            throw new ParseError("Invalid Java classpath", "Got: " + path, debug);
        }
        char c = path.charAt(0);
        if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_')) {
            throw new ParseError("Invalid Java classpath", "Got: " + path, debug);
        }
        c = path.charAt(len - 1);
        if (c == '.' || c == '*') {
            throw new ParseError("Invalid Java classpath", "Got: " + path, debug);
        }
        int i = 1;
        while (i < len) {
            c = path.charAt(i);
            if (!(isClass && c == '$' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '.' || c >= '0' && c <= '9' || c == '_')) {
                throw new ParseError("Invalid Java classpath", "Got: " + path, debug);
            }
            ++i;
        }
    }

    private HashMap<String, Class<?>> iSearchJMoClasses() throws Exception {
        ArrayList classList = new ArrayList();
        try {
            CodeSource src = ClassFinder.class.getProtectionDomain().getCodeSource();
            ClassLoader classLoader = ClassFinder.class.getClassLoader();
            Consumer<String> add = line -> {
                String filename = line.substring(line.lastIndexOf(47) + 1);
                if (filename.endsWith(".class") && filename.startsWith("JMo_") && !filename.contains("$")) {
                    try {
                        String classPath = this.iPathConvert((String)line);
                        Class<?> c = classLoader.loadClass(classPath);
                        if (I_Object.class.isAssignableFrom(c) || JMo_Object.class.isAssignableFrom(c)) {
                            classList.add(c);
                        }
                    }
                    catch (ClassNotFoundException e) {
                        Err.show(e);
                        return;
                    }
                    catch (NoClassDefFoundError e) {
                        return;
                    }
                }
            };
            if (src.getLocation().toString().toLowerCase().endsWith(".jar")) {
                this.searchClassesFromJar(add);
            } else {
                this.searchClassesDirect(add);
            }
        }
        catch (Exception e) {
            Err.exit(e);
        }
        HashMap map = new HashMap();
        for (Class c : classList) {
            map.put(c.getSimpleName(), c);
        }
        return map;
    }

    private String iPathConvert(String line) {
        int start = line.startsWith("/") ? 1 : 0;
        line = line.replace('/', '.');
        return line.substring(start, line.lastIndexOf(46));
    }

    private void searchClassesDirect(Consumer<String> add) throws IOException, URISyntaxException, ClassNotFoundException {
        Enumeration<URL> eu = ClassFinder.class.getClassLoader().getResources("");
        while (eu.hasMoreElements()) {
            URI uri = eu.nextElement().toURI();
            Path myPath = Paths.get(uri);
            String base = myPath.toString();
            Stream<Path> walk = Files.walk(myPath, Integer.MAX_VALUE, new FileVisitOption[0]);
            Iterator it = walk.iterator();
            while (it.hasNext()) {
                String line = ((Path)it.next()).toString();
                line = line.substring(base.length());
                add.accept(line);
            }
            walk.close();
        }
    }

    private void searchClassesFromJar(Consumer<String> add) throws IOException, ClassNotFoundException {
        String classpath = System.getProperty("java.class.path");
        String[] paths = classpath.split(System.getProperty("path.separator"));
        ArrayList<String> scanned = new ArrayList<String>();
        String[] stringArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            if (!scanned.contains(path)) {
                scanned.add(path);
                File file = new File(path);
                if (file.isFile()) {
                    ZipEntry e;
                    FileInputStream is = new FileInputStream(file);
                    ZipInputStream zip = new ZipInputStream(is);
                    while ((e = zip.getNextEntry()) != null) {
                        add.accept(e.getName());
                    }
                    zip.close();
                }
            }
            ++n2;
        }
    }
}

