/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.object.struct;

import de.mn77.base.data.group.Group2;
import de.mn77.base.data.struct.set.MSet;
import java.util.ArrayList;
import java.util.Collection;
import org.jaymo_lang.error.CodeError;
import org.jaymo_lang.error.ExecError;
import org.jaymo_lang.model.Call;
import org.jaymo_lang.model.I_AutoBlockDo;
import org.jaymo_lang.model.I_AutoBlockList;
import org.jaymo_lang.model.ObjectCallResult;
import org.jaymo_lang.model.ObjectManager;
import org.jaymo_lang.object.A_Object;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.object.LoopHandle;
import org.jaymo_lang.object.atom.A_IntNumber;
import org.jaymo_lang.object.atom.Bool;
import org.jaymo_lang.object.atom.Dec;
import org.jaymo_lang.object.atom.I_AtomicValue;
import org.jaymo_lang.object.atom.Int;
import org.jaymo_lang.object.atom.Nil;
import org.jaymo_lang.object.atom.Str;
import org.jaymo_lang.object.pseudo.Return;
import org.jaymo_lang.object.struct.A_Sequence;
import org.jaymo_lang.object.struct.I_DeepGetSet;
import org.jaymo_lang.object.struct.JMo_List;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.runtime.STYPE;
import org.jaymo_lang.util.Lib_Convert;
import org.jaymo_lang.util.Lib_Error;
import org.jaymo_lang.util.Lib_Exec;
import org.jaymo_lang.util.Lib_Output;
import org.jaymo_lang.util.Lib_Sequence;
import org.jaymo_lang.util.Lib_StrFormat;
import org.jaymo_lang.util.Lib_Type;

public class JMo_Set
extends A_Sequence
implements I_AutoBlockDo,
I_AutoBlockList {
    private MSet<I_Object> set;
    private Call[] init;
    private String fixedType = null;

    public JMo_Set() {
        this.set = new MSet();
        this.init = null;
    }

    public JMo_Set(MSet<I_Object> set) {
        this.set = set;
        this.init = null;
    }

    public JMo_Set(I_Object[] oa) {
        this.set = new MSet();
        I_Object[] i_ObjectArray = oa;
        int n = oa.length;
        int n2 = 0;
        while (n2 < n) {
            I_Object o = i_ObjectArray[n2];
            this.set.add(o);
            ++n2;
        }
        this.init = null;
    }

    public JMo_Set(Call ... ca) {
        this.set = null;
        this.init = ca;
    }

    @Override
    public void init(CallRuntime cr) {
        if (this.init != null) {
            this.set = new MSet();
            Call[] callArray = this.init;
            int n = this.init.length;
            int n2 = 0;
            while (n2 < n) {
                Call ca = callArray[n2];
                I_Object o = cr.execInit(ca, this);
                o = Lib_Convert.getValue(cr, o);
                this.set.add(o);
                ++n2;
            }
            this.init = null;
        }
    }

    @Override
    protected ObjectCallResult call3(CallRuntime cr, String method) {
        switch (method) {
            case "+": 
            case "add": {
                return A_Object.stdResult(this.mAdd(cr));
            }
            case "take": {
                return A_Object.stdResult(this.mTake(cr));
            }
            case "delete": 
            case "-": {
                return A_Object.stdResult(this.mRemovePos(cr));
            }
            case "remove": 
            case "--": {
                return A_Object.stdResult(this.mRemoveItems(cr));
            }
            case "clear": {
                return A_Object.stdResult(this.mClear(cr));
            }
            case "addAll": {
                return A_Object.stdResult(this.mAddAll(cr));
            }
            case "subtractAll": 
            case "subAll": 
            case "removeAll": {
                return A_Object.stdResult(this.mSubAll(cr));
            }
            case "contains": {
                return A_Object.stdResult(this.mContains(cr));
            }
            case "each": {
                return this.each(cr);
            }
            case "combine": 
            case "implode": {
                return A_Object.stdResult(this.mImplode(cr));
            }
            case "format": {
                return A_Object.stdResult(this.mFormat(cr));
            }
            case "min": {
                return A_Object.stdResult(this.mMin(cr));
            }
            case "max": {
                return A_Object.stdResult(this.mMax(cr));
            }
            case "sum": {
                return A_Object.stdResult(this.mSum(cr));
            }
            case "average": 
            case "avg": {
                return A_Object.stdResult(this.mAverage(cr));
            }
            case "filter": {
                return A_Object.stdResult(this.mFilter(cr, method));
            }
            case "reduce": {
                return A_Object.stdResult(this.mReduce(cr, method));
            }
            case "amount": {
                return A_Object.stdResult(this.mAmount(cr, method));
            }
            case "fixType": {
                this.mFixType(cr);
                return A_Object.stdResult(this);
            }
            case "toList": {
                return A_Object.stdResult(this.mToList(cr));
            }
        }
        return null;
    }

    @Override
    public I_Object autoBlockDo(CallRuntime cr) {
        return this.each((CallRuntime)cr).obj;
    }

    @Override
    public ArrayList<I_Object> autoBlockToList(CallRuntime cr) {
        ArrayList<I_Object> al = new ArrayList<I_Object>(this.set.size());
        for (I_Object o : this.set) {
            al.add(o);
        }
        return al;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof JMo_Set) {
            MSet<I_Object> other = ((JMo_Set)obj).set;
            if (this.set.size() != other.size()) {
                return false;
            }
            int i = 1;
            while (i <= this.set.size()) {
                if (!((I_Object)this.set.get(i)).equals(other.get(i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean equalsLazy(Object obj) {
        return this.equals(obj);
    }

    private Bool mContains(CallRuntime cr) {
        I_Object o = cr.args(this, I_Object.class)[0];
        for (I_Object lo : this.set) {
            if (!lo.equals(o)) continue;
            return Bool.TRUE;
        }
        return Bool.FALSE;
    }

    @Override
    protected int sequenceSize() {
        return this.set.size();
    }

    @Override
    public String toString() {
        return "Set<" + this.set.size() + '>';
    }

    @Override
    public String toString(CallRuntime cr, STYPE type) {
        StringBuilder sb = new StringBuilder();
        sb.append("Set[");
        if (this.set != null) {
            for (I_Object o : this.set) {
                String s;
                String string = s = o == this ? "self" : o.toString(cr, type.getNested());
                if (type == STYPE.DESCRIBE) {
                    s = Lib_Output.indentLines(s, false);
                }
                sb.append(s);
                sb.append(',');
            }
            Lib_Output.removeEnd(sb, ',');
        }
        sb.append(']');
        return sb.toString();
    }

    private JMo_Set mAdd(CallRuntime cr) {
        I_Object[] oa = cr.argsVar(this, 1, 0);
        this.iFixedType(cr, oa);
        I_Object[] i_ObjectArray = oa;
        int n = oa.length;
        int n2 = 0;
        while (n2 < n) {
            I_Object o = i_ObjectArray[n2];
            this.set.add(o);
            ++n2;
        }
        return this;
    }

    private JMo_Set mTake(CallRuntime cr) {
        I_Object[] oa = cr.argsVar(this, 1, 0);
        this.iFixedType(cr, oa);
        I_Object[] i_ObjectArray = oa;
        int n = oa.length;
        int n2 = 0;
        while (n2 < n) {
            I_Object o = i_ObjectArray[n2];
            this.set.addIfUnknown(o);
            ++n2;
        }
        return this;
    }

    private JMo_Set mAddAll(CallRuntime cr) {
        A_Sequence other = (A_Sequence)cr.args(this, A_Sequence.class)[0];
        if (this.fixedType != null) {
            for (I_Object i_Object : other.getInternalCollection()) {
                this.iFixedType(cr, i_Object);
            }
        }
        this.set.addAll((Collection<I_Object>)other.getInternalCollection());
        return this;
    }

    private JMo_Set mSubAll(CallRuntime cr) {
        A_Sequence list2 = (A_Sequence)cr.args(this, A_Sequence.class)[0];
        this.set.removeAll(list2.getInternalCollection());
        return this;
    }

    private JMo_List mToList(CallRuntime cr) {
        cr.argsNone();
        return new JMo_List(this.autoBlockToList(cr));
    }

    @Override
    protected JMo_Set copy(CallRuntime cr) {
        cr.argsNone();
        MSet copy = (MSet)this.set.copy();
        return new JMo_Set(copy);
    }

    private ObjectCallResult each(CallRuntime crOld) {
        crOld.argsNone();
        if (crOld.getStream() == null && crOld.getCallBlock() == null) {
            throw new CodeError(crOld, "No Stream or Block for 'each'", null);
        }
        LoopHandle handle = new LoopHandle(this);
        CallRuntime crNew = crOld.copyLoop(handle);
        I_Object result = this;
        for (I_Object it : this.set) {
            handle.startLap();
            result = Lib_Exec.execBlockStream(crNew, it);
            result = Lib_Exec.loopResult(result);
            if (!(result instanceof Return)) continue;
            return ((Return)result).getLoopResult();
        }
        return new ObjectCallResult(result, true);
    }

    private JMo_List mFilter(CallRuntime cr, String method) {
        Lib_Error.ifArgs(cr.argCount(), 1, (Integer)2, cr, this);
        ArrayList<I_Object> result = new ArrayList<I_Object>();
        int p = 1;
        while (p <= this.set.size()) {
            I_Object test = (I_Object)this.set.get(p);
            Bool ok = (Bool)cr.copyEach(method).argsEach(this, 0, new I_Object[]{test}, Bool.class);
            if (ok.getValue().booleanValue()) {
                result.add(test);
            }
            ++p;
        }
        return new JMo_List(result);
    }

    private I_Object mReduce(CallRuntime cr, String method) {
        Lib_Error.ifArgs(cr.argCount(), 2, (Integer)3, cr, this);
        I_Object sum = cr.argsOneAdvance(this, 0, I_Object.class);
        for (I_Object test : this.set) {
            I_Object[] each = new I_Object[]{sum, test};
            sum = cr.copyEach(method).argsEach(this, 1, each, I_Object.class);
        }
        return sum;
    }

    private Int mAmount(CallRuntime cr, String method) {
        Lib_Error.ifArgs(cr.argCount(), 1, (Integer)2, cr, this);
        int result = 0;
        for (I_Object test : this.set) {
            Bool ok = (Bool)cr.copyEach(method).argsEach(this, 0, new I_Object[]{test}, Bool.class);
            if (!ok.getValue().booleanValue()) continue;
            ++result;
        }
        return new Int(result);
    }

    @Override
    protected I_Object getFirst(CallRuntime cr) {
        return this.set.size() == 0 ? Nil.NIL : (I_Object)this.set.get(0);
    }

    @Override
    protected I_Object getLast(CallRuntime cr) {
        int len = this.set.size();
        return len == 0 ? Nil.NIL : (I_Object)this.set.get(len - 1);
    }

    @Override
    protected I_Object mSequenceGetPull(CallRuntime cr, boolean lazy) {
        I_Object[] oa = cr.argsVar(this, 1, 0);
        if (oa.length == 1) {
            I_AtomicValue oav = (I_AtomicValue)cr.argType(oa[0], I_AtomicValue.class);
            int oi = Lib_Convert.getIntValue(cr, oav);
            int pos = Lib_Sequence.realPos(cr, oi, this.set.size(), lazy);
            return pos == -1 ? Nil.NIL : (I_Object)this.set.get(pos - 1);
        }
        return this.sequenceDeepGet(cr, oa, 0, lazy);
    }

    private Str mImplode(CallRuntime cr) {
        I_Object[] args = cr.argsFlex(this, 0, 1);
        if (args.length == 0) {
            StringBuilder sb = new StringBuilder();
            for (I_Object o : this.set) {
                sb.append(o.toString());
            }
            return new Str(sb.toString());
        }
        I_AtomicValue atomic = (I_AtomicValue)cr.argType(args[0], I_AtomicValue.class);
        String delimiter = Lib_Convert.getStringValue(cr, atomic);
        StringBuilder sb = new StringBuilder();
        int i = 1;
        while (i <= this.set.size()) {
            I_Object o = (I_Object)this.set.get(i);
            String s = Lib_Convert.getStringValue(cr, o);
            sb.append(s);
            if (i != this.set.size()) {
                sb.append(delimiter);
            }
            ++i;
        }
        return new Str(sb.toString());
    }

    @Override
    protected boolean sequenceEmpty() {
        return this.set.isEmpty();
    }

    private I_Object mMax(CallRuntime cr) {
        cr.argsNone();
        I_Object result_o = null;
        Double result_d = null;
        for (I_Object o : this.set) {
            double d = Lib_Convert.getDoubleValue(cr, o);
            if (result_o != null && !(d > result_d)) continue;
            result_o = o;
            result_d = d;
        }
        return result_o;
    }

    private I_Object mMin(CallRuntime cr) {
        cr.argsNone();
        I_Object result_o = null;
        Double result_d = null;
        for (I_Object o : this.set) {
            double d = Lib_Convert.getDoubleValue(cr, o);
            if (result_o != null && !(d < result_d)) continue;
            result_o = o;
            result_d = d;
        }
        return result_o;
    }

    private I_Object mAverage(CallRuntime cr) {
        cr.argsNone();
        double result = 0.0;
        for (I_Object o : this.set) {
            double d = Lib_Convert.getDoubleValue(cr, o);
            result += d / (double)this.set.size();
        }
        return new Dec(result);
    }

    private I_Object mSum(CallRuntime cr) {
        cr.argsNone();
        double result = 0.0;
        for (I_Object o : this.set) {
            result += Lib_Convert.getDoubleValue(cr, o);
        }
        return new Dec(result);
    }

    private JMo_Set mRemoveItems(CallRuntime cr) {
        I_Object[] oa;
        I_Object[] i_ObjectArray = oa = cr.argsVar(this, 1, 0);
        int n = oa.length;
        int n2 = 0;
        while (n2 < n) {
            I_Object o = i_ObjectArray[n2];
            int i = this.set.size();
            while (i > 0) {
                if (((I_Object)this.set.get(i)).equals(o)) {
                    this.set.removePosition(i);
                }
                --i;
            }
            ++n2;
        }
        return this;
    }

    private JMo_Set mRemovePos(CallRuntime cr) {
        Int o = (Int)cr.args(this, Int.class)[0];
        int oi = Lib_Convert.getIntValue(cr, o);
        Lib_Error.ifNotBetween(cr, 1, this.set.size(), oi, "position");
        this.set.removePosition(oi);
        return this;
    }

    private JMo_Set mClear(CallRuntime cr) {
        cr.argsNone();
        this.set.clear();
        return this;
    }

    @Override
    protected void mSequenceSetPut(CallRuntime cr, boolean lazy) {
        I_Object[] oa = cr.argsVar(this, 2, 1);
        if (lazy && Lib_Convert.getIntValue(cr, oa[1]) > this.set.size() + 1) {
            throw new CodeError(cr, "Invalid use of put", "A set can be extended only by a maximum of one element.");
        }
        if (oa.length > 2) {
            this.sequenceDeepSet(cr, oa, 1, oa[0], lazy);
        } else {
            this.sequenceSet(cr, oa[1], oa[0], lazy);
        }
    }

    private Str mFormat(CallRuntime cr) {
        String form = ((Str)cr.args(this, Str.class)[0]).getValue();
        int setPos = 1;
        int formPos = 0;
        StringBuilder sb = new StringBuilder();
        while (formPos < form.length()) {
            Group2<Boolean, String> part = Lib_StrFormat.getNext(form, formPos);
            formPos += ((String)part.o2).length();
            if (!((Boolean)part.o1).booleanValue() || setPos > this.set.size()) {
                sb.append((String)part.o2);
                continue;
            }
            sb.append(Lib_StrFormat.format(cr, (String)part.o2, (I_Object)this.set.get(setPos++)));
        }
        return new Str(sb.toString());
    }

    private void mFixType(CallRuntime cr) {
        Str o = (Str)cr.args(this, Str.class)[0];
        String type = Lib_Convert.getStringValue(cr, o);
        if (!ObjectManager.isTypeKnown(cr, type)) {
            throw new ExecError(cr, "Unknown type", "Unknown type: " + type);
        }
        this.fixedType = type;
        int counter = 0;
        for (I_Object item : this.set) {
            ++counter;
            if (Lib_Type.isInstanceOf(item, this.fixedType)) continue;
            String sTypes = Lib_Type.typesToString(item);
            throw new ExecError(cr, "Invalid type of item in set", "Type \"" + this.fixedType + "\" needed, but types of item at position " + counter + " are: " + sTypes);
        }
    }

    private void iFixedType(CallRuntime cr, I_Object[] oa) {
        if (this.fixedType != null) {
            I_Object[] i_ObjectArray = oa;
            int n = oa.length;
            int n2 = 0;
            while (n2 < n) {
                I_Object obj = i_ObjectArray[n2];
                this.iFixedType(cr, obj);
                ++n2;
            }
        }
    }

    private void iFixedType(CallRuntime cr, I_Object obj) {
        if (this.fixedType != null && !Lib_Type.isInstanceOf(obj, this.fixedType)) {
            throw new ExecError(cr, "Invalid object type for fixed Set.", "This Set accepts only <" + this.fixedType + ">, but got object with type: " + Lib_Type.getTypeString(obj));
        }
    }

    @Override
    public I_Object sequenceDeepGet(CallRuntime cr, I_Object[] keys, int offset, boolean lazy) {
        A_IntNumber oi = (A_IntNumber)cr.argType(keys[offset], A_IntNumber.class);
        int i = Lib_Convert.getIntValue(cr, oi);
        int pos = Lib_Sequence.realPos(cr, i, this.set.size(), lazy);
        if (pos == -1 || pos > this.set.size()) {
            if (lazy) {
                return Nil.NIL;
            }
            Lib_Error.ifNotBetween(cr, 1, this.set.size(), pos, "position in list");
        }
        if (offset == keys.length - 1) {
            return (I_Object)this.set.get(pos - 1);
        }
        I_Object deeper = (I_Object)this.set.get(pos - 1);
        if (!(deeper instanceof I_DeepGetSet)) {
            StringBuilder sb = new StringBuilder();
            int j = 0;
            while (j <= offset) {
                if (j > 0) {
                    sb.append(',');
                }
                sb.append(keys[j].toString());
                ++j;
            }
            throw new ExecError(cr, "Invalid type of item.", "Item at position (" + sb.toString() + ") isn't a sequence, so I can't go into it!");
        }
        return ((I_DeepGetSet)((Object)deeper)).sequenceDeepGet(cr, keys, offset + 1, lazy);
    }

    @Override
    public void sequenceDeepSet(CallRuntime cr, I_Object[] keys, int offset, I_Object value, boolean lazy) {
        A_IntNumber oi = (A_IntNumber)cr.argType(keys[offset], A_IntNumber.class);
        int wanted = Lib_Convert.getIntValue(cr, oi);
        if (lazy) {
            while (Math.abs(wanted) > this.set.size()) {
                this.set.add(Nil.NIL);
            }
        }
        int pos = Lib_Sequence.realPos(cr, wanted, this.set.size(), lazy);
        Lib_Error.ifNotBetween(cr, 1, this.set.size(), pos, "position");
        if (offset == keys.length - 1) {
            this.set.set(pos - 1, value);
        } else {
            I_Object deeper = (I_Object)this.set.get(pos - 1);
            if (deeper == Nil.NIL && lazy) {
                deeper = new JMo_Set();
                this.set.set(pos - 1, deeper);
            }
            if (!(deeper instanceof A_Sequence)) {
                throw new ExecError(cr, "Invalid type of item.", "Item at position " + (offset + 1) + " isn't a sequence, so I can't go into it!");
            }
            A_Sequence deeper2 = (A_Sequence)deeper;
            deeper2.sequenceDeepSet(cr, keys, offset + 1, value, lazy);
        }
    }

    @Override
    protected I_Object sequenceSelectGet(CallRuntime cr, I_Object key, boolean lazy) {
        int oi = Lib_Convert.getIntValue(cr, key);
        int pos = Lib_Sequence.realPos(cr, oi, this.set.size(), lazy);
        return pos == -1 ? Nil.NIL : (I_Object)this.set.get(pos - 1);
    }

    @Override
    protected void sequenceSet(CallRuntime cr, I_Object pos2, I_Object o, boolean lazy) {
        int wanted = Lib_Convert.getIntValue(cr, pos2);
        if (lazy) {
            while (Math.abs(wanted) > this.set.size()) {
                this.set.add(Nil.NIL);
            }
        }
        int pos = Lib_Sequence.realPos(cr, wanted, this.set.size(), lazy);
        Lib_Error.ifNotBetween(cr, 1, this.set.size(), pos, "position");
        this.set.set(pos - 1, o);
    }

    @Override
    protected Collection<? extends I_Object> getInternalCollection() {
        return this.set;
    }
}

