/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.object.atom;

import de.mn77.base.data.bigcalc.Lib_BigCalc;
import de.mn77.base.error.Err;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import org.jaymo_lang.error.ExecError;
import org.jaymo_lang.model.ObjectCallResult;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.object.LoopHandle;
import org.jaymo_lang.object.atom.A_Atomic;
import org.jaymo_lang.object.atom.A_IntNumber;
import org.jaymo_lang.object.atom.A_Number;
import org.jaymo_lang.object.atom.Dec;
import org.jaymo_lang.object.atom.I_Atomic;
import org.jaymo_lang.object.atom.I_Integer;
import org.jaymo_lang.object.atom.JMo_BigDec;
import org.jaymo_lang.object.atom.JMo_BigInt;
import org.jaymo_lang.object.atom.NOP0;
import org.jaymo_lang.object.atom.NOP1;
import org.jaymo_lang.object.pseudo.Return;
import org.jaymo_lang.object.struct.JMo_ByteArray;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.runtime.STYPE;
import org.jaymo_lang.util.ATOMIC;
import org.jaymo_lang.util.Lib_AtomicCalc;
import org.jaymo_lang.util.Lib_Convert;
import org.jaymo_lang.util.Lib_Exec;

public class JMo_Long
extends A_IntNumber
implements I_Integer,
I_Atomic {
    private final long value;

    public JMo_Long(long val) {
        this.value = val;
    }

    @Override
    public ATOMIC getEnum() {
        return ATOMIC.LONG;
    }

    @Override
    protected ObjectCallResult call5(CallRuntime cr, String method) {
        return null;
    }

    @Override
    public Long getValue() {
        return this.value;
    }

    @Override
    public int getIntValue(CallRuntime cr) {
        if (this.value < Integer.MIN_VALUE || this.value > Integer.MAX_VALUE) {
            throw new ExecError(cr, "Value out of Integer-Range", "" + this.value);
        }
        return (int)this.value;
    }

    @Override
    public String toString(CallRuntime cr, STYPE type) {
        switch (type) {
            case REGULAR: 
            case NESTED: {
                return "" + this.value;
            }
        }
        return String.valueOf(this.value) + "l";
    }

    @Override
    protected A_Number numberCalc0(CallRuntime cr, NOP0 op) {
        switch (op) {
            case NEG: {
                return new JMo_Long(this.value ^ 0xFFFFFFFFFFFFFFFFL);
            }
            case ABS: {
                return new JMo_Long(Math.abs(this.value));
            }
            case EXP: {
                return new JMo_BigDec(Lib_BigCalc.exp(new BigDecimal(this.value), JMo_BigDec.CONTEXT));
            }
            case INC: {
                return new JMo_Long(this.value + 1L);
            }
            case DEC: {
                return new JMo_Long(this.value - 1L);
            }
            case POW: {
                return new JMo_Long(this.value * this.value);
            }
            case ROOT: {
                return new Dec(Math.sqrt(this.value));
            }
            case LOG10: {
                return new Dec(Math.log10(this.value));
            }
            case LOGN: {
                return new Dec(Math.log(this.value));
            }
        }
        throw Err.impossible(new Object[]{op});
    }

    @Override
    protected A_Number numberCalcSame(CallRuntime cr, A_Number num, boolean inc) {
        long arg = Lib_Convert.getLongValue(cr, num);
        return new JMo_Long(inc ? this.value + arg : this.value - arg);
    }

    @Override
    protected A_Number numberCalc1(CallRuntime cr, NOP1 op, A_Number paro) {
        if (paro instanceof I_Integer) {
            if (paro instanceof JMo_BigInt) {
                return Lib_AtomicCalc.numberCalcBigInt(cr, op, BigInteger.valueOf(this.value), ((JMo_BigInt)paro).getValue());
            }
            return Lib_AtomicCalc.numberCalcLong(cr, op, this.value, Lib_Convert.getLongValue(cr, paro));
        }
        if (paro instanceof JMo_BigDec) {
            return Lib_AtomicCalc.numberCalcBigDec(cr, op, BigDecimal.valueOf(this.value), ((JMo_BigDec)paro).getValue());
        }
        return Lib_AtomicCalc.numberCalcDec(cr, op, this.value, Lib_Convert.getDoubleValue(cr, paro));
    }

    @Override
    protected final ObjectCallResult mTimes(CallRuntime crOld, boolean reverse) {
        crOld.argsNone();
        Lib_Exec.checkLoopWithout(crOld);
        long value = this.getValue();
        LoopHandle handle = new LoopHandle(this, reverse ? "timesDown" : "timesUp");
        CallRuntime crNew = crOld.copyLoop(handle);
        I_Object result = this;
        if (reverse) {
            long i = value;
            while (i >= 1L) {
                handle.startLap();
                result = Lib_Exec.execBlockStream(crNew, new JMo_Long(i));
                result = Lib_Exec.loopResult(result);
                if (result instanceof Return) {
                    return ((Return)result).getLoopResult();
                }
                --i;
            }
        } else {
            long i = 1L;
            while (i <= value) {
                handle.startLap();
                result = Lib_Exec.execBlockStream(crNew, new JMo_Long(i));
                result = Lib_Exec.loopResult(result);
                if (result instanceof Return) {
                    return ((Return)result).getLoopResult();
                }
                ++i;
            }
        }
        return new ObjectCallResult(result, true);
    }

    @Override
    protected JMo_ByteArray toByteArray(CallRuntime cr) {
        byte[] bytes = ByteBuffer.allocate(8).putLong(this.value).array();
        return new JMo_ByteArray(bytes);
    }

    @Override
    protected A_Atomic getMinValue(CallRuntime cr) {
        return new JMo_Long(Long.MIN_VALUE);
    }

    @Override
    protected A_Atomic getMaxValue(CallRuntime cr) {
        return new JMo_Long(Long.MAX_VALUE);
    }
}

