/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.object.atom;

import de.mn77.base.data.Lib_Math;
import de.mn77.base.data.Lib_String;
import de.mn77.base.data.form.FormNumber;
import de.mn77.base.error.Err;
import org.jaymo_lang.error.CodeError;
import org.jaymo_lang.error.ExecError;
import org.jaymo_lang.model.COMPARE;
import org.jaymo_lang.model.ObjectCallResult;
import org.jaymo_lang.object.A_Object;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.object.atom.A_Atomic;
import org.jaymo_lang.object.atom.A_Chars;
import org.jaymo_lang.object.atom.A_IntNumber;
import org.jaymo_lang.object.atom.Bool;
import org.jaymo_lang.object.atom.Dec;
import org.jaymo_lang.object.atom.I_AtomicValue;
import org.jaymo_lang.object.atom.I_BigNumber;
import org.jaymo_lang.object.atom.I_Integer;
import org.jaymo_lang.object.atom.Int;
import org.jaymo_lang.object.atom.JMo_BigInt;
import org.jaymo_lang.object.atom.JMo_Long;
import org.jaymo_lang.object.atom.NOP0;
import org.jaymo_lang.object.atom.NOP1;
import org.jaymo_lang.object.atom.Nil;
import org.jaymo_lang.object.atom.Str;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.util.ATOMIC;
import org.jaymo_lang.util.Lib_AtomConv;
import org.jaymo_lang.util.Lib_Convert;
import org.jaymo_lang.util.Lib_Type;

public abstract class A_Number
extends A_Atomic {
    @Override
    protected final ObjectCallResult call3(CallRuntime cr, String method) {
        switch (method) {
            case "+": 
            case "add": {
                return A_Object.stdResult(this.mArithm(cr, NOP1.ADD, true));
            }
            case "-": 
            case "sub": {
                return A_Object.stdResult(this.mArithm(cr, NOP1.SUB, false));
            }
            case "*": 
            case "mul": {
                return A_Object.stdResult(this.mArithm(cr, NOP1.MUL, true));
            }
            case "/": 
            case "div": {
                return A_Object.stdResult(this.mArithm(cr, NOP1.DIV, false));
            }
            case "/~": 
            case "divFloor": 
            case "floorDiv": {
                return A_Object.stdResult(this.mDivFloor(cr));
            }
            case "%": 
            case "mod": {
                return A_Object.stdResult(this.mArithm(cr, NOP1.MOD, false));
            }
            case "log": {
                return A_Object.stdResult(this.mArithm(cr, NOP1.LOG, false));
            }
            case "ln": 
            case "logn": {
                return A_Object.stdResult(this.mArithm(cr, NOP0.LOGN));
            }
            case "log10": {
                return A_Object.stdResult(this.mArithm(cr, NOP0.LOG10));
            }
            case "exp": {
                return A_Object.stdResult(this.mArithm(cr, NOP0.EXP));
            }
            case "++": 
            case "inc": {
                return A_Object.stdResult(this.mArithmSame(cr, true));
            }
            case "--": 
            case "dec": {
                return A_Object.stdResult(this.mArithmSame(cr, false));
            }
            case "!": 
            case "neg": 
            case "not": {
                return A_Object.stdResult(this.mArithm(cr, NOP0.NEG));
            }
            case "abs": {
                return A_Object.stdResult(this.mArithm(cr, NOP0.ABS));
            }
            case "**": 
            case "pow": {
                return A_Object.stdResult(cr.hasArguments() ? this.mArithm(cr, NOP1.POW, false) : this.mArithm(cr, NOP0.POW));
            }
            case "sqrt": {
                cr.argsNone();
                return A_Object.stdResult(this.mArithm(cr, NOP0.ROOT));
            }
            case "//": 
            case "root": {
                return A_Object.stdResult(cr.hasArguments() ? this.mArithm(cr, NOP1.ROOT, false) : this.mArithm(cr, NOP0.ROOT));
            }
            case "roundDown": 
            case "~": 
            case "floor": {
                return A_Object.stdResult(this.mFloor(cr));
            }
            case "ceil": 
            case "roof": 
            case "roundUp": {
                return A_Object.stdResult(this.mRoof(cr));
            }
            case "\u2248": 
            case "round": {
                return A_Object.stdResult(this.mRound(cr));
            }
            case "style": {
                return A_Object.stdResult(this.mStyle(cr));
            }
            case "width": {
                return A_Object.stdResult(this.mWidth(cr));
            }
            case "limit": {
                return A_Object.stdResult(this.mLimit(cr));
            }
            case "cos": {
                cr.argsNone();
                this.noBigNumber(cr);
                return A_Object.stdResult(new Dec(Math.cos(((Number)this.getValue()).doubleValue())));
            }
            case "sin": {
                cr.argsNone();
                this.noBigNumber(cr);
                return A_Object.stdResult(new Dec(Math.sin(((Number)this.getValue()).doubleValue())));
            }
            case "tan": {
                cr.argsNone();
                this.noBigNumber(cr);
                return A_Object.stdResult(new Dec(Math.tan(((Number)this.getValue()).doubleValue())));
            }
            case "acos": {
                cr.argsNone();
                this.noBigNumber(cr);
                return A_Object.stdResult(new Dec(Math.acos(((Number)this.getValue()).doubleValue())));
            }
            case "asin": {
                cr.argsNone();
                this.noBigNumber(cr);
                return A_Object.stdResult(new Dec(Math.asin(((Number)this.getValue()).doubleValue())));
            }
            case "atan": {
                cr.argsNone();
                this.noBigNumber(cr);
                return A_Object.stdResult(new Dec(Math.atan(((Number)this.getValue()).doubleValue())));
            }
        }
        return this.call4(cr, method);
    }

    private void noBigNumber(CallRuntime cr) {
        if (this instanceof I_BigNumber) {
            throw new ExecError(cr, "Invalid type", "This function is currently not available for big numbers. Got " + this.getTypeName() + ", please try Int or Dec.");
        }
    }

    private I_Object mDivFloor(CallRuntime cr) {
        I_AtomicValue val = (I_AtomicValue)this.mArithm(cr, NOP1.DIV, false);
        int i = ((Int)(val = Lib_AtomConv.convert(cr, val, ATOMIC.INT))).getValue();
        return i >= 0 ? val : new Int(i - 1);
    }

    protected abstract ObjectCallResult call4(CallRuntime var1, String var2);

    protected abstract A_Number numberCalc0(CallRuntime var1, NOP0 var2);

    protected abstract A_Number numberCalc1(CallRuntime var1, NOP1 var2, A_Number var3);

    protected abstract A_Number numberCalcSame(CallRuntime var1, A_Number var2, boolean var3);

    @Override
    protected final Bool mComparsion(CallRuntime cr, COMPARE m) {
        I_Object paro = cr.argsExt(this, new Class[][]{{Bool.class, A_Number.class}})[0];
        double value = ((Number)this.getValue()).doubleValue();
        double arg = Lib_Convert.getDoubleValue(cr, paro);
        switch (m) {
            case G: {
                return Bool.getObject(value > arg);
            }
            case L: {
                return Bool.getObject(value < arg);
            }
            case GE: {
                return Bool.getObject(value >= arg);
            }
            case LE: {
                return Bool.getObject(value <= arg);
            }
        }
        throw Err.impossible(new Object[]{m});
    }

    @Override
    public final Integer compareTo3(I_AtomicValue o) {
        if (!(o instanceof A_Number)) {
            return null;
        }
        Double value = ((Number)this.getValue()).doubleValue();
        double arg = Lib_Convert.getDoubleValue(null, o);
        return value.compareTo(arg);
    }

    @Override
    protected Int getLength(CallRuntime cr) {
        String s = "" + this.getValue();
        return new Int(s.length());
    }

    private final A_Chars number_opStr(CallRuntime cr, NOP1 op, A_Atomic p) {
        String arg = Lib_Convert.getStringValue(cr, p);
        if (op == NOP1.ADD) {
            return new Str(this.getValue() + arg);
        }
        if (op == NOP1.MUL) {
            if (this.getValue() instanceof Double || this.getValue() instanceof Float) {
                throw new CodeError(cr, "Invalid type to multiply a <Char> or <Str>", "Got " + Lib_Type.getTypeString(this) + ", please use <Int>");
            }
            String s = Lib_String.sequence(arg, ((Number)this.getValue()).longValue());
            return new Str(s);
        }
        throw new CodeError(cr, "Unknown type or function", this.getValue() + " " + (Object)((Object)op) + " " + Lib_Type.getName(p));
    }

    private I_AtomicValue mArithm(CallRuntime cr, NOP0 op) {
        cr.argsNone();
        return this.numberCalc0(cr, op);
    }

    private I_AtomicValue mArithmSame(CallRuntime cr, boolean inc) {
        if (cr.hasArguments()) {
            A_Number num = (A_Number)cr.args(this, A_Number.class)[0];
            return this.numberCalcSame(cr, num, inc);
        }
        return this.numberCalc0(cr, inc ? NOP0.INC : NOP0.DEC);
    }

    private I_Object mArithm(CallRuntime cr, NOP1 op, boolean strPossible) {
        if (strPossible) {
            A_Atomic para = (A_Atomic)cr.args(this, A_Atomic.class)[0];
            if (para instanceof A_Number) {
                return this.numberCalc1(cr, op, (A_Number)para);
            }
            if (para instanceof Bool) {
                return this.numberCalc1(cr, op, new Int(Lib_Convert.getIntValue(cr, para)));
            }
            if (para instanceof Nil) {
                if (!(this instanceof I_Integer)) {
                    throw new CodeError(cr, "Invalid number for arithmetic Nil", "Only integer numbers are possible, but got: " + this.toString());
                }
                if (this instanceof JMo_Long || this instanceof JMo_BigInt) {
                    throw new CodeError(cr, "Invalid number for arithmetic Nil", "Long and BigInt are not allowed here: " + this.toString());
                }
                return Nil.arithmetic(cr, op, (Integer)this.getValue());
            }
            return this.number_opStr(cr, op, para);
        }
        A_Number parn = (A_Number)cr.args(this, A_Number.class)[0];
        return this.numberCalc1(cr, op, parn);
    }

    private Str mStyle(CallRuntime cr) {
        Str o = (Str)cr.args(this, Str.class)[0];
        String format = o.getValue();
        String number = this.getValue().toString();
        String result = "";
        int nPos = number.length() - 1;
        int fPos = format.length() - 1;
        while (fPos >= 0) {
            char f = format.charAt(fPos);
            if (fPos > 0 && format.charAt(fPos - 1) == '~') {
                result = String.valueOf(f) + result;
                --fPos;
            } else {
                switch (f) {
                    case '0': {
                        result = nPos >= 0 ? String.valueOf(number.charAt(nPos)) + result : "0" + result;
                        --nPos;
                        break;
                    }
                    case '#': {
                        result = nPos >= 0 ? String.valueOf(number.charAt(nPos)) + result : " " + result;
                        --nPos;
                        break;
                    }
                    case '?': {
                        if (nPos >= 0) {
                            result = String.valueOf(number.charAt(nPos)) + result;
                        }
                        --nPos;
                        break;
                    }
                    default: {
                        result = String.valueOf(f) + result;
                    }
                }
            }
            --fPos;
        }
        if (nPos >= 0) {
            result = String.valueOf(number.substring(0, nPos + 1)) + result;
        }
        return new Str(result);
    }

    private A_Number mLimit(CallRuntime cr) {
        double max;
        Class[] classArray = new Class[]{A_Number.class, A_Number.class};
        I_Object[] args = cr.args(this, classArray);
        double min = Lib_Convert.getDoubleValue(cr, args[0]);
        if (min > (max = Lib_Convert.getDoubleValue(cr, args[1]))) {
            throw new ExecError(cr, "Min. is greater than max.!", "Min.: " + min + "  Max.: " + max);
        }
        double d = ((Number)this.getValue()).doubleValue();
        if (d > max) {
            d = max;
        }
        if (d < min) {
            d = min;
        }
        return (A_Number)Lib_AtomConv.convert(cr, new Dec(d), this.getEnum());
    }

    private Str mWidth(CallRuntime cr) {
        I_Object arg = cr.args(this, A_IntNumber.class)[0];
        int width = Lib_Convert.getIntValue(cr, arg);
        Number raw = (Number)this.getValue();
        String form = FormNumber.right(width, raw.longValue());
        return new Str(form);
    }

    private Int mFloor(CallRuntime cr) {
        cr.argsNone();
        double value = ((Number)this.getValue()).doubleValue();
        return new Int((int)Math.floor(value));
    }

    private Int mRoof(CallRuntime cr) {
        cr.argsNone();
        double value = ((Number)this.getValue()).doubleValue();
        return new Int((int)Math.ceil(value));
    }

    private I_AtomicValue mRound(CallRuntime cr) {
        I_Object[] args = cr.argsFlex(this, 0, 1);
        double value = ((Number)this.getValue()).doubleValue();
        switch (args.length) {
            case 0: {
                return new Int((int)Math.round(value));
            }
            case 1: {
                int i = Lib_Convert.getIntValue(cr, args[0]);
                if (i < 0 || i > 10) {
                    throw new CodeError(cr, "Invalid argument", "Got " + i + ", allowed = 0-10");
                }
                return new Dec(Lib_Math.round(value, i));
            }
        }
        throw Err.impossible(new Object[0]);
    }
}

