/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.object;

import de.mn77.base.thread.MTimer;
import java.util.TimerTask;
import org.jaymo_lang.error.ExecError;
import org.jaymo_lang.model.ObjectCallResult;
import org.jaymo_lang.object.A_EventObject;
import org.jaymo_lang.object.A_Object;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.object.atom.A_IntNumber;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.util.Lib_Convert;

public class JMo_Cycle
extends A_EventObject
implements I_Object {
    private MTimer timer = null;

    @Override
    public void init(CallRuntime cr) {
        cr.getStrict().checkSandbox(cr, "Cycle");
    }

    @Override
    protected ObjectCallResult callMethod(CallRuntime cr, String method) {
        switch (method) {
            case "start": {
                this.mStart(cr);
                return A_Object.stdResult(this);
            }
            case "stop": {
                this.mStop(cr);
                return A_Object.stdResult(this);
            }
        }
        return null;
    }

    @Override
    public boolean validateEvent(CallRuntime cr, String event) {
        return event.equals("@cycle");
    }

    private void mStart(final CallRuntime cr) {
        I_Object arg = cr.args(this, A_IntNumber.class)[0];
        int ms = Lib_Convert.getIntValue(cr, arg);
        if (this.timer != null) {
            throw new ExecError(cr, "Cycle already running", "Please stop it first to start it new.");
        }
        this.timer = new MTimer();
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                if (cr.getApp().toBeTerminated()) {
                    JMo_Cycle.this.timer.stop();
                }
                JMo_Cycle.this.eventRun(cr, "@cycle", JMo_Cycle.this);
            }
        };
        this.timer.addCycle(ms, task);
    }

    private void mStop(CallRuntime cr) {
        cr.argsNone();
        if (this.timer == null) {
            return;
        }
        this.timer.stop();
        this.timer = null;
    }
}

