/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.model;

import de.mn77.base.data.group.Group2;
import de.mn77.base.error.Err;
import org.jaymo_lang.error.DebugInfo;
import org.jaymo_lang.model.Block;
import org.jaymo_lang.object.A_ObjectToString;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.object.passthrough.I_VarConst;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.runtime.STYPE;
import org.jaymo_lang.util.Lib_Function;
import org.jaymo_lang.util.Lib_Output;
import org.jaymo_lang.util.Lib_Prio;

public class Call
extends A_ObjectToString {
    public final DebugInfo debugInfo;
    public final I_Object object;
    public final String method;
    public final byte prio;
    public final Call[] argCalls;
    public final Block surrounding;
    private Block ownBlock = null;
    private Call stream = null;
    private I_VarConst blockStore = null;

    public Call(Block surrBlock, I_Object obj, DebugInfo debugInfo) {
        this(surrBlock, obj, null, null, debugInfo);
    }

    public Call(Block surrBlock, I_Object obj, String met, Call[] args, DebugInfo debugInfo) {
        if (met != null && met.length() == 0) {
            Err.invalid(met);
        }
        Err.ifNull(surrBlock);
        this.surrounding = surrBlock;
        this.object = obj;
        this.method = met;
        this.argCalls = args;
        this.prio = (byte)(met == null || args != null && args.length != 1 ? 99 : (int)Lib_Prio.streamPrio(met, debugInfo));
        this.debugInfo = debugInfo;
    }

    public Call searchLastCall() {
        if (this.method != null && Lib_Function.isVarFunction(this.method) > -1 && this.argCalls != null && this.argCalls.length > 0) {
            return this.argCalls[0].searchLastCall();
        }
        if (this.stream == null) {
            return this;
        }
        return this.stream.searchLastCall();
    }

    public int getArgCount() {
        return this.argCalls == null ? 0 : this.argCalls.length;
    }

    public void setBlock(Block b) {
        Err.ifNull(b);
        if (this.ownBlock != null) {
            Err.invalid(this.ownBlock, b);
        }
        this.ownBlock = b;
    }

    public Block getBlock() {
        return this.ownBlock;
    }

    public void setStream(Call c) {
        Err.ifNull(c);
        if (this.stream != null) {
            throw Err.invalid(this.toString(), this.stream, c);
        }
        this.stream = c;
    }

    public Call getStream() {
        return this.stream;
    }

    public boolean hasBlock() {
        return this.ownBlock != null;
    }

    public boolean hasStream() {
        return this.stream != null;
    }

    @Override
    public String toString() {
        Group2<String, Boolean> g = Lib_Output.toObjectWithFunction(null, this.object, this.method);
        String p = Lib_Output.toString(this.argCalls, true);
        if (p.length() != 0) {
            p = (Boolean)g.o2 != false ? " " + p : "(" + p + ")";
        }
        String a = this.ownBlock != null || this.stream != null ? "\u2026" : "";
        return String.valueOf((String)g.o1) + p + a;
    }

    @Override
    public String toString(CallRuntime cr, STYPE type) {
        switch (type) {
            case REGULAR: 
            case NESTED: {
                return this.toString();
            }
            case IDENT: {
                return this.toStringIdent(cr);
            }
            case DESCRIBE: {
                return this.toStringDescribe(cr);
            }
        }
        throw Err.impossible(new Object[]{type});
    }

    private String toStringDescribe(CallRuntime cr) {
        String s;
        StringBuilder sb = new StringBuilder();
        sb.append(this.toStringIdent(cr));
        sb.append('\n');
        if (this.ownBlock != null) {
            s = this.ownBlock.toString(cr, STYPE.DESCRIBE);
            s = Lib_Output.appShowPart(null, s);
            sb.append(s);
            sb.append('\n');
        }
        if (this.stream != null) {
            s = this.stream.toStringDescribe(cr);
            sb.append(s);
        }
        Lib_Output.removeEnd(sb, '\n');
        return sb.toString();
    }

    private String toStringIdent(CallRuntime cr) {
        String s;
        I_Object obj = this.object != null ? this.object : cr.getCurrentObject();
        Group2<String, Boolean> g = Lib_Output.toObjectWithFunction(cr, obj, this.method, true);
        String p = "";
        if (this.argCalls != null) {
            CharSequence[] argIdent = new String[this.argCalls.length];
            int i = 0;
            while (i < this.argCalls.length) {
                argIdent[i] = this.argCalls[i].toStringIdent(cr);
                ++i;
            }
            p = String.join((CharSequence)",", argIdent);
        }
        if (p.length() != 0) {
            p = (Boolean)g.o2 != false ? " " + p : "(" + p + ")";
        }
        String b = this.ownBlock == null ? "" : "{<Block>}";
        String string = s = this.stream == null ? "" : "\u2026";
        if (this.method == null && this.ownBlock == null && this.stream == null) {
            return String.valueOf((String)g.o1) + p;
        }
        return String.valueOf((String)g.o1) + p + b + s;
    }

    public void setBlockStore(I_VarConst vc) {
        this.blockStore = vc;
    }

    public I_VarConst getBlockStore() {
        return this.blockStore;
    }

    public Call copy(I_Object obj, String method, Call[] args) {
        Call c2 = new Call(this.surrounding, obj, method, args, this.debugInfo);
        if (this.hasBlock()) {
            c2.setBlock(this.getBlock());
        }
        if (this.hasStream()) {
            c2.setStream(this.getStream());
        }
        if (this.blockStore != null) {
            c2.setBlockStore(this.blockStore);
        }
        return c2;
    }
}

