/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.lib.swing.tools;

import java.awt.Font;
import java.awt.GraphicsEnvironment;
import org.jaymo_lang.model.ArgCallBuffer;
import org.jaymo_lang.model.Call;
import org.jaymo_lang.object.A_ObjectSimple;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.object.atom.A_IntNumber;
import org.jaymo_lang.object.atom.Str;
import org.jaymo_lang.object.struct.JMo_List;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.runtime.STYPE;
import org.jaymo_lang.util.Lib_Convert;
import org.jaymo_lang.util.Lib_Java;
import org.jaymo_lang.util.Lib_Type;

public class JMo_Swing_Font
extends A_ObjectSimple {
    private final ArgCallBuffer par_name;
    private final ArgCallBuffer par_size;
    private String name = "SansSerif";
    private int size = 16;
    private boolean bold = false;
    private boolean italic = false;

    public JMo_Swing_Font() {
        this.par_name = null;
        this.par_size = null;
    }

    public JMo_Swing_Font(Call fontname, Call size) {
        this.par_name = new ArgCallBuffer(0, fontname);
        this.par_size = new ArgCallBuffer(1, size);
    }

    @Override
    public void init(CallRuntime cr) {
        if (this.par_name != null) {
            this.name = Lib_Convert.getStringValue(cr, this.par_name.init(cr, this, Str.class));
        }
        if (this.par_size != null) {
            this.size = Lib_Convert.getIntValue(cr, this.par_size.init(cr, this, A_IntNumber.class));
        }
    }

    @Override
    protected I_Object call3(CallRuntime cr, String method) {
        switch (method) {
            case "getFonts": {
                return this.fGetFonts(cr);
            }
            case "setRegular": 
            case "setPlain": {
                cr.argsNone();
                this.bold = false;
                this.italic = false;
                return this;
            }
            case "setBold": {
                cr.argsNone();
                this.bold = true;
                return this;
            }
            case "setItalic": {
                cr.argsNone();
                this.italic = true;
                return this;
            }
        }
        return null;
    }

    public Font getFont() {
        int style = 0;
        if (this.bold) {
            style |= 1;
        }
        if (this.italic) {
            style |= 2;
        }
        return new Font(this.name, style, this.size);
    }

    @Override
    public String toString(CallRuntime cr, STYPE type) {
        StringBuilder sb = new StringBuilder();
        switch (type) {
            case IDENT: {
                return Lib_Type.getName(this);
            }
            case DESCRIBE: {
                sb.append(Lib_Type.getName(this.getClass(), this));
                sb.append("(");
                sb.append(this.name);
                sb.append(',');
                sb.append(this.size);
                if (this.bold) {
                    sb.append(",bold");
                }
                if (this.italic) {
                    sb.append(",italic");
                }
                sb.append(")");
                return sb.toString();
            }
        }
        sb.append(this.name);
        sb.append(':');
        sb.append(this.size);
        if (this.bold) {
            sb.append(":bold");
        }
        if (this.italic) {
            sb.append(":italic");
        }
        return sb.toString();
    }

    private JMo_List fGetFonts(CallRuntime cr) {
        cr.argsNone();
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] fontList = ge.getAvailableFontFamilyNames();
        return (JMo_List)Lib_Java.javaToJmo(fontList);
    }
}

