/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.error;

import de.mn77.base.data.convert.ConvObject;
import de.mn77.base.data.convert.ConvSequence;
import de.mn77.base.debug.DEBUG_LEVEL;
import de.mn77.base.error.Err;
import de.mn77.base.error.I_ErrorDetails;
import de.mn77.base.error.I_ErrorInfo;
import de.mn77.base.sys.MOut;
import java.util.ArrayList;
import org.jaymo_lang.error.DebugInfo;
import org.jaymo_lang.error.ErrorBase;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.runtime.Instance;
import org.jaymo_lang.runtime.STYPE;
import org.jaymo_lang.util.Lib_Error;

public abstract class ErrorBaseDebug
extends ErrorBase
implements I_ErrorDetails,
I_ErrorInfo {
    private static final long serialVersionUID = 8587625424636880857L;
    private final DebugInfo source;
    private final String call;
    private final Instance instance;
    private final String instanceStringNested;
    private StackTraceElement[] ste = null;

    protected ErrorBaseDebug(String message, String detail, CallRuntime cr, DebugInfo source) {
        super(message, detail);
        this.source = source;
        this.call = cr == null || cr.call == null ? null : cr.call.toString(cr, STYPE.IDENT);
        this.instance = cr == null ? null : cr.instance;
        this.instanceStringNested = this.instance == null ? null : this.instance.toString(cr, STYPE.IDENT);
    }

    @Override
    public Iterable<Object> getDetails() {
        ArrayList<Object> list = new ArrayList<Object>();
        if (this.getDetail() != null) {
            list.add("Detail  : " + this.iLimit(this.getDetail()));
        }
        if (this.source != null && this.source.getRawFile() != null) {
            list.add("File    : " + this.source.getRawFile());
        }
        if (this.source != null && this.source.getRawLine() != null) {
            list.add("Line    : " + this.source.getRawLine());
        }
        if (this.call != null) {
            list.add("Call    : " + this.iLimit(this.call));
        }
        if (this.instanceStringNested != null) {
            list.add("Instance: " + this.instanceStringNested);
        }
        if (this.ste != null && MOut.getDebugLevel() != DEBUG_LEVEL.NO) {
            StackTraceElement[] stackTraceElementArray = this.ste;
            int n = this.ste.length;
            int n2 = 0;
            while (n2 < n) {
                StackTraceElement e = stackTraceElementArray[n2];
                list.add("   @ " + e.toString());
                ++n2;
            }
        }
        return list;
    }

    public abstract String getErrorTypeInfo();

    public String getCall() {
        return this.call;
    }

    public String getInstance() {
        return this.instance.toString();
    }

    public String getSource() {
        return "" + this.source;
    }

    @Override
    public void addDetail(Object ... oa) {
        Err.todo(oa);
    }

    public void addTrace(StackTraceElement[] ste) {
        this.ste = ste;
    }

    @Override
    public String toInfo() {
        ArrayList<String> list = new ArrayList<String>();
        String className = this.getClass().getSimpleName();
        String grp = String.valueOf(this.getErrorTypeInfo()) + " (" + className + ")";
        list.add("Error   : " + grp);
        list.add("Message : " + Lib_Error.collectMessages(this));
        for (Object d : this.getDetails()) {
            list.add(ConvObject.toText(d));
        }
        return ConvSequence.toText(MOut.getLineBreak(), list);
    }

    private String iLimit(String s) {
        int max = 400;
        return s.length() < 400 ? s : String.valueOf(s.substring(0, 400)) + "...";
    }
}

