/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.base.data.type.datetime;

import de.mn77.base.data.filter.FilterString;
import de.mn77.base.data.form.FormDateTime;
import de.mn77.base.data.type.A_DataType;
import de.mn77.base.data.type.datetime.I_Date;
import de.mn77.base.data.type.datetime.I_DateTime;
import de.mn77.base.data.type.datetime.I_Time;
import de.mn77.base.data.type.datetime.Lib_DateTime;
import de.mn77.base.data.type.datetime.MDate;
import de.mn77.base.data.type.datetime.MTime;
import de.mn77.base.data.type.datetime.format.FORM_DATETIME;
import de.mn77.base.error.Err;
import de.mn77.base.error.Err_Runtime;
import java.util.Calendar;
import java.util.GregorianCalendar;

public class MDateTime
extends A_DataType<I_DateTime>
implements I_DateTime {
    private final I_Date date;
    private final I_Time time;

    public MDateTime() {
        this.date = new MDate();
        this.time = new MTime();
    }

    public MDateTime(I_Date date, I_Time time) {
        Err.ifNull(date, time);
        this.date = date;
        this.time = time;
    }

    public MDateTime(int year, int month, int day, int hour, int min, int sec) {
        this.date = new MDate(year, month, day);
        this.time = new MTime(hour, min, sec, 0);
    }

    public MDateTime(int year, int month, int day, int hour, int min, int sec, int msec) {
        this.date = new MDate(year, month, day);
        this.time = new MTime(hour, min, sec, msec);
    }

    public MDateTime(Calendar c) {
        Err.ifNull(c);
        this.date = new MDate(c);
        this.time = new MTime(c);
    }

    public MDateTime(long milliSec) {
        GregorianCalendar c = new GregorianCalendar();
        c.setTimeInMillis(milliSec);
        this.date = new MDate(c);
        this.time = new MTime(c);
    }

    public MDateTime(String s) {
        s = s.trim();
        Err.ifEmpty(s);
        if (s.length() < 10) {
            throw Err.invalid("String too short!", s);
        }
        try {
            if (s.charAt(10) == ' ') {
                String datestring = s.substring(0, 10);
                this.date = new MDate(datestring);
                String timestring = s.substring(11);
                int tsLen = timestring.length();
                if (tsLen == 5 || tsLen == 8 || tsLen == 12) {
                    this.time = new MTime(timestring);
                    return;
                }
            } else if (s.matches("[1-2][0-9][0-9][0-9][0-1][0-9][0-3][0-9][0-2][0-9][0-5][0-9][0-5][0-9]")) {
                this.date = new MDate(String.valueOf(FilterString.cut(1, 4, s)) + "-" + FilterString.cut(5, 2, s) + "-" + FilterString.cut(7, 2, s));
                this.time = new MTime(String.valueOf(FilterString.cut(9, 2, s)) + ":" + FilterString.cut(11, 2, s) + ":" + FilterString.cut(13, 2, s));
                return;
            }
            throw Err.invalid("Unknown format!", s);
        }
        catch (Err_Runtime f) {
            throw f;
        }
        catch (Exception e) {
            throw Err.invalid("Invalid String!", s);
        }
    }

    @Override
    public I_Time getTime() {
        return this.time;
    }

    @Override
    public int getHours() {
        return this.time.getHours();
    }

    @Override
    public int getMinutes() {
        return this.time.getMinutes();
    }

    @Override
    public int getSeconds() {
        return this.time.getSeconds();
    }

    @Override
    public int getMilliSeconds() {
        return this.time.getMilliSeconds();
    }

    @Override
    public I_Date getDate() {
        return this.date;
    }

    @Override
    public int getYear() {
        return this.date.getYear();
    }

    @Override
    public int getMonth() {
        return this.date.getMonth();
    }

    @Override
    public int getDay() {
        return this.date.getDay();
    }

    @Override
    public int getDayOfWeek() {
        return this.date.getDayOfWeek();
    }

    @Override
    public long diffMilliSeconds(I_DateTime to) {
        long current = Lib_DateTime.toMilliSec(this.getYear(), this.getMonth(), this.getDay(), this.getHours(), this.getMinutes(), this.getSeconds(), this.getMilliSeconds());
        long other = Lib_DateTime.toMilliSec(to.getYear(), to.getMonth(), to.getDay(), to.getHours(), to.getMinutes(), to.getSeconds(), to.getMilliSeconds());
        return other - current;
    }

    @Override
    public long diffSeconds(I_DateTime to) {
        return this.diffMilliSeconds(to) / 1000L;
    }

    @Override
    public long diffMinutes(I_DateTime to) {
        return this.diffSeconds(to) / 60L;
    }

    @Override
    public long diffHours(I_DateTime to) {
        return this.diffMinutes(to) / 60L;
    }

    @Override
    public int diffDays(I_DateTime to) {
        return (int)this.diffHours(to) / 24;
    }

    @Override
    public int diffMonths(I_DateTime to) {
        throw Err.todo(this.date, this.time, to);
    }

    @Override
    public int diffYears(I_DateTime to) {
        throw Err.todo(this.date, this.time, to);
    }

    @Override
    public boolean isGreater(I_DateTime than) {
        long other;
        long current = Lib_DateTime.toMilliSec(this.getYear(), this.getMonth(), this.getDay(), this.getHours(), this.getMinutes(), this.getSeconds(), 0);
        long diff_ms = current - (other = Lib_DateTime.toMilliSec(than.getYear(), than.getMonth(), than.getDay(), than.getHours(), than.getMinutes(), than.getSeconds(), 0));
        return diff_ms > 0L;
    }

    @Override
    public String toString(Object ... format) {
        return FormDateTime.compose(this, format);
    }

    @Override
    public String toString() {
        return FormDateTime.compose(this, FORM_DATETIME.GROUP_DEFAULT_FULL);
    }

    @Override
    public String toStringDE() {
        return FormDateTime.composeDE(this);
    }

    @Override
    public String toStringFileSys() {
        return FormDateTime.composeFileSys(this);
    }

    @Override
    public String toStringShort() {
        return FormDateTime.composeShort(this);
    }

    @Override
    public boolean isEqual(I_DateTime dateTime) {
        return this.date.isEqual(dateTime.getDate()) && this.time.isEqual(dateTime.getTime());
    }

    @Override
    public I_DateTime getAddYears(int years) {
        long current = Lib_DateTime.addYears(this.getYear(), this.getMonth(), this.getDay(), this.getHours(), this.getMinutes(), this.getSeconds(), this.getMilliSeconds(), years);
        return new MDateTime(current);
    }

    @Override
    public I_DateTime getAddMonths(int months) {
        long current = Lib_DateTime.addMonths(this.getYear(), this.getMonth(), this.getDay(), this.getHours(), this.getMinutes(), this.getSeconds(), this.getMilliSeconds(), months);
        return new MDateTime(current);
    }

    @Override
    public I_DateTime getAddDays(int days) {
        long current = Lib_DateTime.addDays(this.getYear(), this.getMonth(), this.getDay(), this.getHours(), this.getMinutes(), this.getSeconds(), this.getMilliSeconds(), days);
        return new MDateTime(current);
    }

    @Override
    public I_DateTime getAddHours(long hours) {
        long current = this.getValueMilliSeconds();
        return new MDateTime(current += hours * 60L * 60L * 1000L);
    }

    @Override
    public I_DateTime getAddMinutes(long minutes) {
        long current = this.getValueMilliSeconds();
        return new MDateTime(current += minutes * 60L * 1000L);
    }

    @Override
    public I_DateTime getAddSeconds(long seconds) {
        long current = this.getValueMilliSeconds();
        return new MDateTime(current += seconds * 1000L);
    }

    @Override
    public I_DateTime getAddMilliSeconds(long milliseconds) {
        long current = this.getValueMilliSeconds();
        return new MDateTime(current += milliseconds);
    }

    @Override
    public I_DateTime getSetYear(int newYear) {
        return new MDateTime(newYear, this.date.getMonth(), this.date.getDay(), this.time.getHours(), this.time.getMinutes(), this.time.getSeconds());
    }

    @Override
    public I_DateTime getSetMonth(int newMonth) {
        return new MDateTime(this.date.getYear(), newMonth, this.date.getDay(), this.time.getHours(), this.time.getMinutes(), this.time.getSeconds());
    }

    @Override
    public I_DateTime getSetDay(int newDay) {
        return new MDateTime(this.date.getYear(), this.date.getMonth(), newDay, this.time.getHours(), this.time.getMinutes(), this.time.getSeconds());
    }

    @Override
    public I_DateTime getSetHour(int newHour) {
        return new MDateTime(this.date.getYear(), this.date.getMonth(), this.date.getDay(), newHour, this.time.getMinutes(), this.time.getSeconds());
    }

    @Override
    public I_DateTime getSetMinute(int newMinute) {
        return new MDateTime(this.date.getYear(), this.date.getMonth(), this.date.getDay(), this.time.getHours(), newMinute, this.time.getSeconds());
    }

    @Override
    public I_DateTime getSetSecond(int newSecond) {
        return new MDateTime(this.date.getYear(), this.date.getMonth(), this.date.getDay(), this.time.getHours(), this.time.getMinutes(), newSecond);
    }

    @Override
    public I_DateTime getSetMilliSecond(int newMilliSeconds) {
        return new MDateTime(this.date.getYear(), this.date.getMonth(), this.date.getDay(), this.time.getHours(), this.time.getMinutes(), this.time.getSeconds(), newMilliSeconds);
    }

    @Override
    public long getValueMilliSeconds() {
        return this.date.getValueMilliSeconds() + this.time.getValueMilliSeconds();
    }

    @Override
    public boolean usesMilliSeconds() {
        return this.time.usesMilliSeconds();
    }
}

