/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.parser.func;

import de.mn77.base.data.group.Group2;
import org.jaymo_lang.error.ParseError;
import org.jaymo_lang.model.Block;
import org.jaymo_lang.model.Call;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.object.passthrough.I_VarConst;
import org.jaymo_lang.object.pseudo.ConstLet;
import org.jaymo_lang.object.pseudo.VarLet;
import org.jaymo_lang.parser.Parser_Call;
import org.jaymo_lang.parser.Parser_Script;
import org.jaymo_lang.parser.func.I_ParseFunc;
import org.jaymo_lang.util.Lib_Parser;

public class ParseFunc_BlockVar
implements I_ParseFunc {
    @Override
    public boolean hits(char c0, String s) {
        return c0 == '\\';
    }

    @Override
    public Group2<Call, String> parse(Parser_Script parser, Block current, I_Object obj, String s, boolean isArgument) {
        int aLen;
        boolean twoSlashes = s.length() >= 2 && s.charAt(1) == '\\';
        String m = twoSlashes ? "\\\\" : "\\";
        String rem = s.substring(twoSlashes ? 2 : 1);
        String remTrimmed = rem.trim();
        Call[] argCalls = null;
        if (remTrimmed.length() > 0) {
            char r0 = rem.charAt(0);
            if (r0 == '(') {
                String args = Lib_Parser.group('(', ')', remTrimmed, parser.getDebugInfo());
                rem = remTrimmed.substring(1 + args.length() + 1);
                argCalls = Parser_Call.parseArguments(parser, current, args);
            } else {
                if (r0 == '\t') {
                    throw new ParseError("Invalid function call", "Please remove tab char before: " + remTrimmed, parser.getDebugInfo());
                }
                argCalls = Parser_Call.parseArguments(parser, current, remTrimmed);
                rem = null;
            }
        }
        int n = aLen = argCalls == null ? 0 : argCalls.length;
        if (rem != null && rem.trim().length() != 0) {
            throw new ParseError("Invalid function call", "No stream allowed here: " + rem, parser.getDebugInfo());
        }
        if (aLen > 0) {
            if (aLen > 1) {
                throw new ParseError("Invalid function call", "Only none or one argument is allowed here. Got: " + aLen, parser.getDebugInfo());
            }
            if (argCalls[0].hasStream()) {
                throw new ParseError("Invalid function call", "No stream allowed here!", parser.getDebugInfo());
            }
            if (argCalls[0].method != null) {
                throw new ParseError("Invalid function call", "No method allowed here! Got: " + argCalls[0].method, parser.getDebugInfo());
            }
        }
        Call c = new Call(current, obj, m, null, parser.getDebugInfo());
        if (aLen == 1) {
            I_Object argObj = argCalls[0].object;
            if (argObj instanceof I_VarConst) {
                c.setBlockStore((I_VarConst)argObj);
            } else if (argObj instanceof VarLet) {
                c.setBlockStore(((VarLet)argObj).getVar());
            } else if (argObj instanceof ConstLet) {
                c.setBlockStore(((ConstLet)argObj).getConst());
            } else {
                throw new ParseError("Invalid argument", "Argument must be a Variable, Constant, VarLet or a ConstLet. But got: " + argObj.getTypeName(), parser.getDebugInfo());
            }
        }
        return new Group2<Call, String>(c, rem);
    }
}

