/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.parser;

import org.jaymo_lang.error.ParseError;
import org.jaymo_lang.model.Block;
import org.jaymo_lang.model.Call;
import org.jaymo_lang.model.Type;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.object.immute.A_Immutable;
import org.jaymo_lang.object.immute.JMo_Enum;
import org.jaymo_lang.parser.Parser_Call;
import org.jaymo_lang.parser.Parser_Script;
import org.jaymo_lang.util.Lib_Enum;
import org.jaymo_lang.util.Lib_Parser;

public class Parser_Enum {
    public static void parse(Parser_Script parser, Type currentType, Block currentBlock, String s) {
        String name = Lib_Parser.getTypeName(s, parser);
        Lib_Enum.isValid(name, parser.getDebugInfo());
        String rem = s.substring(name.length());
        String remTrimmed = rem.trim();
        Call[] argCalls = null;
        if (remTrimmed.length() > 0) {
            String args;
            if (rem.charAt(0) == '(') {
                args = Lib_Parser.group('(', ')', remTrimmed, parser.getDebugInfo());
                if ((remTrimmed = remTrimmed.substring(1 + args.length() + 1).trim()).length() > 0) {
                    throw new ParseError("Invalid enum definition", "Invalid argument passing: " + rem, parser.getDebugInfo());
                }
                argCalls = Parser_Call.parseArguments(parser, currentBlock, args);
            } else if (remTrimmed.charAt(0) == '=') {
                args = remTrimmed.substring(1);
                argCalls = Parser_Call.parseArguments(parser, currentBlock, args);
            } else {
                throw new ParseError("Invalid enum definition", "Missing open bracket before: " + remTrimmed, parser.getDebugInfo());
            }
        }
        if (argCalls != null) {
            if (argCalls.length > 1) {
                throw new ParseError("Invalid enum definition", "Only 1 argument is allowed!", parser.getDebugInfo());
            }
            if (argCalls.length == 1) {
                void ac = argCalls[0];
                if (ac.method != null || ac.hasBlock() || ac.hasStream() || ac.argCalls != null) {
                    throw new ParseError("Invalid enum definition", "Invalid argument: " + ac.toString(), parser.getDebugInfo());
                }
                if (!(ac.object instanceof A_Immutable)) {
                    throw new ParseError("Invalid enum definition", "Argument is not immutable: " + ac.object.toString(), parser.getDebugInfo());
                }
            }
        }
        I_Object constant = argCalls == null || argCalls.length == 0 ? new JMo_Enum(currentType, s) : argCalls[0].object;
        currentType.addConstant(name, (A_Immutable)constant, parser.getDebugInfo());
        if (parser.buffer.nextLevelDiff() > 0) {
            throw new ParseError("Invalid block", "No block allowed for enum!", parser.getDebugInfo());
        }
    }
}

