/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.lib.xml;

import de.mn77.base.data.struct.table.I_Table;
import de.mn77.base.data.struct.table.MTable;
import java.util.ArrayList;
import org.jaymo_lang.error.ExecError;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.object.atom.Nil;
import org.jaymo_lang.object.atom.Str;
import org.jaymo_lang.object.struct.JMo_List;
import org.jaymo_lang.object.struct.JMo_Table;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.util.Lib_Convert;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Lib_XmlTextTable {
    public static JMo_Table createTextTable(CallRuntime cr, Document doc, JMo_List rows, JMo_List cols) {
        if (doc == null) {
            throw new ExecError(cr, "Nothing to read", "Read first");
        }
        ArrayList<String> rowsAL = new ArrayList<String>();
        for (I_Object o : rows.getInternalCollection()) {
            rowsAL.add(Lib_Convert.getStringValue(cr, o));
        }
        ArrayList<String[]> colsAL = new ArrayList<String[]>();
        for (I_Object o : cols.getInternalCollection()) {
            if (o instanceof JMo_List) {
                ArrayList<String> c2 = new ArrayList<String>();
                for (I_Object c2o : ((JMo_List)o).getInternalCollection()) {
                    c2.add(Lib_Convert.getStringValue(cr, c2o));
                }
                colsAL.add(c2.toArray(new String[c2.size()]));
                continue;
            }
            if (o instanceof Str) {
                colsAL.add(new String[]{Lib_Convert.getStringValue(cr, o)});
                continue;
            }
            throw new ExecError(cr, "Invalid row type", "" + o);
        }
        MTable<I_Object> result = new MTable<I_Object>(((ArrayList)cols.getInternalCollection()).size());
        Lib_XmlTextTable.iTextTableRow(result, doc.getChildNodes(), rowsAL.toArray(new String[rowsAL.size()]), 0, (String[][])colsAL.toArray((T[])new String[colsAL.size()][]));
        return new JMo_Table(result);
    }

    private static void iTextTableRow(I_Table<I_Object> tab, NodeList nodes, String[] row, int rowOffset, String[][] columns) {
        int idx = 0;
        while (idx < nodes.getLength()) {
            Node node = nodes.item(idx);
            if (node.getNodeName().equals(row[rowOffset])) {
                if (rowOffset == row.length - 1) {
                    I_Object[] rowData = new I_Object[columns.length];
                    Lib_XmlTextTable.iTextTableCols(rowData, node.getChildNodes(), columns);
                    int rowIdx = 0;
                    while (rowIdx < rowData.length) {
                        if (rowData[rowIdx] == null) {
                            rowData[rowIdx] = Nil.NIL;
                        }
                        ++rowIdx;
                    }
                    tab.add((I_Object[])rowData);
                } else {
                    Lib_XmlTextTable.iTextTableRow(tab, node.getChildNodes(), row, rowOffset + 1, columns);
                }
            }
            ++idx;
        }
    }

    private static void iTextTableCols(I_Object[] rowData, NodeList nodes, String[][] columns) {
        int idx = 0;
        while (idx < nodes.getLength()) {
            Node node = nodes.item(idx);
            String nodeName = node.getNodeName();
            if (!nodeName.equals("#text")) {
                int cidx = 0;
                while (cidx < columns.length) {
                    Lib_XmlTextTable.iTextTableCol(rowData, node, cidx, columns[cidx], 0);
                    ++cidx;
                }
            }
            ++idx;
        }
    }

    private static void iTextTableCol(I_Object[] rowData, Node node, int columnIndex, String[] column, int columnDepth) {
        if (!node.getNodeName().equals(column[columnDepth])) {
            return;
        }
        if (column.length == columnDepth + 1) {
            rowData[columnIndex] = new Str(node.getTextContent());
        } else if (node.hasChildNodes()) {
            NodeList childs = node.getChildNodes();
            int ci = 0;
            while (ci < childs.getLength()) {
                Lib_XmlTextTable.iTextTableCol(rowData, childs.item(ci), columnIndex, column, columnDepth + 1);
                ++ci;
            }
        }
    }
}

