/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.lib.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import org.jaymo_lang.error.ExecError;
import org.jaymo_lang.lib.swing.A_Swing_Frame;
import org.jaymo_lang.lib.swing.A_Swing_Object;
import org.jaymo_lang.lib.swing.I_Swing_Object;
import org.jaymo_lang.model.ArgCallBuffer;
import org.jaymo_lang.model.Call;
import org.jaymo_lang.model.ObjectCallResult;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.object.atom.A_IntNumber;
import org.jaymo_lang.object.atom.Int;
import org.jaymo_lang.object.atom.Nil;
import org.jaymo_lang.object.atom.Str;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.util.Lib_Convert;
import org.jaymo_lang.util.Lib_Java;

public class JMo_Swing_Dialog
extends A_Swing_Object {
    private JDialog dialog = null;
    private final ArgCallBuffer par_parent;
    private final ArgCallBuffer par_dx;
    private final ArgCallBuffer par_dy;
    private final ArgCallBuffer par_title;
    private STATE state = STATE.PREPARED;

    public JMo_Swing_Dialog(Call parent) {
        this.par_parent = new ArgCallBuffer(0, parent);
        this.par_dx = null;
        this.par_dy = null;
        this.par_title = null;
    }

    public JMo_Swing_Dialog(Call parent, Call title) {
        this.par_parent = new ArgCallBuffer(0, parent);
        this.par_dx = null;
        this.par_dy = null;
        this.par_title = title == null ? null : new ArgCallBuffer(1, title);
    }

    public JMo_Swing_Dialog(Call parent, Call dx, Call dy) {
        this.par_parent = new ArgCallBuffer(0, parent);
        this.par_dx = new ArgCallBuffer(1, dx);
        this.par_dy = new ArgCallBuffer(2, dy);
        this.par_title = null;
    }

    public JMo_Swing_Dialog(Call parent, Call dx, Call dy, Call title) {
        this.par_parent = new ArgCallBuffer(0, parent);
        this.par_dx = new ArgCallBuffer(1, dx);
        this.par_dy = new ArgCallBuffer(2, dy);
        this.par_title = new ArgCallBuffer(3, title);
    }

    @Override
    public Component getSwing() {
        return this.dialog;
    }

    @Override
    public void init(final CallRuntime cr) {
        A_Swing_Frame parent = this.par_parent.init(cr, this, A_Swing_Frame.class);
        this.dialog = new JDialog((Frame)parent.frame, true);
        this.dialog.setLayout(new GridLayout(0, 1));
        ImageIcon img = new ImageIcon(this.getClass().getClassLoader().getResource("jar/logo/jaymo_icon_256.png"));
        this.dialog.setIconImage(img.getImage());
        if (this.par_dx != null && this.par_dy != null) {
            int width = Lib_Convert.getIntValue(cr, this.par_dx.init(cr, this, A_IntNumber.class));
            int height = Lib_Convert.getIntValue(cr, this.par_dy.init(cr, this, A_IntNumber.class));
            this.dialog.setSize(width, height);
        }
        if (this.par_title != null) {
            String title = Lib_Convert.getStringValue(cr, this.par_title.init(cr, this, Str.class));
            this.dialog.setTitle(title);
        }
        this.dialog.addWindowListener(new WindowListener(){

            @Override
            public void windowClosing(WindowEvent e) {
            }

            @Override
            public void windowClosed(WindowEvent e) {
                JMo_Swing_Dialog.this.state = STATE.CLOSED;
                JMo_Swing_Dialog.this.eventRun(cr, "@close", Nil.NIL);
            }

            @Override
            public void windowOpened(WindowEvent e) {
            }

            @Override
            public void windowIconified(WindowEvent e) {
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
            }

            @Override
            public void windowActivated(WindowEvent e) {
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
            }
        });
    }

    @Override
    protected ObjectCallResult callEvent(CallRuntime cr, String event) {
        return null;
    }

    @Override
    protected final I_Object callMethod2(CallRuntime cr, String method) {
        if (this.state == STATE.CLOSED) {
            throw new ExecError(cr, "Illegal Frame-Access", "This Dialog is already closed");
        }
        switch (method) {
            case "add": {
                I_Object[] addObjs;
                I_Object[] i_ObjectArray = addObjs = cr.argsVar(this, 1, 0);
                int n = addObjs.length;
                int n2 = 0;
                while (n2 < n) {
                    I_Object o = i_ObjectArray[n2];
                    I_Swing_Object so = (I_Swing_Object)cr.argType(o, I_Swing_Object.class);
                    this.dialog.getContentPane().add(so.getSwing());
                    ++n2;
                }
                return this;
            }
            case "setSize": {
                this.mSize(cr, SIZE.CURRENT);
                return this;
            }
            case "setSizeMin": {
                this.mSize(cr, SIZE.MIN);
                return this;
            }
            case "setTitle": {
                String title = Lib_Convert.getStringValue(cr, cr.args(this, Str.class)[0]);
                this.dialog.setTitle(title);
                return this;
            }
            case "pack": {
                cr.argsNone();
                this.dialog.pack();
                return this;
            }
            case "close": 
            case "dispose": {
                cr.argsNone();
                this.mCloseFrame(cr, true);
                return Nil.NIL;
            }
            case "show": {
                this.mShow(cr, true);
                return this;
            }
            case "hide": {
                this.mShow(cr, false);
                return this;
            }
        }
        ObjectCallResult res = Lib_Java.mExec(cr, this.dialog, this.dialog.getClass(), method, this);
        if (res != null && res.obj == Nil.NIL) {
            return this;
        }
        return null;
    }

    protected void mCloseFrame(CallRuntime cr, boolean stateCheck) {
        if (stateCheck) {
            switch (this.state) {
                case PREPARED: {
                    throw new ExecError(cr, "Illegal Frame-Access", "This frame is not running.");
                }
                case CLOSED: {
                    throw new ExecError(cr, "Illegal Frame-Access", "This frame is closed.");
                }
            }
        }
        this.dialog.dispose();
        this.state = STATE.CLOSED;
    }

    @Override
    public boolean validateEvent(CallRuntime cr, String event) {
        switch (event) {
            case "@close": {
                return true;
            }
        }
        return false;
    }

    private void mShow(CallRuntime cr, boolean show) {
        cr.argsNone();
        if (show && this.state != STATE.RUNNING) {
            this.dialog.setLocationRelativeTo(null);
            this.dialog.setDefaultCloseOperation(2);
        }
        this.state = STATE.RUNNING;
        this.dialog.setVisible(show);
    }

    private JMo_Swing_Dialog mSize(CallRuntime cr, SIZE s) {
        I_Object[] args = cr.args(this, Int.class, Int.class);
        int dx = Lib_Convert.getIntValue(cr, args[0]);
        int dy = Lib_Convert.getIntValue(cr, args[1]);
        if (dx <= 0 || dy <= 0) {
            throw new ExecError(cr, "Value out of bounds", "Minimum of 1 useful, got " + dx + "/" + dy);
        }
        switch (s) {
            case CURRENT: {
                this.dialog.setSize(dx, dy);
                break;
            }
            case MIN: {
                this.dialog.setMinimumSize(new Dimension(dx, dy));
            }
        }
        return this;
    }

    private static enum SIZE {
        CURRENT,
        MIN;

    }

    protected static enum STATE {
        CLOSED,
        PREPARED,
        RUNNING;

    }
}

