/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.lib.config;

import de.mn77.base.data.convert.ConvObject;
import de.mn77.base.data.convert.ConvString;
import de.mn77.base.data.filter.FilterString;
import de.mn77.base.data.struct.list.I_List;
import de.mn77.base.data.struct.list.MList;
import de.mn77.base.error.Err;
import de.mn77.base.error.Err_FileSys;
import de.mn77.base.sys.file.I_File;
import de.mn77.lib.config.I_PropertiesFile_Read;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Properties;
import java.util.Set;

public class PropertiesFile
implements I_PropertiesFile_Read {
    private Properties prop;
    private final String title;
    private final I_File file;

    public PropertiesFile(String title, I_File file) {
        Err.ifNull(file);
        this.prop = new Properties();
        this.file = file;
        this.title = title;
    }

    public void read(boolean mustExist) throws Err_FileSys {
        InputStreamReader isr = null;
        try {
            try {
                if (this.file.exists()) {
                    isr = new InputStreamReader((InputStream)new FileInputStream(this.file.getFile()), "UTF-8");
                    this.prop.load(isr);
                } else if (mustExist) {
                    throw Err.fsFailed("File is missing", this.file);
                }
            }
            catch (IOException e) {
                throw Err.wrap(e, "Can't read config file.");
            }
        }
        finally {
            try {
                if (isr != null) {
                    isr.close();
                }
            }
            catch (IOException e) {
                Err.show(e);
            }
        }
    }

    public void write() throws Err_FileSys {
        OutputStreamWriter osw = null;
        try {
            try {
                osw = new OutputStreamWriter((OutputStream)this.file.write(), "UTF-8");
                this.prop.store(osw, this.title);
            }
            catch (Exception e) {
                throw Err.fsFailed(e, "Can't write config file");
            }
        }
        finally {
            try {
                if (osw != null) {
                    osw.close();
                }
            }
            catch (IOException e) {
                Err.show(e);
            }
        }
    }

    public void close() throws Err_FileSys {
        this.write();
        this.prop = null;
    }

    public I_List<String> getAllLabels() {
        Set<Object> keys = this.prop.keySet();
        MList<String> result = new MList<String>();
        keys.forEach(key -> result.add((String)key));
        return result;
    }

    public void remove(String wikiName) {
        this.prop.remove(wikiName);
    }

    @Override
    public String getString(String label) {
        return this.getStringStd(label, null);
    }

    @Override
    public String getStringStd(String label, String standard) {
        return this.prop.getProperty(this.iLable(label), standard);
    }

    @Override
    public Integer getInteger(String label) {
        return this.getIntegerStd(label, null);
    }

    @Override
    public Integer getIntegerStd(String label, Integer standard) {
        return ConvString.toInteger(this.getStringStd(label, "" + standard));
    }

    @Override
    public Boolean getBoolean(String label) {
        return this.getBooleanStd(label, null);
    }

    @Override
    public Boolean getBooleanStd(String label, Boolean standard) {
        return ConvString.toBoolean(this.getStringStd(label, "" + standard));
    }

    @Override
    public void setString(String label, String wert) {
        Err.ifNull(this.prop, label, wert);
        this.prop.setProperty(this.iLable(label), wert);
    }

    @Override
    public void setInteger(String label, Integer wert) {
        this.setString(label, ConvObject.toText(wert));
    }

    @Override
    public void setBoolean(String label, Boolean wert) {
        this.setString(label, ConvObject.toText(wert));
    }

    private String iLable(String label) {
        Err.ifNull(label);
        return FilterString.only((String.valueOf("abcdefghijklmnopqrstuvwxyz".toLowerCase()) + "0123456789" + "_.-").toCharArray(), label.toLowerCase());
    }
}

