/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.base.data.container;

import de.mn77.base.data.container.I_Box;
import de.mn77.base.error.Err;

public class SingleBox<T>
implements I_Box<T> {
    private T value = null;
    private boolean isSet = false;

    public SingleBox() {
    }

    public SingleBox(T value) {
        this.set(value);
    }

    @Override
    public synchronized void set(T t) {
        if (this.isSet) {
            throw Err.invalid("Value already set!");
        }
        this.value = t;
        this.isSet = true;
    }

    @Override
    public synchronized T get() {
        if (!this.isSet) {
            throw Err.invalid("No value set!");
        }
        return this.value;
    }

    public boolean isSet() {
        return this.isSet;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "(" + this.get() + ")";
    }
}

