/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.base.data;

import de.mn77.base.data.Lib_String;
import de.mn77.base.error.Err;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Arrays;

public class Lib_Math {
    public static <T extends Comparable<? super T>> T min(T ... numbers) {
        Err.ifToSmall(1.0, numbers.length);
        T result = numbers[0];
        T[] TArray = numbers;
        int n = numbers.length;
        int n2 = 0;
        while (n2 < n) {
            T num = TArray[n2];
            if (num.compareTo(result) < 0) {
                result = num;
            }
            ++n2;
        }
        return result;
    }

    public static <T extends Comparable<? super T>> T max(T ... numbers) {
        Err.ifToSmall(1.0, numbers.length);
        T result = numbers[0];
        T[] TArray = numbers;
        int n = numbers.length;
        int n2 = 0;
        while (n2 < n) {
            T n3 = TArray[n2];
            if (n3.compareTo(result) > 0) {
                result = n3;
            }
            ++n2;
        }
        return result;
    }

    public static <T extends Comparable<? super T>> T minNull(T ... numbers) {
        Err.ifToSmall(1.0, numbers.length);
        Object result = null;
        T[] TArray = numbers;
        int n = numbers.length;
        int n2 = 0;
        while (n2 < n) {
            Object num = TArray[n2];
            if (num != null) {
                if (result == null) {
                    result = num;
                } else if (num.compareTo(result) < 0) {
                    result = num;
                }
            }
            ++n2;
        }
        return result;
    }

    public static <T extends Comparable<? super T>> T maxNull(T ... numbers) {
        Err.ifToSmall(1.0, numbers.length);
        Object result = null;
        T[] TArray = numbers;
        int n = numbers.length;
        int n2 = 0;
        while (n2 < n) {
            Object num = TArray[n2];
            if (num != null) {
                if (result == null) {
                    result = num;
                } else if (num.compareTo(result) > 0) {
                    result = num;
                }
            }
            ++n2;
        }
        return result;
    }

    public static <T extends Number> T biggestDiffFromAvg(T ... numbers) {
        double center = Lib_Math.average(numbers);
        T result = numbers[0];
        double resultDiff = 0.0;
        T[] TArray = numbers;
        int n = numbers.length;
        int n2 = 0;
        while (n2 < n) {
            T num = TArray[n2];
            if (Lib_Math.absBetrag(center - ((Number)num).doubleValue()) > resultDiff || resultDiff == 0.0) {
                resultDiff = Lib_Math.absBetrag(center - ((Number)num).doubleValue());
                result = num;
            }
            ++n2;
        }
        return result;
    }

    public static <T extends Number> double average(T ... numbers) {
        Err.ifToSmall(1.0, numbers.length);
        double result = 0.0;
        T[] TArray = numbers;
        int n = numbers.length;
        int n2 = 0;
        while (n2 < n) {
            T num = TArray[n2];
            result += ((Number)num).doubleValue() / (double)numbers.length;
            ++n2;
        }
        return result;
    }

    public static String roundToString(double value, int decimals, RoundingMode rm) {
        if (rm != null && rm == RoundingMode.HALF_UP) {
            return Lib_Math.roundToString(value, decimals);
        }
        throw Err.todo(new Object[0]);
    }

    public static String roundToString(double value, int decimals) {
        value = Lib_Math.normalize(value, decimals + 1);
        String format = "0" + (decimals > 0 ? "." : "") + Lib_String.sequence('0', (long)decimals);
        DecimalFormat df = new DecimalFormat(format);
        value = Lib_Math.round(value, decimals);
        return df.format(value);
    }

    public static String roundToCurrency(double value) {
        value = Lib_Math.normalize(value, 2);
        NumberFormat nf = NumberFormat.getCurrencyInstance();
        value = Lib_Math.round(value, 2);
        return nf.format(value);
    }

    public static String roundUpToString(double value, int decimals) {
        return Lib_Math.roundToString(value, decimals, RoundingMode.UP);
    }

    public static int roundUp(double value) {
        int result = (int)value;
        if (value > (double)result) {
            ++result;
        }
        return result;
    }

    public static double roundUp(double value, int decimals) {
        Err.ifToSmall(0.0, decimals);
        int factor = (int)Math.pow(10.0, decimals);
        int result = (int)(value * (double)factor);
        if (value * (double)factor > (double)result) {
            ++result;
        }
        return (double)result / (double)factor;
    }

    public static int roundDown(double value) {
        return (int)value;
    }

    public static double round(double value, int decimals) {
        Err.ifOutOfBounds(0.0, 10.0, decimals);
        double multi = decimals == 0 ? 1.0 : Lib_Math.power(10.0, decimals);
        return (double)Math.round(value * multi) / multi;
    }

    public static int roundToInt(double value) {
        return (int)Lib_Math.round(value, 0);
    }

    public static Integer roundToInteger(Double value) {
        if (value == null) {
            return null;
        }
        return (int)Lib_Math.round(value, 0);
    }

    public static short roundToShort(double value) {
        return (short)Lib_Math.round(value, 0);
    }

    public static Short roundToShort(Double value) {
        if (value == null) {
            return null;
        }
        return (short)Lib_Math.round(value, 0);
    }

    public static int bitsNeeded(long value) {
        Err.ifToSmall(0.0, value);
        int result = 0;
        int curBit = 0;
        while (value >= (long)curBit) {
            if (curBit == 0) {
                curBit = 1;
            }
            curBit *= 2;
            ++result;
        }
        return result;
    }

    public static int bitSet(int value, int bits) {
        return value | bits;
    }

    public static int bitRemove(int value, int bits) {
        return (value | bits) ^ bits;
    }

    public static boolean bitIsSet(int value, int bits) {
        return (value & bits) == bits;
    }

    public static double normalize(double value, int decimals) {
        double m = Math.pow(10.0, decimals);
        return Math.rint(value * m) / m;
    }

    public static double limit(double min, double max, double value) {
        Err.ifToSmall(min, max);
        return value < min ? min : (value > max ? max : value);
    }

    public static double power(double base, double exponent) {
        return Math.pow(base, exponent);
    }

    public static boolean isEven(long value) {
        return value % 2L == 0L;
    }

    public static double subPercent(double value, double percent) {
        Err.ifOutOfBounds(0.0, 100.0, percent);
        return value * ((100.0 - percent) / 100.0);
    }

    public static double diffPercent(double lower, double upper) {
        return lower < upper ? upper / lower * 100.0 - 100.0 : (upper < lower ? -(100.0 - upper / lower * 100.0) : 0.0);
    }

    public static int abs(int value) {
        return Math.abs(value);
    }

    public static long abs(long value) {
        return Math.abs(value);
    }

    public static float abs(float value) {
        return Math.abs(value);
    }

    public static double absBetrag(double value) {
        return Math.abs(value);
    }

    public static int absBetrag(int value) {
        return Math.abs(value);
    }

    public static int checksum(long l) {
        l = Math.abs(l);
        String sl = "" + l;
        int sum = 0;
        char[] cArray = sl.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            sum += c - 48;
            ++n2;
        }
        return sum;
    }

    public static double logX(double base, double value) {
        return Math.log(value) / Math.log(base);
    }

    public static int getInt(double d) {
        return (int)Math.floor(d);
    }

    public static double getFraction(double value) {
        return value - (double)((int)value);
    }

    public static Integer minus(Integer minuend, Integer subtrahend) {
        if (minuend == null) {
            return null;
        }
        if (subtrahend == null) {
            return minuend;
        }
        return minuend - subtrahend;
    }

    public static boolean isBetween(int value, int min, int max) {
        return value >= min && value <= max;
    }

    public static int sum(int ... values) {
        int result = 0;
        int[] nArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            int val = nArray[n2];
            result += val;
            ++n2;
        }
        return result;
    }

    public static int differentNumbers(int ... values) {
        Arrays.sort(values);
        int count = 0;
        int base = 0;
        int[] nArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            if (count == 0 || i != base) {
                ++count;
                base = i;
            }
            ++n2;
        }
        return count;
    }

    public static int bitValue(boolean ... values) {
        int result = 0;
        int i = 0;
        while (i < values.length) {
            result += values[i] ? 1 << i : 0;
            ++i;
        }
        return result;
    }

    public static double euler(int cycles) {
        double e = 1.0;
        double f = 1.0;
        int i = 1;
        while (i <= cycles) {
            if ((f *= 1.0 / (double)i) == 0.0) break;
            e += f;
            ++i;
        }
        return e;
    }

    public static double log(int base, double x) {
        double result = 0.0;
        double input = x;
        while (input > (double)base) {
            result += 1.0;
            input /= (double)base;
        }
        double fraction = 0.0;
        input *= input;
        while (result + fraction > result && input > 1.0) {
            if (input > (double)base) {
                input /= (double)base;
                result += fraction;
            }
            input *= input;
            fraction /= 2.0;
        }
        return result;
    }
}

