/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.cli;

import de.mn77.base.data.Lib_String;
import de.mn77.base.data.group.Group2;
import de.mn77.base.error.Err;
import de.mn77.base.error.Err_FileSys;
import de.mn77.base.sys.MOut;
import de.mn77.base.version.I_VersionData;
import de.mn77.base.version.Lib_Version;
import de.mn77.base.version.VersionData_ABC;
import de.mn77.lib.terminal.COLOR_BG;
import de.mn77.lib.terminal.COLOR_FG;
import de.mn77.lib.terminal.MTerminal;
import java.io.IOException;
import org.jaymo_lang.error.ErrorBaseDebug;
import org.jaymo_lang.model.App;
import org.jaymo_lang.parser.Parser_App;

public class CLI {
    private static final VersionData_ABC VERSION = new VersionData_ABC(0, 8, 0);
    private static final String PROMPT = "JM> ";
    private static final String RESULT_PREFIX = "=>  ";

    public static void main(String[] args) {
        MOut.debugNo();
        MOut.setJavaErrors((boolean)false);
        MOut.setLineBreak((String)"\r\n");
        try {
            Lib_Version.init((I_VersionData)VERSION, (boolean)false);
            CLI cli = new CLI();
            cli.start(false, false);
        }
        catch (Throwable e) {
            Err.exit((Throwable)e);
        }
    }

    public void start(boolean parseOnly, boolean debug) throws IOException, Err_FileSys {
        MOut.setLineBreak((String)"\r\n");
        Lib_Version.initKeep((I_VersionData)VERSION);
        Parser_App parser = new Parser_App(true);
        final MTerminal terminal = new MTerminal();
        if (debug) {
            terminal.setDebug();
        }
        parser.setTerminalRawMode(terminal.isInRawMode());
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                terminal.closeTerminal();
            }
        });
        this.headline(terminal, parser);
        boolean run = true;
        while (run) {
            run = this.runTerminal(parser, terminal, null, parseOnly);
        }
        MOut.print((Object[])new Object[]{"Good Bye!"});
    }

    public boolean runTerminal(Parser_App parser, MTerminal terminal, String in, boolean parseOnly) throws IOException, Err_FileSys {
        String output;
        String uin = in;
        if (uin == null) {
            uin = this.readline(terminal);
        }
        if (uin == null || uin.equals("exit") || uin.equals("quit") || uin.equals("q")) {
            terminal.print(new Object[]{"\r\n"});
            terminal.closeTerminal();
            return false;
        }
        boolean rawBefore = terminal.temporaryCooked();
        Group2<String, Boolean> result = this.exec(parser, uin, parseOnly);
        terminal.temporaryReset(rawBefore);
        boolean execOkay = (Boolean)result.o2;
        String string = parseOnly ? (execOkay ? "Parsing okay" : "Parsing failed") : (output = (String)result.o1);
        if (terminal != null) {
            if (terminal.isInRawMode()) {
                COLOR_FG color = execOkay ? COLOR_FG.GREEN : COLOR_FG.RED;
                output = Lib_String.replace((String)output, (char)'\n', (String)"\n\r");
                terminal.print(new Object[]{color, "\r=>  ", output, "\r\n", COLOR_FG.DEFAULT});
            } else {
                terminal.print(new Object[]{RESULT_PREFIX, output, "\n"});
            }
        }
        return true;
    }

    private Group2<String, Boolean> exec(Parser_App parser, String s, boolean parseOnly) throws Err_FileSys {
        int nextLineBreak;
        String result = null;
        boolean ok = false;
        try {
            App app = parser.parseText(s);
            result = parseOnly ? null : app.exec(null);
            ok = true;
        }
        catch (ErrorBaseDebug t) {
            MOut.print((Object[])new Object[]{t.toInfo()});
            result = "Error";
        }
        catch (Throwable t) {
            String errMsg = "Error   : Java-Error\r\n";
            MOut.print((Object[])new Object[]{"Error   : Java-Error\r\n" + t.getMessage()});
            result = "Error";
        }
        if (result == null) {
            result = "";
        }
        result = (nextLineBreak = result.indexOf(10)) == -1 ? result : String.valueOf(result.substring(0, nextLineBreak)) + "\u00b6\u2026";
        return new Group2((Object)result, (Object)ok);
    }

    private void headline(MTerminal terminal, Parser_App parser) {
        String version_parser = parser.getVersionString(false, false);
        String version_cli = "CLI " + VERSION.toStringShort();
        String version_date = parser.getVersion().toFormat("%dd.mm.yyyy");
        String delimiter = "  /  ";
        if (terminal.isInRawMode()) {
            terminal.print(new Object[]{COLOR_BG.BLUE, COLOR_FG.WHITE, "JayMo", COLOR_BG.DEFAULT});
            terminal.print(new Object[]{COLOR_FG.YELLOW, "  " + version_parser});
            terminal.print(new Object[]{COLOR_FG.DARKGRAY, "  /  "});
            terminal.print(new Object[]{COLOR_FG.GREEN, version_cli});
            terminal.print(new Object[]{COLOR_FG.DARKGRAY, "  /  "});
            terminal.print(new Object[]{COLOR_FG.LIGHTMAGENTA, version_date});
            terminal.print(new Object[]{"\r\n\n"});
        } else {
            String t = "JayMo  " + version_parser + "  /  " + version_cli + "  /  " + version_date;
            terminal.print(new Object[]{String.valueOf(t) + "\n\n"});
        }
    }

    private String readline(MTerminal terminal) throws IOException {
        if (terminal.isInRawMode()) {
            terminal.print(new Object[]{COLOR_BG.DEFAULT, COLOR_FG.LIGHTBLUE, PROMPT, COLOR_FG.DEFAULT});
            String input = terminal.readln();
            terminal.print(new Object[]{"\r\n"});
            return input;
        }
        terminal.print(new Object[]{PROMPT});
        return terminal.readln();
    }
}

