/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.util;

import org.jaymo_lang.error.CodeError;
import org.jaymo_lang.error.ErrorBaseDebug;
import org.jaymo_lang.error.ParseError;
import org.jaymo_lang.error.ReturnException;
import org.jaymo_lang.model.Block;
import org.jaymo_lang.model.Call;
import org.jaymo_lang.model.ObjectCallResult;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.object.pseudo.JMo_Error;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.util.Lib_Error;

public class Lib_Try {
    public static ObjectCallResult mErrTry(CallRuntime cr, I_Object o) {
        return cr.argCount() > 0 ? Lib_Try.mErrTryArg(cr, o) : (cr.getCallBlock() == null ? Lib_Try.errTryStream(cr, o) : Lib_Try.errTryBlock(cr, o));
    }

    public static ObjectCallResult mErrTryArg(CallRuntime cr, I_Object o) {
        I_Object result = o;
        try {
            result = cr.args(o, I_Object.class)[0];
        }
        catch (CodeError | ParseError e) {
            if (cr.getApp().strict.getLazyErrors()) {
                result = new JMo_Error(e);
            }
            throw e;
        }
        catch (ErrorBaseDebug t) {
            result = new JMo_Error(t);
        }
        return new ObjectCallResult(result, false);
    }

    public static ObjectCallResult errTryBlock(CallRuntime cr, I_Object o) {
        cr.args();
        cr.blockNecessary();
        Call stream = cr.getStream();
        Block block = cr.getCallBlock();
        I_Object result = o;
        if (block != null) {
            try {
                result = block.exec(cr, result);
            }
            catch (ReturnException e) {
                return new ObjectCallResult(e.get(), true);
            }
            catch (CodeError | ParseError e) {
                if (cr.getApp().strict.getLazyErrors()) {
                    result = new JMo_Error(e);
                }
                throw e;
            }
            catch (ErrorBaseDebug t) {
                result = new JMo_Error(t);
            }
        }
        if (stream != null) {
            result = cr.execInit(stream, result);
        }
        return new ObjectCallResult(result, true);
    }

    public static ObjectCallResult errTryStream(CallRuntime cr, I_Object o) {
        cr.args();
        Call stream = cr.getStream();
        I_Object result = o;
        try {
            result = cr.execInit(stream, result);
        }
        catch (CodeError | ParseError e) {
            if (cr.getApp().strict.getLazyErrors()) {
                result = new JMo_Error(e);
            }
            throw e;
        }
        catch (ErrorBaseDebug t) {
            result = new JMo_Error(t);
        }
        return new ObjectCallResult(result, true);
    }

    public static ObjectCallResult mErrTryUse(CallRuntime cr, I_Object o) {
        boolean showMessage = cr.getApp().isDebug();
        Lib_Error.ifArgs(cr.argCount(), 1, (Integer)1, "Invalid amount of arguments", cr.getDebugInfo());
        Call stream = cr.getStream();
        I_Object result = o;
        try {
            result = cr.execInit(stream, result);
        }
        catch (CodeError | ParseError e) {
            if (cr.getApp().strict.getLazyErrors()) {
                if (showMessage) {
                    new JMo_Error(e).mShow(cr.copyNil());
                }
                result = cr.argEach(o, 0, new JMo_Error(e), I_Object.class);
            }
            throw e;
        }
        catch (ErrorBaseDebug t) {
            if (showMessage) {
                new JMo_Error(t).mShow(cr.copyNil());
            }
            result = cr.argEach(o, 0, new JMo_Error(t), I_Object.class);
        }
        return new ObjectCallResult(result, true);
    }

    public static ObjectCallResult mErrTryCatch(CallRuntime cr, I_Object o) {
        cr.args();
        cr.blockNecessary();
        Call stream = cr.getStream();
        Block block = cr.getCallBlock();
        I_Object result = o;
        if (block != null) {
            try {
                result = block.exec(cr, result);
            }
            catch (ReturnException e) {
                return new ObjectCallResult(e.get(), true);
            }
            catch (CodeError | ParseError e) {
                if (cr.getApp().strict.getLazyErrors()) {
                    result = new JMo_Error(e);
                }
                throw e;
            }
            catch (ErrorBaseDebug t) {
                result = new JMo_Error(t);
            }
        }
        if (stream != null && result instanceof JMo_Error) {
            result = cr.execInit(stream, result);
        }
        return new ObjectCallResult(result, true);
    }
}

