/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.util;

import de.mn77.base.data.Lib_String;
import de.mn77.base.data.group.Group2;
import de.mn77.base.data.group.Group3;
import de.mn77.base.error.Err;
import java.util.ArrayList;
import java.util.List;
import org.jaymo_lang.error.DebugInfo;
import org.jaymo_lang.error.ParseError;
import org.jaymo_lang.model.Block;
import org.jaymo_lang.model.FunctionPar;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.parser.Parser_Call;
import org.jaymo_lang.parser.Parser_Script;
import org.jaymo_lang.util.Lib_StringParser;

public class Lib_Parser {
    public static int getDepth(String s) {
        int count = 0;
        int pos = 0;
        while (pos < s.length()) {
            if (s.charAt(pos) == '\t') {
                ++count;
            } else {
                return count;
            }
            ++pos;
        }
        return count;
    }

    public static Group3<FunctionPar[], Integer, Boolean> getFunctionPars(Parser_Script parser, Block current, String s, char open, char close) {
        int begin = s.indexOf(open);
        if (begin == -1) {
            return new Group3<FunctionPar[], Integer, Boolean>(new FunctionPar[0], 0, false);
        }
        String s2 = s.substring(begin);
        String ps = Lib_Parser.group(open, close, s2, parser.getDebugInfo());
        int rem = begin + ps.length() + 2;
        ps = ps.trim();
        List<String> psa2 = Lib_StringParser.splitArgs(ps, parser.getDebugInfo());
        ArrayList<FunctionPar> args = new ArrayList<FunctionPar>();
        boolean varargs = false;
        for (String element : psa2) {
            char pName0;
            String sa = element.trim();
            if (sa.length() == 0) continue;
            if (sa.endsWith("...")) {
                varargs = true;
                sa = sa.substring(0, sa.length() - 3);
            }
            String ident1 = Lib_StringParser.parseIdentifier(sa, 0);
            int left = ident1.length();
            while (left < sa.length() && sa.charAt(left) == ' ') {
                ++left;
            }
            int defIndex = sa.indexOf(61, left);
            String pDef = defIndex == -1 ? null : sa.substring(defIndex + 1).trim();
            int right = defIndex == -1 ? sa.length() : defIndex;
            String pType = null;
            String pName = ident1;
            if (right - left > 0) {
                String ident2 = Lib_StringParser.parseIdentifier(sa, left);
                pType = ident1;
                pName = ident2;
            }
            I_Object pDefC = null;
            if (pDef != null) {
                Group2<I_Object, String> g = Parser_Call.parseObject(parser, current, pDef, true);
                if (g.o2 != null && ((String)g.o2).length() > 0) {
                    Err.forbidden(g.o2);
                }
                pDefC = (I_Object)g.o1;
            }
            boolean fix = (pName0 = pName.charAt(0)) >= 'A' && pName0 <= 'Z';
            parser.app.strict.checkFuncParType(pType, pName, parser.getDebugInfo());
            FunctionPar fpar = new FunctionPar(pType, fix, pName, pDefC);
            String pNameLower = pName.toLowerCase();
            for (FunctionPar arg : args) {
                if (!arg.name.toLowerCase().equals(pNameLower)) continue;
                throw new ParseError("Duplicate function variable", "Variable is already used: " + pName, parser.getDebugInfo());
            }
            args.add(fpar);
        }
        return new Group3<FunctionPar[], Integer, Boolean>(args.toArray(new FunctionPar[args.size()]), rem, varargs);
    }

    public static final String group(char open, char close, String s, DebugInfo debugInfo) {
        int deep = 0;
        int start = -1;
        int idx = 0;
        while (idx < s.length()) {
            char c = s.charAt(idx);
            if (c == open) {
                ++deep;
                if (start == -1) {
                    start = idx;
                }
            }
            if (c == '\"') {
                idx += 1 + Lib_StringParser.checkString(s.substring(idx), true, debugInfo);
            } else if (c == '\'') {
                idx += Lib_StringParser.checkChar(s.substring(idx), true, debugInfo) - 1;
            } else if (c == close && --deep == 0) {
                return s.substring(start + 1, idx);
            }
            ++idx;
        }
        if (deep == 0) {
            return s;
        }
        throw new ParseError("Uncomplete " + open + close + " group", "Missing: '" + close + "', got only: " + s, debugInfo);
    }

    public static final Group2<String, String> scanCommand(String s, DebugInfo debugInfo) {
        int len = s.length();
        if (len < 3) {
            throw new ParseError("Invalid command", "Got: " + s, debugInfo);
        }
        boolean isBuildt = s.charAt(1) == '(';
        int idx = 1;
        while (idx < len) {
            char c = s.charAt(idx);
            switch (c) {
                case '\"': {
                    if (!isBuildt) break;
                    idx += 1 + Lib_StringParser.checkString(s.substring(idx), true, debugInfo);
                    break;
                }
                case '\'': {
                    if (!isBuildt) break;
                    idx += Lib_StringParser.checkChar(s.substring(idx), true, debugInfo) - 1;
                    break;
                }
                case '`': 
                case '\u00b4': {
                    return new Group2<String, String>(s.substring(1, idx), s.substring(idx + 1));
                }
            }
            ++idx;
        }
        throw new ParseError("Uncomplete command", "Missing '\u00b4' or '`' at the end: " + s, debugInfo);
    }

    public static char replaceEscapeChar(char c, DebugInfo debugInfo) {
        switch (c) {
            case '\\': {
                return c;
            }
            case '\'': {
                return c;
            }
            case '\"': {
                return c;
            }
            case 'n': {
                return '\n';
            }
            case 't': {
                return '\t';
            }
            case 'r': {
                return '\r';
            }
            case 'f': {
                return '\f';
            }
            case 'b': {
                return '\b';
            }
        }
        throw new ParseError("Unknown char to escape", "\\" + c, debugInfo);
    }

    public static char replaceUtfChar(String s, int pos, DebugInfo debugInfo) {
        Err.ifToSmall(pos + 5, s.length());
        String hex = s.substring(pos + 1, pos + 5);
        if (pos + 5 > s.length()) {
            throw new ParseError("Uncomplete UTF-Character", "Got: " + hex, debugInfo);
        }
        int value = 0;
        try {
            value = Integer.parseInt(hex, 16);
        }
        catch (NumberFormatException nfe) {
            throw new ParseError("Invalid unicode statement", "Got: \\" + s.substring(pos), debugInfo);
        }
        char cv = (char)value;
        return cv;
    }

    public static String setDepth(int d, String s) {
        s = s.trim();
        return String.valueOf(Lib_String.sequence('\t', (long)d)) + s;
    }

    public static final String space(int level) {
        return level == 0 ? "" : Lib_String.sequence(' ', (long)(level * 2));
    }

    public static final Group2<String, Integer> stringGet(String s, DebugInfo debugInfo) {
        char[] ca = s.toCharArray();
        StringBuilder sb = new StringBuilder(ca.length);
        int idx = 1;
        while (idx < ca.length) {
            char c = ca[idx];
            switch (c) {
                case '\\': {
                    char temp = ca[++idx];
                    if (temp == 'u') {
                        char utf = Lib_Parser.replaceUtfChar(s, idx, debugInfo);
                        sb.append(utf);
                        idx += 4;
                        break;
                    }
                    sb.append(Lib_Parser.replaceEscapeChar(temp, debugInfo));
                    break;
                }
                case '\"': {
                    return new Group2<String, Integer>(sb.toString(), idx);
                }
                default: {
                    sb.append(c);
                }
            }
            ++idx;
        }
        return null;
    }

    public static Group3<String, Integer, Boolean> getStringLiteralRegEx(String s, DebugInfo debugInfo) {
        int end = 1;
        int sLen = s.length();
        boolean reworkNeeded = false;
        end = 1;
        while (end < sLen) {
            char c = s.charAt(end);
            if (c == '\\') {
                ++end;
                reworkNeeded = true;
            } else if (c == '\"') break;
            ++end;
        }
        if (end == sLen) {
            throw new ParseError("Unclosed string", s, debugInfo);
        }
        String str = s.substring(1, end);
        if (end + 1 < sLen) {
            if (s.charAt(end + 1) == '\u00bf') {
                return new Group3<String, Integer, Boolean>(str, end + 1, true);
            }
            if (s.charAt(end + 1) == '?') {
                if (end + 2 < sLen && s.charAt(end + 2) == '?') {
                    return new Group3<String, Integer, Boolean>(str, end + 2, true);
                }
                return new Group3<String, Integer, Boolean>(str, end + 1, false);
            }
        }
        if (!reworkNeeded) {
            return new Group3<String, Integer, Boolean>(str, end, false);
        }
        int strLen = str.length();
        StringBuilder sb = new StringBuilder(strLen);
        int idx = 0;
        while (idx < strLen) {
            char c = str.charAt(idx);
            if (c == '\\') {
                if ((c = str.charAt(++idx)) == 'u') {
                    char utf = Lib_Parser.replaceUtfChar(str, idx, debugInfo);
                    sb.append(utf);
                    idx += 4;
                } else {
                    sb.append(Lib_Parser.replaceEscapeChar(c, debugInfo));
                }
            } else {
                sb.append(c);
            }
            ++idx;
        }
        return new Group3<String, Integer, Boolean>(sb.toString(), end, false);
    }

    public static String removeUnderlines(String s, DebugInfo debug) {
        if (s.charAt(0) == '_' || s.charAt(s.length() - 1) == '_') {
            throw new ParseError("Invalid number", "Underline at beginning or end: " + s, debug);
        }
        return s.replace("_", "");
    }

    public static boolean fastCheckIsVar(String name, DebugInfo debug) {
        if (name == null || name.length() == 0) {
            throw new ParseError("Invalid variable/constant", "Missing name", debug);
        }
        char c0 = name.charAt(0);
        return c0 >= 'a' && c0 <= 'z';
    }

    public static boolean fastCheckIsConst(String name, DebugInfo debug) {
        if (name == null || name.length() == 0) {
            throw new ParseError("Invalid variable/constant", "Missing name", debug);
        }
        return name.toUpperCase().equals(name);
    }

    public static boolean fastCheckIsType(String name, DebugInfo debug) {
        if (name == null || name.length() == 0) {
            throw new ParseError("Invalid code", "Missing name", debug);
        }
        if (name.charAt(0) == '_') {
            return true;
        }
        char[] cArray = name.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (c >= 'a' && c <= 'z') {
                return true;
            }
            if (c < 'A' | c > 'Z' && c < '0' | c > '9' && c != '_') {
                return false;
            }
            ++n2;
        }
        return false;
    }

    public static boolean fastCheckStartWithTypeNotation(String s) {
        int len = s.length();
        if (s == null || len == 0 || s.charAt(0) != '<') {
            return false;
        }
        int c = 32;
        int i = 1;
        while (i < len) {
            c = s.charAt(i);
            if (c == 62) {
                return true;
            }
            if (!(c >= 65 && c <= 90 || c >= 97 && c <= 122 || c >= 48 && c <= 57 || c == 95)) {
                return false;
            }
            ++i;
        }
        return false;
    }

    public static String getTypeName(String s, Parser_Script parser) {
        boolean openSpecial = false;
        int i = 0;
        while (i < s.length()) {
            boolean hit;
            char c = s.charAt(i);
            if (c == '{') {
                openSpecial = true;
            } else if (c == '}') {
                openSpecial = false;
            } else if (openSpecial) {
                boolean bl = hit = c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == '_' || c == '.' || c == '$';
                if (!hit) {
                    throw new ParseError("Invalid type", "Closing bracket '}' is missing: " + s.substring(0, i), parser.getDebugInfo());
                }
            } else {
                boolean bl = hit = c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == '_';
                if (!hit) {
                    return s.substring(0, i);
                }
            }
            ++i;
        }
        return s;
    }

    public static int combineBegin(String s) {
        switch (s.trim().charAt(0)) {
            case '.': {
                return 1;
            }
            case ')': 
            case ',': 
            case ']': {
                return 2;
            }
        }
        return 0;
    }

    public static boolean combineEnd(String s) {
        String lineTopTrim = s.trim();
        switch (lineTopTrim.charAt(lineTopTrim.length() - 1)) {
            case '(': 
            case ',': 
            case '[': {
                return true;
            }
        }
        return false;
    }
}

