/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.util;

import de.mn77.base.error.Err;
import org.jaymo_lang.error.CodeError;
import org.jaymo_lang.error.ErrorBase;
import org.jaymo_lang.error.ExecError;
import org.jaymo_lang.error.ParseError;
import org.jaymo_lang.error.ReturnException;
import org.jaymo_lang.model.App;
import org.jaymo_lang.model.Block;
import org.jaymo_lang.model.Call;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.object.atom.Bool;
import org.jaymo_lang.object.atom.Str;
import org.jaymo_lang.object.pseudo.Return;
import org.jaymo_lang.parser.Parser_App;
import org.jaymo_lang.runtime.CallRuntime;

public class Lib_Exec {
    public static void checkExceptionIsEnd(CallRuntime cr, Return r) {
        if (r.getLevel() != Return.LEVEL.END) {
            throw new ExecError(cr, "Invalid Return-Type", "Got " + (Object)((Object)r.getLevel()));
        }
    }

    public static I_Object mSingleArgument(CallRuntime cr, I_Object itStream, int min, int max, I_Object defaultValue) {
        Err.ifToBig(1.0, max);
        I_Object[] args = cr.argsFlex(itStream, min, max);
        return args.length == 0 ? defaultValue : args[0];
    }

    public static I_Object execBlockStream(CallRuntime crNew, I_Object it) {
        Call stream = crNew.getStream();
        Block block = crNew.getCallBlock();
        if (block != null) {
            try {
                it = block.exec(crNew, it);
            }
            catch (ReturnException e) {
                Return r = e.get();
                r.updateEmptyResult(it);
                return r;
            }
        }
        if (stream != null) {
            it = crNew.execInit(stream, it);
        }
        return it;
    }

    public static I_Object execOnlyStream(CallRuntime crNew, I_Object it) {
        Call stream = crNew.getStream();
        if (stream != null) {
            it = crNew.execInit(stream, it);
        }
        return it;
    }

    public static void checkLoopWithout(CallRuntime crOld) {
        if (crOld.getStream() == null && crOld.getCallBlock() == null) {
            throw new CodeError(crOld, "Invalid call", "No argument, no stream, no block ... what should I do?");
        }
    }

    public static I_Object loopResult(I_Object result) {
        if (result instanceof Return && ((Return)result).getLevel() == Return.LEVEL.NEXT) {
            return ((Return)result).getResult();
        }
        return result;
    }

    public static I_Object execIf(CallRuntime cr, boolean check, I_Object it, boolean passToStream) {
        boolean streamOnFalse;
        boolean bl = passToStream ? false : (streamOnFalse = cr.getCallBlock() != null);
        return check ? Lib_Exec.execBlockStream(cr, it) : (streamOnFalse ? Lib_Exec.execOnlyStream(cr, it) : (passToStream ? Bool.FALSE : it));
    }

    public static Str execJMo(CallRuntime cr, String value, String infoTypeFunc, boolean hotDirect) {
        cr.getStrict().checkSave(cr, infoTypeFunc);
        try {
            Parser_App parser = new Parser_App();
            App appHot = parser.parseText(value);
            appHot.setOutputFile(cr.getApp().getOutputFile());
            String result = hotDirect ? cr.getApp().exec(cr, appHot) : appHot.exec(null);
            return new Str(result);
        }
        catch (ParseError e) {
            throw new ExecError(cr, "Parse-Error", e.getMessage());
        }
        catch (CodeError e) {
            throw new ExecError(cr, "Code-Error", e.getMessage());
        }
        catch (ErrorBase e) {
            throw e;
        }
    }
}

