/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.util;

import de.mn77.base.error.Err;
import org.jaymo_lang.error.ExecError;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.object.atom.Bool;
import org.jaymo_lang.object.atom.Char;
import org.jaymo_lang.object.atom.Dec;
import org.jaymo_lang.object.atom.I_AtomicValue;
import org.jaymo_lang.object.atom.Int;
import org.jaymo_lang.object.atom.JMo_Byte;
import org.jaymo_lang.object.atom.JMo_Float;
import org.jaymo_lang.object.atom.JMo_Long;
import org.jaymo_lang.object.atom.JMo_Short;
import org.jaymo_lang.object.atom.Nil;
import org.jaymo_lang.object.atom.Str;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.util.ATOMIC;
import org.jaymo_lang.util.Lib_Error;
import org.jaymo_lang.util.Lib_Type;

public class Lib_AtomConv {
    public static I_AtomicValue convert(CallRuntime cr, ATOMIC from, ATOMIC to, I_Object so, Object o) {
        switch (from) {
            case BOOL: {
                return Lib_AtomConv.convertBool(cr, to, so, o);
            }
            case CHAR: {
                return Lib_AtomConv.convertChar(cr, to, so, o);
            }
            case BYTE: {
                return Lib_AtomConv.convertByte(cr, to, so, o);
            }
            case SHORT: {
                return Lib_AtomConv.convertShort(cr, to, so, o);
            }
            case INT: {
                return Lib_AtomConv.convertInt(cr, to, so, o);
            }
            case LONG: {
                return Lib_AtomConv.convertLong(cr, to, so, o);
            }
            case FLOAT: {
                return Lib_AtomConv.convertFloat(cr, to, so, o);
            }
            case DEC: {
                return Lib_AtomConv.convertDec(cr, to, so, o);
            }
            case STR: {
                return Lib_AtomConv.convertStr(cr, to, so, o);
            }
        }
        throw Err.impossible(new Object[0]);
    }

    public static I_AtomicValue convert(CallRuntime cr, ATOMIC to, I_Object so) {
        if (so instanceof Bool) {
            return Lib_AtomConv.convert(cr, ATOMIC.BOOL, to, so, ((I_AtomicValue)so).getValue());
        }
        if (so instanceof Char) {
            return Lib_AtomConv.convert(cr, ATOMIC.CHAR, to, so, ((I_AtomicValue)so).getValue());
        }
        if (so instanceof JMo_Byte) {
            return Lib_AtomConv.convert(cr, ATOMIC.BYTE, to, so, ((I_AtomicValue)so).getValue());
        }
        if (so instanceof JMo_Short) {
            return Lib_AtomConv.convert(cr, ATOMIC.SHORT, to, so, ((I_AtomicValue)so).getValue());
        }
        if (so instanceof Int) {
            return Lib_AtomConv.convert(cr, ATOMIC.INT, to, so, ((I_AtomicValue)so).getValue());
        }
        if (so instanceof JMo_Long) {
            return Lib_AtomConv.convert(cr, ATOMIC.LONG, to, so, ((I_AtomicValue)so).getValue());
        }
        if (so instanceof JMo_Float) {
            return Lib_AtomConv.convert(cr, ATOMIC.FLOAT, to, so, ((I_AtomicValue)so).getValue());
        }
        if (so instanceof Dec) {
            return Lib_AtomConv.convert(cr, ATOMIC.DEC, to, so, ((I_AtomicValue)so).getValue());
        }
        if (so instanceof Str) {
            return Lib_AtomConv.convert(cr, ATOMIC.STR, to, so, ((I_AtomicValue)so).getValue());
        }
        throw Err.invalid(new Object[]{to, so});
    }

    public static I_Object convert(CallRuntime cr, Class<?> cls, I_Object o) {
        if (cls == Bool.class) {
            return Lib_AtomConv.convert(cr, ATOMIC.BOOL, o);
        }
        if (cls == Char.class) {
            return Lib_AtomConv.convert(cr, ATOMIC.CHAR, o);
        }
        if (cls == JMo_Byte.class) {
            return Lib_AtomConv.convert(cr, ATOMIC.BYTE, o);
        }
        if (cls == JMo_Short.class) {
            return Lib_AtomConv.convert(cr, ATOMIC.SHORT, o);
        }
        if (cls == Int.class) {
            return Lib_AtomConv.convert(cr, ATOMIC.INT, o);
        }
        if (cls == JMo_Long.class) {
            return Lib_AtomConv.convert(cr, ATOMIC.LONG, o);
        }
        if (cls == JMo_Float.class) {
            return Lib_AtomConv.convert(cr, ATOMIC.FLOAT, o);
        }
        if (cls == Dec.class) {
            return Lib_AtomConv.convert(cr, ATOMIC.DEC, o);
        }
        throw Err.todo(cls, o);
    }

    public static I_Object getDefaultValue(String type) {
        if (type == null || type.endsWith("?")) {
            return Nil.NIL;
        }
        if (type.equals(Lib_Type.getName(Bool.class, null))) {
            return Bool.FALSE;
        }
        if (type.equals(Lib_Type.getName(Char.class, null))) {
            return new Char(' ');
        }
        if (type.equals(Lib_Type.getName(JMo_Byte.class, null))) {
            return new JMo_Byte(0);
        }
        if (type.equals(Lib_Type.getName(JMo_Short.class, null))) {
            return new JMo_Short(0);
        }
        if (type.equals(Lib_Type.getName(Int.class, null))) {
            return new Int(0);
        }
        if (type.equals(Lib_Type.getName(JMo_Long.class, null))) {
            return new JMo_Long(0L);
        }
        if (type.equals(Lib_Type.getName(JMo_Float.class, null))) {
            return new JMo_Float(0.0f);
        }
        if (type.equals(Lib_Type.getName(Dec.class, null))) {
            return new Dec(0.0);
        }
        if (type.equals(Lib_Type.getName(Str.class, null))) {
            return new Str("");
        }
        return Nil.NIL;
    }

    public static I_Object autoUpgrade(CallRuntime cr, I_Object obj, String objType, String safedType) {
        switch (safedType) {
            case "Short": {
                switch (objType) {
                    case "Byte": {
                        return Lib_AtomConv.convert(cr, ATOMIC.SHORT, obj);
                    }
                }
                return null;
            }
            case "Int": {
                switch (objType) {
                    case "Byte": 
                    case "Short": {
                        return Lib_AtomConv.convert(cr, ATOMIC.INT, obj);
                    }
                }
                return null;
            }
            case "Long": {
                switch (objType) {
                    case "Int": 
                    case "Byte": 
                    case "Short": {
                        return Lib_AtomConv.convert(cr, ATOMIC.LONG, obj);
                    }
                }
                return null;
            }
            case "Float": {
                switch (objType) {
                    case "Byte": 
                    case "Short": {
                        return Lib_AtomConv.convert(cr, ATOMIC.FLOAT, obj);
                    }
                }
                return null;
            }
            case "Dec": {
                switch (objType) {
                    case "Int": 
                    case "Byte": 
                    case "Float": 
                    case "Short": {
                        return Lib_AtomConv.convert(cr, ATOMIC.DEC, obj);
                    }
                }
                return null;
            }
            case "DecNumber": {
                switch (objType) {
                    case "Int": 
                    case "Byte": 
                    case "Short": {
                        return Lib_AtomConv.convert(cr, ATOMIC.DEC, obj);
                    }
                }
                return null;
            }
            case "Str": {
                switch (objType) {
                    case "Dec": 
                    case "Int": 
                    case "Byte": 
                    case "Char": 
                    case "Long": 
                    case "Float": 
                    case "Short": {
                        return Lib_AtomConv.convert(cr, ATOMIC.STR, obj);
                    }
                }
                return null;
            }
        }
        return null;
    }

    private static I_AtomicValue convertBool(CallRuntime cr, ATOMIC to, I_Object so, Object o) {
        boolean v = (Boolean)o;
        switch (to) {
            case BOOL: {
                return (Bool)so;
            }
            case CHAR: {
                return new Char(v ? (char)'1' : '0');
            }
            case BYTE: {
                return new JMo_Byte(v ? (byte)1 : 0);
            }
            case SHORT: {
                return new JMo_Short(v ? (short)1 : 0);
            }
            case INT: {
                return new Int(v ? 1 : 0);
            }
            case LONG: {
                return new JMo_Long(v ? 1 : 0);
            }
            case FLOAT: {
                return new JMo_Float(v ? 1 : 0);
            }
            case DEC: {
                return new Dec(v ? 1 : 0);
            }
            case STR: {
                return new Str("" + v);
            }
        }
        throw Err.impossible(new Object[0]);
    }

    private static I_AtomicValue convertByte(CallRuntime cr, ATOMIC to, I_Object so, Object o) {
        byte v = (Byte)o;
        switch (to) {
            case BOOL: {
                return Bool.getObject(v > 0);
            }
            case CHAR: {
                return Lib_AtomConv.iToChar(cr, v);
            }
            case BYTE: {
                return (JMo_Byte)so;
            }
            case SHORT: {
                return new JMo_Short(v);
            }
            case INT: {
                return new Int(v);
            }
            case LONG: {
                return new JMo_Long(v);
            }
            case FLOAT: {
                return new JMo_Float(v);
            }
            case DEC: {
                return new Dec(v);
            }
            case STR: {
                return new Str("" + v);
            }
        }
        throw Err.impossible(new Object[0]);
    }

    private static I_AtomicValue convertChar(CallRuntime cr, ATOMIC to, I_Object so, Object o) {
        char v = ((Character)o).charValue();
        try {
            switch (to) {
                case BOOL: {
                    return Bool.getObject(v == '1');
                }
                case CHAR: {
                    return (Char)so;
                }
                case BYTE: {
                    return new JMo_Byte(Byte.parseByte("" + v));
                }
                case SHORT: {
                    return new JMo_Short(Short.parseShort("" + v));
                }
                case INT: {
                    return new Int(Integer.parseInt("" + v));
                }
                case LONG: {
                    return new JMo_Long(Long.parseLong("" + v));
                }
                case FLOAT: {
                    return new JMo_Float(Float.parseFloat("" + v));
                }
                case DEC: {
                    return new Dec(Double.parseDouble("" + v));
                }
                case STR: {
                    return new Str("" + v);
                }
            }
            throw Err.impossible(new Object[0]);
        }
        catch (NumberFormatException e) {
            throw new ExecError(cr, "Invalid <Char> for conversion to " + to.getTypeString(), e.getMessage());
        }
    }

    private static I_AtomicValue convertDec(CallRuntime cr, ATOMIC to, I_Object so, Object o) {
        double v = (Double)o;
        switch (to) {
            case BOOL: {
                return Bool.getObject(v > 0.0);
            }
            case CHAR: {
                return Lib_AtomConv.iDecToChar(cr, v);
            }
            case BYTE: {
                Lib_Error.ifNotBetween(cr, -128.0, 255.0, v, "Dec");
                return new JMo_Byte((byte)v);
            }
            case SHORT: {
                Lib_Error.ifNotBetween(cr, -32768.0, 65535.0, v, "Dec");
                return new JMo_Short((short)v);
            }
            case INT: {
                Lib_Error.ifNotBetween(cr, -2.147483648E9, 4.294967295E9, v, "Dec");
                return new Int((int)v);
            }
            case LONG: {
                Lib_Error.ifNotBetween(cr, -9.223372036854776E18, 9.223372036854776E18, v, "Dec");
                return new JMo_Long((long)v);
            }
            case FLOAT: {
                return new JMo_Float((float)v);
            }
            case DEC: {
                return (Dec)so;
            }
            case STR: {
                return new Str("" + v);
            }
        }
        throw Err.impossible(new Object[0]);
    }

    private static I_AtomicValue convertFloat(CallRuntime cr, ATOMIC to, I_Object so, Object o) {
        float v = ((Float)o).floatValue();
        switch (to) {
            case BOOL: {
                return Bool.getObject(v > 0.0f);
            }
            case CHAR: {
                return Lib_AtomConv.iDecToChar(cr, Float.valueOf(v));
            }
            case BYTE: {
                Lib_Error.ifNotBetween(cr, -128.0, 255.0, v, "Float");
                return new JMo_Byte((byte)v);
            }
            case SHORT: {
                Lib_Error.ifNotBetween(cr, -32768.0, 65535.0, v, "Float");
                return new JMo_Short((short)v);
            }
            case INT: {
                Lib_Error.ifNotBetween(cr, -2.147483648E9, 4.294967295E9, v, "Float");
                return new Int((int)v);
            }
            case LONG: {
                Lib_Error.ifNotBetween(cr, -9.223372036854776E18, 9.223372036854776E18, v, "Float");
                return new JMo_Long((long)v);
            }
            case FLOAT: {
                return (JMo_Float)so;
            }
            case DEC: {
                return new Dec(v);
            }
            case STR: {
                return new Str("" + v);
            }
        }
        throw Err.impossible(new Object[0]);
    }

    private static I_AtomicValue convertInt(CallRuntime cr, ATOMIC to, I_Object so, Object o) {
        int v = (Integer)o;
        switch (to) {
            case BOOL: {
                return Bool.getObject(v > 0);
            }
            case CHAR: {
                return Lib_AtomConv.iToChar(cr, v);
            }
            case BYTE: {
                Lib_Error.ifNotBetween(cr, -128, 255, v, "Int");
                return new JMo_Byte((byte)v);
            }
            case SHORT: {
                Lib_Error.ifNotBetween(cr, Short.MIN_VALUE, 65535, v, "Int");
                return new JMo_Short((short)v);
            }
            case INT: {
                return (Int)so;
            }
            case LONG: {
                return new JMo_Long(v);
            }
            case FLOAT: {
                return new JMo_Float(v);
            }
            case DEC: {
                return new Dec(v);
            }
            case STR: {
                return new Str("" + v);
            }
        }
        throw Err.impossible(new Object[0]);
    }

    private static I_AtomicValue convertLong(CallRuntime cr, ATOMIC to, I_Object so, Object o) {
        long v = (Long)o;
        switch (to) {
            case BOOL: {
                return Bool.getObject(v > 0L);
            }
            case CHAR: {
                return Lib_AtomConv.iToChar(cr, v);
            }
            case BYTE: {
                Lib_Error.ifNotBetween(cr, -128.0, 255.0, v, "Long");
                return new JMo_Byte((byte)v);
            }
            case SHORT: {
                Lib_Error.ifNotBetween(cr, -32768.0, 65535.0, v, "Long");
                return new JMo_Short((short)v);
            }
            case INT: {
                Lib_Error.ifNotBetween(cr, -2.147483648E9, 4.294967295E9, v, "Long");
                return new Int((int)v);
            }
            case LONG: {
                return (JMo_Long)so;
            }
            case FLOAT: {
                return new JMo_Float(v);
            }
            case DEC: {
                return new Dec(v);
            }
            case STR: {
                return new Str("" + v);
            }
        }
        throw Err.impossible(new Object[0]);
    }

    private static I_AtomicValue convertShort(CallRuntime cr, ATOMIC to, I_Object so, Object o) {
        short v = (Short)o;
        switch (to) {
            case BOOL: {
                return Bool.getObject(v > 0);
            }
            case CHAR: {
                return Lib_AtomConv.iToChar(cr, v);
            }
            case BYTE: {
                Lib_Error.ifNotBetween(cr, -128, 255, v, "Short");
                return new JMo_Byte((byte)v);
            }
            case SHORT: {
                return (JMo_Short)so;
            }
            case INT: {
                return new Int(v);
            }
            case LONG: {
                return new JMo_Long(v);
            }
            case FLOAT: {
                return new JMo_Float(v);
            }
            case DEC: {
                return new Dec(v);
            }
            case STR: {
                return new Str("" + v);
            }
        }
        throw Err.impossible(new Object[0]);
    }

    private static I_AtomicValue convertStr(CallRuntime cr, ATOMIC to, I_Object so, Object o) {
        String v = (String)o;
        try {
            switch (to) {
                case BOOL: {
                    String lv = v.toLowerCase();
                    if (lv.length() == 0 || lv.equals("false") || lv.equals("0")) {
                        return Bool.FALSE;
                    }
                    return Bool.TRUE;
                }
                case CHAR: {
                    return Lib_AtomConv.iToChar(cr, v);
                }
                case BYTE: {
                    return new JMo_Byte(Byte.parseByte(v));
                }
                case SHORT: {
                    return new JMo_Short(Short.parseShort(v));
                }
                case INT: {
                    return new Int(Integer.parseInt(v));
                }
                case LONG: {
                    return new JMo_Long(Long.parseLong(v));
                }
                case FLOAT: {
                    String s2 = v.replace(',', '.');
                    return new Dec(Float.parseFloat(s2));
                }
                case DEC: {
                    String s3 = v.replace(',', '.');
                    return new Dec(Double.parseDouble(s3));
                }
                case STR: {
                    return (Str)so;
                }
            }
        }
        catch (NumberFormatException e) {
            return Nil.NIL;
        }
        throw Err.impossible(new Object[0]);
    }

    private static Char iToChar(CallRuntime cr, Object v) {
        String vs = v.toString();
        if (vs.length() != 1) {
            throw new ExecError(cr, "Can't convert value to <Char>", "Only one single number or character is allowed. Maybe use .chr or .charAt");
        }
        return new Char(vs.charAt(0));
    }

    private static Char iDecToChar(CallRuntime cr, Object v) {
        String vs = v.toString();
        if (vs.endsWith(".0")) {
            vs = vs.substring(0, vs.length() - 2);
        }
        if (vs.length() != 1) {
            throw new ExecError(cr, "Can't convert decimal number to <Char>", "Only one single number is allowed.");
        }
        return new Char(vs.charAt(0));
    }
}

