/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.parser.obj;

import de.mn77.base.data.group.Group2;
import de.mn77.base.error.Err;
import org.jaymo_lang.model.Block;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.object.atom.Bool;
import org.jaymo_lang.object.atom.Dec;
import org.jaymo_lang.object.atom.Nil;
import org.jaymo_lang.object.magic.var.MV_APP;
import org.jaymo_lang.object.magic.var.MV_CUR;
import org.jaymo_lang.object.magic.var.MV_EACH;
import org.jaymo_lang.object.magic.var.MV_JMO;
import org.jaymo_lang.object.magic.var.MV_THIS;
import org.jaymo_lang.object.magic.var.MagicVar;
import org.jaymo_lang.parser.Parser_Script;
import org.jaymo_lang.parser.obj.I_ParseObject;

public class ParseObj_MagicVar
implements I_ParseObject {
    private static final String[] literals = new String[]{"cur", "each", "func", "loop", "this", "true", "TRUE", "false", "FALSE", "nil", "NIL", "null", "NULL", "app", "jmo", "not_a_number", "infinity", "+infinity", "-infinity"};
    private static final String literals0 = "acefijlntFNT+-";

    @Override
    public boolean hits(char c0, Block current, String s) {
        if (literals0.indexOf(c0) == -1) {
            return false;
        }
        int l = s.length();
        String[] stringArray = literals;
        int n = literals.length;
        int n2 = 0;
        while (n2 < n) {
            String literal = stringArray[n2];
            if (s.startsWith(literal)) {
                char c;
                l = literal.length();
                return s.length() <= l || !((c = s.charAt(l)) >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9') && c != '_';
            }
            ++n2;
        }
        return false;
    }

    @Override
    public Group2<I_Object, String> parse(Parser_Script parser, Block current, String s) {
        Err.ifNull(current);
        switch (s.charAt(0)) {
            case 'a': {
                return new Group2<I_Object, String>(new MV_APP(), s.substring(3));
            }
            case 'c': {
                return new Group2<I_Object, String>(new MV_CUR(false), s.substring(3));
            }
            case 'e': {
                return new Group2<I_Object, String>(new MV_EACH(false), s.substring(4));
            }
            case 'f': {
                if (s.charAt(1) == 'a') {
                    return new Group2<I_Object, String>(Bool.FALSE, s.substring(5));
                }
                return new Group2<I_Object, String>(new MagicVar(MagicVar.MAGICVAR.FUNC), s.substring(4));
            }
            case 'i': {
                return new Group2<I_Object, String>(new Dec(Double.POSITIVE_INFINITY), s.substring(8));
            }
            case 'j': {
                return new Group2<I_Object, String>(new MV_JMO(), s.substring(3));
            }
            case 'l': {
                return new Group2<I_Object, String>(new MagicVar(MagicVar.MAGICVAR.LOOP), s.substring(4));
            }
            case 't': {
                if (s.charAt(1) == 'r') {
                    return new Group2<I_Object, String>(Bool.TRUE, s.substring(4));
                }
                return new Group2<I_Object, String>(new MV_THIS(false), s.substring(4));
            }
            case 'F': {
                return new Group2<I_Object, String>(Bool.FALSE, s.substring(5));
            }
            case 'T': {
                return new Group2<I_Object, String>(Bool.TRUE, s.substring(4));
            }
            case 'n': {
                if (s.charAt(1) == 'o') {
                    return new Group2<I_Object, String>(new Dec(Double.NaN), s.substring(12));
                }
            }
            case 'N': {
                char c1 = s.charAt(1);
                return new Group2<I_Object, String>(Nil.NIL, s.substring(c1 == 'i' || c1 == 'I' ? 3 : 4));
            }
            case '+': {
                return new Group2<I_Object, String>(new Dec(Double.POSITIVE_INFINITY), s.substring(9));
            }
            case '-': {
                return new Group2<I_Object, String>(new Dec(Double.NEGATIVE_INFINITY), s.substring(9));
            }
        }
        throw Err.impossible(s);
    }
}

