/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.parser.obj;

import de.mn77.base.data.constant.position.POSITION;
import de.mn77.base.data.filter.FilterString;
import de.mn77.base.data.group.Group2;
import de.mn77.base.error.Err;
import org.jaymo_lang.error.ParseError;
import org.jaymo_lang.model.Block;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.object.atom.Dec;
import org.jaymo_lang.object.magic.con.MC_DEBUG;
import org.jaymo_lang.object.magic.con.MagicConst;
import org.jaymo_lang.object.magic.con.MagicPosition;
import org.jaymo_lang.parser.Parser_Script;
import org.jaymo_lang.parser.obj.I_ParseObject;

public class ParseObj_MagicConst
implements I_ParseObject {
    @Override
    public boolean hits(char c0, Block current, String s) {
        if (c0 != '_') {
            return false;
        }
        return s.length() > 2 && s.charAt(1) == '_';
    }

    @Override
    public Group2<I_Object, String> parse(Parser_Script parser, Block current, String s) {
        Err.ifNull(current);
        String var = FilterString.matchingLeft("_ABCDEFGHIJKLMNOPQRSTUVWXYZ", s).substring(2);
        String rem = s.substring(var.length() + 2);
        switch (var) {
            case "DEBUG": {
                return this.res(new MC_DEBUG(), rem);
            }
            case "LINE": {
                return this.res(new MagicConst(MagicConst.MAGICCONST.LINE), rem);
            }
            case "FILE": {
                return this.res(new MagicConst(MagicConst.MAGICCONST.FILE), rem);
            }
            case "ARGS": {
                return this.res(new MagicConst(MagicConst.MAGICCONST.ARGS), rem);
            }
            case "TOP_LEFT": {
                return this.res(new MagicPosition(POSITION.TOP_LEFT), rem);
            }
            case "TOP_RIGHT": {
                return this.res(new MagicPosition(POSITION.TOP_RIGHT), rem);
            }
            case "BOTTOM_LEFT": {
                return this.res(new MagicPosition(POSITION.BOTTOM_LEFT), rem);
            }
            case "BOTTOM_RIGHT": {
                return this.res(new MagicPosition(POSITION.BOTTOM_RIGHT), rem);
            }
            case "CENTER": {
                return this.res(new MagicPosition(POSITION.CENTER), rem);
            }
            case "TOP": {
                return this.res(new MagicPosition(POSITION.TOP), rem);
            }
            case "LEFT": {
                return this.res(new MagicPosition(POSITION.LEFT), rem);
            }
            case "BOTTOM": {
                return this.res(new MagicPosition(POSITION.BOTTOM), rem);
            }
            case "RIGHT": {
                return this.res(new MagicPosition(POSITION.RIGHT), rem);
            }
            case "PI": {
                return this.res(new Dec(Math.PI), rem);
            }
            case "E": {
                return this.res(new Dec(Math.E), rem);
            }
            case "DEVELOPERS": {
                return this.res(new MagicConst(MagicConst.MAGICCONST.DEVELOPERS), rem);
            }
            case "SUPPORTERS": {
                return this.res(new MagicConst(MagicConst.MAGICCONST.SUPPORTERS), rem);
            }
            case "SPONSORS": {
                return this.res(new MagicConst(MagicConst.MAGICCONST.SPONSORS), rem);
            }
        }
        throw new ParseError("Unknown MagicConst", "Got: " + var, parser.getDebugInfo());
    }

    private Group2<I_Object, String> res(I_Object result, String rem) {
        return new Group2<I_Object, String>(result, rem);
    }
}

