/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.object.passthrough;

import de.mn77.base.error.Err;
import org.jaymo_lang.error.CodeError;
import org.jaymo_lang.error.DebugInfo;
import org.jaymo_lang.error.ExecError;
import org.jaymo_lang.model.ObjectCallResult;
import org.jaymo_lang.object.A_EventObject;
import org.jaymo_lang.object.A_Object;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.object.passthrough.I_PassThrough;
import org.jaymo_lang.object.passthrough.I_VarConst;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.runtime.VarEnv;
import org.jaymo_lang.util.Lib_Function;

public class Var
extends A_EventObject
implements I_PassThrough,
I_VarConst {
    public static final String CHANGED_EVENT = "@varChanged";
    private final String name;
    private final boolean nilable;
    private final boolean typesafe;
    private String initType = null;

    public Var(String name) {
        Err.ifNull(name);
        boolean typeUnsafe1 = name.endsWith("\u00bf");
        boolean typeUnsafe2 = name.endsWith("??");
        boolean nilable1 = name.endsWith("?");
        this.typesafe = !typeUnsafe1 && !typeUnsafe2;
        this.nilable = !this.typesafe || nilable1;
        int cut = 0;
        if (typeUnsafe2) {
            cut += 2;
        } else if (typeUnsafe1 || nilable1) {
            ++cut;
        }
        this.name = cut == 0 ? name : name.substring(0, name.length() - cut);
    }

    @Override
    public void init(CallRuntime cr) {
    }

    @Override
    protected ObjectCallResult callMethod(CallRuntime cr, String method) {
        switch (method) {
            case "=": 
            case "let": {
                I_Object streamit = cr.vce.vars.get(cr, this, null);
                I_Object arg = cr.args(streamit, I_Object.class)[0];
                this.let(cr, cr, arg, false);
                return A_Object.stdResult(this);
            }
            case "~=": 
            case "convertLet": {
                I_Object streamit2 = cr.vce.vars.get(cr, this, null);
                I_Object par2 = cr.args(streamit2, I_Object.class)[0];
                this.let(cr, cr, par2, true);
                return A_Object.stdResult(this);
            }
        }
        byte isVarFunction = Lib_Function.isVarFunction(method);
        if (isVarFunction > -1) {
            I_Object oldValue = cr.vce.vars.get(cr, this, null);
            if (oldValue == null) {
                throw new ExecError(cr, "Variable is not initialized", "The variable '" + this.name + "' has no value/type, please initialize it first.");
            }
            I_Object newValue = Lib_Function.calcLet(cr, method, isVarFunction, oldValue);
            this.let(cr, cr, newValue, true);
            return new ObjectCallResult(this, false);
        }
        return this.iCallValue(cr, method);
    }

    @Override
    public ObjectCallResult callEvent(CallRuntime cr, String event) {
        throw new CodeError(cr, "Invalid call of a event", "Got: " + event);
    }

    public I_Object get(CallRuntime cr) {
        return cr.vce.vars.get(cr, this);
    }

    @Override
    public boolean isInitialized(CallRuntime cr) {
        return cr.vce.vars.isInitialized(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public I_Object mPrint(CallRuntime cr, boolean newline) {
        this.get(cr);
        return super.mPrint(cr, newline);
    }

    @Override
    public void setType(String type, DebugInfo debugInfo) {
        if (!this.typesafe) {
            throw new CodeError("Invalid variable definition", "Can't set a fixed type to a type-unsafe variable: <" + type + "> " + this.name, debugInfo);
        }
        if (this.name.equals("it")) {
            throw new CodeError("Invalid variable definition", "Can't set a fixed type for the already defined magic variable: " + this.name, debugInfo);
        }
        this.initType = type;
    }

    public void let(CallRuntime crOld, CallRuntime crNew, I_Object o) {
        this.let(crOld, crNew, o, false);
    }

    public void let(CallRuntime crOld, CallRuntime crNew, I_Object o, boolean convert) {
        if (this.initType != null) {
            crNew.vce.vars.setType(crNew, this, this.initType);
            this.initType = null;
        }
        crNew.vce.vars.set(crOld, this, o, this.typesafe, this.nilable, convert);
        this.eventRunRaw(crNew, CHANGED_EVENT, o);
    }

    @Override
    protected boolean validateEvent(CallRuntime cr, String event) {
        return event.equals(CHANGED_EVENT);
    }

    @Override
    public String toStringIdent(CallRuntime cr) {
        Err.ifNull(cr);
        StringBuilder sb = new StringBuilder();
        sb.append(this.name);
        VarEnv ve = cr.vce.vars;
        if (ve.isInitialized(this)) {
            I_Object data = ve.get(cr, this);
            sb.append('[');
            sb.append(data.toStringIdent(cr));
            sb.append(']');
        } else if (this.initType != null) {
            sb.append('<');
            sb.append(this.initType);
            sb.append('>');
        }
        return sb.toString();
    }

    @Override
    public String toStringDescribe(CallRuntime cr) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.name);
        VarEnv ve = cr.vce.vars;
        if (ve.isInitialized(this)) {
            sb.append('[');
            I_Object data = ve.get(cr, this);
            sb.append(data.toStringDescribe(cr));
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public String toString(boolean nested) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.name);
        if (this.initType != null) {
            sb.append('<');
            sb.append(this.initType);
            sb.append('>');
        }
        return sb.toString();
    }

    private ObjectCallResult iCallValue(CallRuntime cr, String method) {
        ObjectCallResult result = this.get(cr).call(cr);
        if (result == null || result.obj == null) {
            Err.invalid("Call returns no result!");
        }
        return result;
    }
}

