/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.object.atom;

import de.mn77.base.data.Lib_String;
import de.mn77.base.data.constant.position.Lib_Position;
import de.mn77.base.data.constant.position.POSITION;
import de.mn77.base.data.constant.position.POSITION_H;
import de.mn77.base.data.convert.ConvChar;
import de.mn77.base.data.convert.ConvString;
import de.mn77.base.data.filter.FilterString;
import de.mn77.base.data.form.FormString;
import de.mn77.base.data.group.Group2;
import de.mn77.base.data.numsys.Binary;
import de.mn77.base.data.numsys.Hex;
import de.mn77.base.data.search.SearchText;
import de.mn77.base.data.struct.list.I_List;
import de.mn77.base.data.struct.table.MTable;
import de.mn77.base.data.struct.table.type.TypeTable2;
import de.mn77.base.data.type.Lib_Compare;
import de.mn77.base.error.Err;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.regex.PatternSyntaxException;
import org.jaymo_lang.error.ExecError;
import org.jaymo_lang.model.COMPARE;
import org.jaymo_lang.model.Call;
import org.jaymo_lang.model.I_AutoBlockDo;
import org.jaymo_lang.model.I_AutoBlockList;
import org.jaymo_lang.model.ObjectCallResult;
import org.jaymo_lang.object.A_Object;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.object.JMo_RegEx;
import org.jaymo_lang.object.LoopHandle;
import org.jaymo_lang.object.atom.A_Atomic;
import org.jaymo_lang.object.atom.A_Chars;
import org.jaymo_lang.object.atom.A_IntNumber;
import org.jaymo_lang.object.atom.Bool;
import org.jaymo_lang.object.atom.Char;
import org.jaymo_lang.object.atom.I_Atomic;
import org.jaymo_lang.object.atom.I_AtomicValue;
import org.jaymo_lang.object.atom.Int;
import org.jaymo_lang.object.atom.Nil;
import org.jaymo_lang.object.magic.con.MagicPosition;
import org.jaymo_lang.object.pseudo.Return;
import org.jaymo_lang.object.struct.I_DeepGetSet;
import org.jaymo_lang.object.struct.JMo_ByteArray;
import org.jaymo_lang.object.struct.JMo_List;
import org.jaymo_lang.object.struct.JMo_Table;
import org.jaymo_lang.object.sys.JMo_Cmd;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.util.ATOMIC;
import org.jaymo_lang.util.Lib_AtomConv;
import org.jaymo_lang.util.Lib_Convert;
import org.jaymo_lang.util.Lib_Error;
import org.jaymo_lang.util.Lib_Exec;
import org.jaymo_lang.util.Lib_Sequence;
import org.jaymo_lang.util.Lib_StrFormat;
import org.jaymo_lang.util.Lib_Type;

public class Str
extends A_Chars
implements I_Atomic,
I_AutoBlockDo,
I_AutoBlockList,
I_DeepGetSet {
    private final String value;

    public Str(String val) {
        Err.ifNull(val);
        this.value = val;
    }

    @Override
    protected ObjectCallResult call4(CallRuntime cr, String method) {
        switch (method) {
            case "isEmpty": {
                cr.args();
                return A_Object.stdResult(Bool.getObject(this.value.isEmpty()));
            }
            case "-": 
            case "sub": {
                return A_Object.stdResult(this.mSubtract(cr));
            }
            case "begin": {
                return A_Object.stdResult(this.mBegin(cr));
            }
            case "cut": {
                return A_Object.stdResult(this.mCut(cr));
            }
            case "area": 
            case "cutTo": {
                return A_Object.stdResult(this.mCutTo(cr));
            }
            case "left": {
                return A_Object.stdResult(this.mLeft(cr));
            }
            case "right": {
                return A_Object.stdResult(this.mRight(cr));
            }
            case "first": {
                return A_Object.stdResult(this.mFirstLast(cr, false));
            }
            case "last": {
                return A_Object.stdResult(this.mFirstLast(cr, true));
            }
            case "end": {
                return A_Object.stdResult(this.mEndPos(cr));
            }
            case "start": {
                return A_Object.stdResult(this.mStartPos(cr));
            }
            case "from": 
            case "fromFirst": {
                return A_Object.stdResult(this.mFromFirst(cr, true));
            }
            case "after": 
            case "afterFirst": {
                return A_Object.stdResult(this.mFromFirst(cr, false));
            }
            case "toFirst": 
            case "to": {
                return A_Object.stdResult(this.mToFirst(cr, true));
            }
            case "before": 
            case "beforeFirst": {
                return A_Object.stdResult(this.mToFirst(cr, false));
            }
            case "fromLast": {
                return A_Object.stdResult(this.mFromLast(cr, true));
            }
            case "afterLast": {
                return A_Object.stdResult(this.mFromLast(cr, false));
            }
            case "toLast": {
                return A_Object.stdResult(this.mToLast(cr, true));
            }
            case "beforeLast": {
                return A_Object.stdResult(this.mToLast(cr, false));
            }
            case "explode": 
            case "/": 
            case "split": {
                return A_Object.stdResult(this.mSplit(cr));
            }
            case "splitKeep": {
                return A_Object.stdResult(this.mSplitKeep(cr));
            }
            case "lines": {
                return A_Object.stdResult(this.mLines(cr));
            }
            case "field": {
                return A_Object.stdResult(this.mField(cr));
            }
            case "fields": {
                return A_Object.stdResult(this.mFields(cr));
            }
            case "table": {
                return A_Object.stdResult(this.mTable(cr));
            }
            case "scan": {
                return A_Object.stdResult(this.mScan(cr));
            }
            case "capitalize": 
            case "capital": {
                return A_Object.stdResult(this.mCapital(cr));
            }
            case "trim": {
                return A_Object.stdResult(this.mTrim(cr, true, true));
            }
            case "trimLeft": {
                return A_Object.stdResult(this.mTrim(cr, true, false));
            }
            case "trimRight": {
                return A_Object.stdResult(this.mTrim(cr, false, true));
            }
            case "width": {
                return A_Object.stdResult(this.mWidth(cr));
            }
            case "startsWith": {
                return A_Object.stdResult(this.mStartsWith(cr));
            }
            case "contains": 
            case "has": {
                return A_Object.stdResult(this.mHas(cr));
            }
            case "endsWith": {
                return A_Object.stdResult(this.mEndsWith(cr));
            }
            case "search": 
            case "searchFirst": {
                return A_Object.stdResult(this.mSearch(cr, true));
            }
            case "searchLast": {
                return A_Object.stdResult(this.mSearch(cr, false));
            }
            case "count": {
                return A_Object.stdResult(this.mCount(cr));
            }
            case "replace": {
                return A_Object.stdResult(this.mReplace(cr));
            }
            case "match": {
                return A_Object.stdResult(this.mMatch(cr));
            }
            case "set": {
                return A_Object.stdResult(this.mSetChar(cr, false));
            }
            case "put": {
                return A_Object.stdResult(this.mSetChar(cr, true));
            }
            case "reverse": {
                return A_Object.stdResult(this.mReverse(cr));
            }
            case "insert": {
                return A_Object.stdResult(this.mInsert(cr));
            }
            case "align": {
                return A_Object.stdResult(this.mAlign(cr));
            }
            case "fill": {
                return A_Object.stdResult(this.mFill(cr));
            }
            case "quote": {
                return A_Object.stdResult(this.mQuote(cr));
            }
            case "unquote": {
                return A_Object.stdResult(this.mUnquote(cr));
            }
            case "jmo": {
                return A_Object.stdResult(this.mExecJMO(cr));
            }
            case "cmd": {
                return A_Object.stdResult(this.mExecCMD(cr));
            }
            case "parseHex": {
                return A_Object.stdResult(this.mParseHex(cr));
            }
            case "parseUnicode": {
                return A_Object.stdResult(this.mParseUnicode(cr));
            }
            case "parseBin": {
                return A_Object.stdResult(this.mParseBin(cr));
            }
            case "toChars": 
            case "chars": {
                return A_Object.stdResult(this.mToChars(cr));
            }
            case "each": {
                return this.each(cr);
            }
            case "toByteArray": 
            case "getBytes": {
                return A_Object.stdResult(this.mToByteArray(cr));
            }
            case "toRegEx": 
            case "toRegex": {
                cr.args();
                return A_Object.stdResult(new JMo_RegEx(this.value));
            }
            case "filter": {
                return A_Object.stdResult(this.mFilter(cr, method));
            }
            case "map": {
                return A_Object.stdResult(this.mMap(cr, method));
            }
            case "sort": {
                return A_Object.stdResult(this.mSort(cr, method));
            }
            case "reduce": {
                return A_Object.stdResult(this.mReduce(cr, method));
            }
            case "amount": {
                return A_Object.stdResult(this.mAmount(cr, method));
            }
        }
        return null;
    }

    @Override
    public I_Object autoBlockDo(CallRuntime cr) {
        return this.each((CallRuntime)cr).obj;
    }

    @Override
    public ArrayList<I_Object> autoBlockToList(CallRuntime cr) {
        ArrayList<I_Object> result = new ArrayList<I_Object>();
        char[] cArray = this.value.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            result.add(new Char(c));
            ++n2;
        }
        return result;
    }

    @Override
    public Integer compareTo3(I_AtomicValue o) {
        if (o instanceof Str) {
            return this.value.compareTo(((Str)o).getValue());
        }
        return null;
    }

    private ObjectCallResult each(CallRuntime crOld) {
        crOld.args();
        Lib_Exec.checkLoopWithout(crOld);
        LoopHandle handle = new LoopHandle(this);
        CallRuntime crNew = crOld.copyLoop(handle);
        I_Object result = Nil.NIL;
        char[] cArray = this.value.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            handle.startLap();
            Char it = new Char(c);
            result = Lib_Exec.execBlockStream(crNew, it);
            result = Lib_Exec.loopResult(result);
            if (result instanceof Return) {
                return ((Return)result).getLoopResult();
            }
            ++n2;
        }
        return new ObjectCallResult(result, true);
    }

    private Str mFilter(CallRuntime cr, String method) {
        Lib_Error.ifArgs(cr.argCount(), 1, (Integer)2, cr, this);
        StringBuilder result = new StringBuilder();
        int p = 0;
        while (p < this.value.length()) {
            char test = this.value.charAt(p);
            Char testc = new Char(test);
            Bool ok = (Bool)cr.copyEach(method).argsEach(this, 0, new I_Object[]{testc}, Bool.class);
            if (ok.getValue().booleanValue()) {
                result.append(test);
            }
            ++p;
        }
        return new Str(result.toString());
    }

    private Str mMap(CallRuntime cr, String method) {
        Lib_Error.ifArgs(cr.argCount(), 1, (Integer)2, cr, this);
        StringBuilder result = new StringBuilder();
        int p = 0;
        while (p < this.value.length()) {
            Char test = new Char(this.value.charAt(p));
            I_Object[] each = new I_Object[]{test};
            I_Object testr = cr.copyEach(method).argsEach(this, 0, each, I_Object.class);
            result.append(testr);
            ++p;
        }
        return new Str(result.toString());
    }

    private I_Object mReduce(CallRuntime cr, String method) {
        Lib_Error.ifArgs(cr.argCount(), 2, (Integer)3, cr, this);
        I_Object sum = cr.argsOneAdvance(this, 0, I_Object.class);
        int p = 0;
        while (p < this.value.length()) {
            Char test = new Char(this.value.charAt(p));
            I_Object[] each = new I_Object[]{sum, test};
            sum = cr.copyEach(method).argsEach(this, 1, each, I_Object.class);
            ++p;
        }
        return sum;
    }

    private Int mAmount(CallRuntime cr, String method) {
        Lib_Error.ifArgs(cr.argCount(), 1, (Integer)2, cr, this);
        int result = 0;
        char[] cArray = this.value.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char test = cArray[n2];
            Bool ok = (Bool)cr.copyEach(method).argsEach(this, 0, new I_Object[]{new Char(test)}, Bool.class);
            if (ok.getValue().booleanValue()) {
                ++result;
            }
            ++n2;
        }
        return new Int(result);
    }

    private Str mSort(CallRuntime cr, String method) {
        int parCount = cr.argCount();
        Lib_Error.ifArgs(parCount, 0, (Integer)2, cr, this);
        ArrayList<Character> list = new ArrayList<Character>();
        Object object = this.value.toCharArray();
        int n = ((char[])object).length;
        int n2 = 0;
        while (n2 < n) {
            char c = object[n2];
            list.add(Character.valueOf(c));
            ++n2;
        }
        if (parCount == 0) {
            cr.args();
            list.sort((o1, o2) -> Lib_Compare.isEqual(o1, o2) ? 0 : (Lib_Compare.isGreater(o1, o2) ? 1 : -1));
            StringBuilder sb = new StringBuilder();
            for (Character c : list) {
                sb.append(c);
            }
            return new Str(sb.toString());
        }
        int l = 1;
        while (l < list.size()) {
            int smallest = l;
            int m = l + 1;
            while (m <= list.size()) {
                Character buffer1 = (Character)list.get(smallest - 1);
                Character buffer2 = (Character)list.get(m - 1);
                I_Object[] test = new I_Object[]{new Char(buffer1.charValue()), new Char(buffer2.charValue())};
                Bool correct = (Bool)cr.copyEach(method).argsEach(this, 0, test, Bool.class);
                if (!correct.getValue().booleanValue()) {
                    smallest = m;
                }
                ++m;
            }
            if (l != smallest) {
                int pos1 = smallest - 1;
                int pos2 = l - 1;
                Character buffer1 = (Character)list.get(pos1);
                Character buffer2 = (Character)list.get(pos2);
                list.set(pos1, buffer2);
                list.set(pos2, buffer1);
            }
            ++l;
        }
        StringBuilder sb = new StringBuilder();
        object = list.iterator();
        while (object.hasNext()) {
            Character c = (Character)object.next();
            sb.append(c);
        }
        return new Str(sb.toString());
    }

    private JMo_List mToChars(CallRuntime cr) {
        cr.args();
        char[] ca = this.value.toCharArray();
        ArrayList<I_Object> al = new ArrayList<I_Object>();
        char[] cArray = ca;
        int n = ca.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            al.add(new Char(c));
            ++n2;
        }
        return new JMo_List(al);
    }

    private JMo_ByteArray mToByteArray(CallRuntime cr) {
        cr.args();
        byte[] ba = this.value.getBytes(StandardCharsets.UTF_8);
        return new JMo_ByteArray(ba);
    }

    private Str mFill(CallRuntime cr) {
        I_Object[] oa = cr.argsVar(this, 0, 0);
        int oaPos = 0;
        int pos = 0;
        StringBuilder sb = new StringBuilder();
        while (pos < this.value.length()) {
            Group2<Boolean, String> part = Lib_StrFormat.getNext(this.value, pos);
            pos += ((String)part.o2).length();
            if (!((Boolean)part.o1).booleanValue()) {
                sb.append((String)part.o2);
                continue;
            }
            if (oaPos >= oa.length) continue;
            sb.append(Lib_StrFormat.format(cr, (String)part.o2, oa[oaPos++]));
        }
        return new Str(sb.toString());
    }

    @Override
    public I_AtomicValue convertTo(CallRuntime cr, ATOMIC to) {
        return Lib_AtomConv.convert(cr, ATOMIC.STR, to, this, this.getValue());
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public String toStringDescribe(CallRuntime cr) {
        String s = FormString.escapeSpecialChars(this.value, false, true);
        return "\"" + s + "\"";
    }

    @Override
    public String toStringIdent() {
        String s = FormString.escapeSpecialChars(this.value, false, true);
        return s.length() <= 40 ? "\"" + s + "\"" : "\"" + s.substring(0, 37) + "\u2026\"";
    }

    @Override
    public String toString(boolean nested) {
        String out = this.value;
        if (nested) {
            return out.length() <= 40 ? out : String.valueOf(out.substring(0, 40)) + "\u2026";
        }
        return out;
    }

    @Override
    protected Bool mComparsion(CallRuntime cr, COMPARE m) {
        I_Object o = cr.args(this, A_Chars.class)[0];
        String arg = Lib_Convert.getStringValue(cr, o);
        switch (m) {
            case G: {
                return Bool.getObject(this.value.compareTo(arg) > 0);
            }
            case L: {
                return Bool.getObject(this.value.compareTo(arg) < 0);
            }
            case GE: {
                return Bool.getObject(this.value.compareTo(arg) >= 0);
            }
            case LE: {
                return Bool.getObject(this.value.compareTo(arg) <= 0);
            }
        }
        throw Err.impossible(new Object[]{m});
    }

    @Override
    protected Str mAdd(CallRuntime cr) {
        I_Object[] args = cr.argsVar(this, 1, 0);
        String result = this.value;
        I_Object[] i_ObjectArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            I_Object arg = i_ObjectArray[n2];
            result = String.valueOf(result) + Lib_Convert.getStringValue(cr, arg);
            ++n2;
        }
        return new Str(result);
    }

    private Str mBegin(CallRuntime cr) {
        I_Object arg = cr.args(this, I_Object.class)[0];
        String ps = Lib_Convert.getStringValue(cr, arg);
        return new Str(String.valueOf(ps) + this.value);
    }

    private Str mAlign(CallRuntime cr) {
        I_Object[] args = cr.args(this, MagicPosition.class, A_IntNumber.class);
        int arg = Lib_Convert.getIntValue(cr, args[1]);
        MagicPosition pos1 = (MagicPosition)Lib_Convert.getValue(cr, args[0]);
        POSITION pos2 = pos1.get();
        if (!Lib_Position.isHorizontal(pos2)) {
            throw new ExecError(cr, "Invalid position", "Only left,center and right are alowed. Got: " + pos1);
        }
        String s = FormString.width(arg, ' ', this.value, (POSITION_H)((Object)pos2), false);
        return new Str(s);
    }

    private Str mCapital(CallRuntime cr) {
        cr.args();
        String s = this.value.toLowerCase();
        String result = "";
        if (s.length() > 0) {
            result = ("" + s.charAt(0)).toUpperCase();
        }
        if (s.length() > 1) {
            result = String.valueOf(result) + s.substring(1);
        }
        return new Str(result);
    }

    @Override
    protected Str mCaseDown(CallRuntime cr) {
        cr.args();
        return new Str(this.value.toLowerCase());
    }

    @Override
    protected Str mCaseUp(CallRuntime cr) {
        cr.args();
        return new Str(this.value.toUpperCase());
    }

    @Override
    protected I_Object mCharAt(CallRuntime cr, boolean lazy) {
        int pos = Lib_Convert.getIntValue(cr, cr.args(this, A_IntNumber.class)[0]);
        pos = Lib_Sequence.realPos(cr, pos, this.value.length(), lazy);
        if (lazy && (pos < 1 || pos > this.value.length())) {
            return Nil.NIL;
        }
        return new Char(this.value.charAt(pos - 1));
    }

    private Str mField(CallRuntime cr) {
        I_Object[] oa = cr.args(this, I_AtomicValue.class, A_IntNumber.class);
        String delimiter = Lib_Convert.getStringValue(cr, oa[0]);
        String[] sa = this.value.split(delimiter);
        int col = Lib_Convert.getIntValue(cr, oa[1]);
        Lib_Error.ifTooSmall(cr, 1L, col);
        return col > sa.length ? new Str("") : new Str(sa[col - 1]);
    }

    private JMo_List mFields(CallRuntime cr) {
        I_Object[] oa = cr.argsVar(this, 1, 1);
        I_Object parDelimiter = cr.argType(oa[0], I_AtomicValue.class);
        String delimiter = Lib_Convert.getStringValue(cr, parDelimiter);
        String[] sa = this.value.split(delimiter);
        ArrayList<I_Object> al = new ArrayList<I_Object>();
        if (oa.length == 1) {
            String[] stringArray = sa;
            int n = sa.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                al.add(new Str(s));
                ++n2;
            }
        } else {
            int i = 1;
            while (i < oa.length) {
                int col = Lib_Convert.getIntValue(cr, oa[i]);
                Lib_Error.ifTooSmall(cr, 1L, col);
                Str s = col > sa.length ? new Str("") : new Str(sa[col - 1]);
                al.add(s);
                ++i;
            }
        }
        return new JMo_List(al);
    }

    private JMo_List mScan(CallRuntime cr) {
        I_Object[] oa = cr.args(this, I_AtomicValue.class, I_AtomicValue.class);
        String start = Lib_Convert.getStringValue(cr, oa[0]);
        String end = Lib_Convert.getStringValue(cr, oa[1]);
        ArrayList<I_Object> result = new ArrayList<I_Object>();
        int len = this.value.length();
        int idx = 0;
        int next = 0;
        boolean open = false;
        while (idx < len) {
            if (!open) {
                next = this.value.indexOf(start, idx);
                if (next == -1) {
                    return new JMo_List(result);
                }
                idx = next + start.length();
                open = true;
                continue;
            }
            next = this.value.indexOf(end, idx);
            if (next == -1) {
                result.add(new Str(this.value.substring(idx)));
                return new JMo_List(result);
            }
            result.add(new Str(this.value.substring(idx, next)));
            idx = next + end.length();
            open = false;
        }
        if (open) {
            result.add(new Str(this.value.substring(idx)));
        }
        return new JMo_List(result);
    }

    private JMo_Table mTable(CallRuntime cr) {
        I_Object arg = cr.args(this, I_AtomicValue.class)[0];
        String delimiter = Lib_Convert.getStringValue(cr, arg);
        String[] lines = this.value.split("\n");
        int len = lines.length;
        String[][] splitLines = new String[len][0];
        int i = 0;
        while (i < len) {
            splitLines[i] = ConvString.toStringArray(delimiter, lines[i]);
            ++i;
        }
        int max_width = 1;
        int i2 = 0;
        while (i2 < len) {
            max_width = Math.max(splitLines[i2].length, max_width);
            ++i2;
        }
        MTable<I_Object> tab = new MTable<I_Object>(max_width);
        int r = 0;
        while (r < len) {
            I_Object[] row = new I_Object[max_width];
            int c = 0;
            while (c < max_width) {
                row[c] = splitLines[r].length - 1 >= c ? new Str(splitLines[r][c]) : new Str("");
                ++c;
            }
            tab.add((I_Object[])row);
            ++r;
        }
        return new JMo_Table(tab);
    }

    private Str mCut(CallRuntime cr) {
        I_Object[] args = cr.args(this, A_IntNumber.class, A_IntNumber.class);
        int from = Lib_Convert.getIntValue(cr, args[0]);
        int len = Lib_Convert.getIntValue(cr, args[1]);
        Lib_Error.ifNotBetween(cr, 1, this.value.length(), from, "'from'");
        Lib_Error.ifNotBetween(cr, 0, this.value.length() - from + 1, len, "'length'");
        int to = from + len;
        String s = this.value.substring(from - 1, to - 1);
        return new Str(s);
    }

    private Str mCutTo(CallRuntime cr) {
        I_Object[] args = cr.args(this, A_IntNumber.class, A_IntNumber.class);
        int from = Lib_Convert.getIntValue(cr, args[0]);
        int to = Lib_Convert.getIntValue(cr, args[1]);
        Lib_Error.ifNotBetween(cr, 1, this.value.length(), from, "'from'");
        Lib_Error.ifNotBetween(cr, from, this.value.length(), to, "'length'");
        String s = this.value.substring(from - 1, to);
        return new Str(s);
    }

    private Bool mEndsWith(CallRuntime cr) {
        I_Object[] args;
        I_Object[] i_ObjectArray = args = cr.argsVar(this, 1, 0);
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            I_Object o = i_ObjectArray[n2];
            String s = Lib_Convert.getStringValue(cr, cr.argType(o, I_AtomicValue.class));
            if (this.value.endsWith(s)) {
                return Bool.TRUE;
            }
            ++n2;
        }
        return Bool.FALSE;
    }

    private I_Object mExecCMD(CallRuntime cr) {
        cr.args();
        cr.getStrict().checkSave(cr, "Str.command");
        Call c = new Call(cr.getSurrBlock(), this, cr.getDebugInfo());
        return new JMo_Cmd(c);
    }

    private Str mExecJMO(CallRuntime cr) {
        cr.args();
        return Lib_Exec.execJMo(cr, this.value, "Str.jmo", false);
    }

    private Str mStartPos(CallRuntime cr) {
        I_Object arg = cr.args(this, A_IntNumber.class)[0];
        int begin = Lib_Convert.getIntValue(cr, arg);
        if (begin == 0) {
            throw new ExecError(cr, "Invalid position in string", "Position can't be 0");
        }
        if (begin < 0) {
            begin = this.value.length() + begin + 1;
        }
        if (begin < 1 || begin > this.value.length()) {
            return new Str("");
        }
        String s = this.value.substring(begin - 1);
        return new Str(s);
    }

    private Str mFromFirst(CallRuntime cr, boolean withDelimiter) {
        I_Object[] args = cr.argsVar(this, 1, 0);
        int idx = -1;
        String lastDelimiter = null;
        I_Object[] i_ObjectArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            I_Object arg = i_ObjectArray[n2];
            String delimiter = Lib_Convert.getStringValue(cr, arg);
            int idx2 = this.value.indexOf(delimiter);
            if (idx2 > -1 && (idx == -1 || idx2 < idx)) {
                idx = idx2;
                lastDelimiter = delimiter;
            }
            ++n2;
        }
        String result = idx >= 0 ? this.value.substring(idx + (withDelimiter ? 0 : lastDelimiter.length())) : "";
        return new Str(result);
    }

    private Str mFromLast(CallRuntime cr, boolean withDelimiter) {
        I_Object[] args = cr.argsVar(this, 1, 0);
        int beginindex = -1;
        String lastDelimiter = null;
        I_Object[] i_ObjectArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            I_Object arg = i_ObjectArray[n2];
            String delimiter = Lib_Convert.getStringValue(cr, arg);
            int idx2 = this.value.lastIndexOf(delimiter);
            if (idx2 > -1 && (beginindex == -1 || idx2 > beginindex)) {
                beginindex = idx2;
                lastDelimiter = delimiter;
            }
            ++n2;
        }
        String result = beginindex >= 0 ? this.value.substring(beginindex + (withDelimiter ? 0 : lastDelimiter.length())) : "";
        return new Str(result);
    }

    private Bool mHas(CallRuntime cr) {
        I_AtomicValue arg = (I_AtomicValue)cr.args(this, I_AtomicValue.class)[0];
        int index = this.value.indexOf(Lib_Convert.getStringValue(cr, arg));
        return Bool.getObject(index > -1);
    }

    private Int mParseHex(CallRuntime cr) {
        cr.args();
        int i = Hex.fromHex(this.value);
        return new Int(i);
    }

    private Int mParseBin(CallRuntime cr) {
        cr.args();
        int i = Binary.fromBin(this.value);
        return new Int(i);
    }

    private Char mParseUnicode(CallRuntime cr) {
        cr.args();
        char c = ConvChar.parseUnicode(this.value);
        return new Char(c);
    }

    private Str mLeft(CallRuntime cr) {
        I_Object arg = cr.args(this, A_IntNumber.class)[0];
        int to = Lib_Convert.getIntValue(cr, arg);
        if (to > this.value.length()) {
            return this;
        }
        Lib_Error.ifTooSmall(cr, 1L, to);
        String s = this.value.substring(0, to);
        return new Str(s);
    }

    private Char mFirstLast(CallRuntime cr, boolean last) {
        cr.args();
        if (this.value.length() == 0) {
            throw new ExecError(cr, "Empty String", "Can't get first or last Char.");
        }
        return new Char(this.value.charAt(last ? this.value.length() - 1 : 0));
    }

    private JMo_List mLines(CallRuntime cr) {
        cr.args();
        String[] sa = this.value.split("\n");
        JMo_List list = new JMo_List();
        String[] stringArray = sa;
        int n = sa.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            list.internalAdd(new Str(s));
            ++n2;
        }
        return list;
    }

    private Bool mMatch(CallRuntime cr) {
        I_Object o = cr.args(this, JMo_RegEx.class)[0];
        String reg = ((JMo_RegEx)o).getValue();
        return Bool.getObject(this.value.matches(reg));
    }

    @Override
    protected Str mMultiply(CallRuntime cr) {
        I_Object arg = cr.args(this, A_IntNumber.class)[0];
        int i = Lib_Convert.getIntValue(cr, arg);
        String s = Lib_String.sequence(this.value, (long)i);
        return new Str(s);
    }

    private I_Object mInsert(CallRuntime cr) {
        I_Object[] args = cr.args(this, A_Atomic.class, A_IntNumber.class);
        String ins = Lib_Convert.getStringValue(cr, args[0]);
        int pos = Lib_Convert.getIntValue(cr, args[1]);
        int len = this.value.length();
        Lib_Error.ifIs(cr, 0, pos, "position");
        Lib_Error.ifOutOfBounds(cr, len + 1, pos, "position");
        String result = Lib_String.insert(ins, pos, this.value);
        return new Str(result);
    }

    private Str mReplace(CallRuntime cr) {
        I_Object[] args = cr.argsExt(this, {I_AtomicValue.class, JMo_RegEx.class}, {I_AtomicValue.class});
        String s2 = Lib_Convert.getStringValue(cr, args[1]);
        if (args[0] instanceof JMo_RegEx) {
            String regex = ((JMo_RegEx)args[0]).getValue();
            try {
                String result = this.value.replaceAll(regex, s2);
                return new Str(result);
            }
            catch (PatternSyntaxException e) {
                throw new ExecError(cr, "Invalid Pattern Syntax", e.getMessage());
            }
        }
        String s1 = Lib_Convert.getStringValue(cr, args[0]);
        String result = this.value.replace(s1, s2);
        return new Str(result);
    }

    private Str mSetChar(CallRuntime cr, boolean lazy) {
        I_Object[] args = cr.args(this, Char.class, A_IntNumber.class);
        char c = Lib_Convert.getCharValue(cr, args[0]);
        int pos1 = Lib_Convert.getIntValue(cr, args[1]);
        int pos = Lib_Sequence.realPos(cr, pos1, this.value.length(), lazy);
        String base = this.value;
        if (pos == -1) {
            int posAbs = Math.abs(pos1);
            if (pos1 < 0) {
                pos = 1;
                base = String.valueOf(Lib_String.sequence(' ', (long)(posAbs - base.length()))) + base;
            } else {
                pos = posAbs;
                base = String.valueOf(base) + Lib_String.sequence(' ', (long)(posAbs - base.length()));
            }
        }
        String result = pos <= 1 ? "" : base.substring(0, pos - 1);
        result = String.valueOf(result) + c;
        result = String.valueOf(result) + base.substring(pos);
        return new Str(result);
    }

    private Str mRight(CallRuntime cr) {
        int len;
        I_Object arg = cr.args(this, A_IntNumber.class)[0];
        int begin = Lib_Convert.getIntValue(cr, arg);
        if (begin > (len = this.value.length())) {
            return this;
        }
        Lib_Error.ifTooSmall(cr, 1L, begin);
        String s = this.value.substring(len - begin);
        return new Str(s);
    }

    private I_Atomic mSearch(CallRuntime cr, boolean first) {
        I_Object arg = cr.args(this, I_Object.class)[0];
        String search = Lib_Convert.getStringValue(cr, arg);
        int idx = first ? this.value.indexOf(search) : this.value.lastIndexOf(search);
        return idx < 0 ? Nil.NIL : new Int(idx + 1);
    }

    private Int mCount(CallRuntime cr) {
        I_Object arg = cr.args(this, Char.class)[0];
        int result = SearchText.countChar(this.value, ((Char)arg).getValue().charValue());
        return new Int(result);
    }

    @Override
    protected Str mChangeChar(CallRuntime cr) {
        I_Object[] oa = cr.args(this, A_IntNumber.class, A_Chars.class);
        int pos = Lib_Convert.getIntValue(cr, oa[0]);
        pos = Lib_Sequence.realPos(cr, pos, this.value.length(), false);
        I_Object o = oa[1];
        String n = Lib_Convert.getStringValue(cr, o);
        String l = pos == 1 ? "" : this.value.substring(0, pos - 1);
        String r = pos == this.value.length() ? "" : this.value.substring(pos);
        return new Str(String.valueOf(l) + n + r);
    }

    private JMo_List mSplit(CallRuntime cr) {
        I_Object arg;
        I_Object[] args = cr.argsFlex(this, 0, 1);
        I_Object i_Object = arg = args.length == 0 ? null : cr.argTypeExt(args[0], A_Chars.class, A_IntNumber.class, JMo_RegEx.class);
        if (args.length == 0 || arg instanceof Str && ((Str)arg).value.length() == 0) {
            JMo_List list = new JMo_List();
            char[] cArray = this.value.toCharArray();
            int n = cArray.length;
            int n2 = 0;
            while (n2 < n) {
                char c = cArray[n2];
                list.internalAdd(new Char(c));
                ++n2;
            }
            return list;
        }
        if (arg instanceof JMo_RegEx) {
            String regex = ((JMo_RegEx)arg).getValue();
            String[] sa = this.value.split(regex);
            JMo_List list = new JMo_List();
            String[] stringArray = sa;
            int n = sa.length;
            int n3 = 0;
            while (n3 < n) {
                String s = stringArray[n3];
                list.internalAdd(new Str(s));
                ++n3;
            }
            return list;
        }
        if (arg instanceof Int) {
            int count = Lib_Convert.getIntValue(cr, arg);
            Lib_Error.ifTooSmall(cr, 1L, count);
            JMo_List list = new JMo_List();
            String str = this.value;
            int start = 0;
            while (start < str.length()) {
                list.internalAdd(new Str(str.substring(start, Math.min(str.length(), start + count))));
                start += count;
            }
            return list;
        }
        String delimiter = "" + ((I_AtomicValue)arg).getValue();
        ArrayList<String> sl = ConvString.toList(delimiter, this.value);
        JMo_List list = new JMo_List();
        for (String s : sl) {
            list.internalAdd(new Str(s));
        }
        return list;
    }

    private JMo_List mSplitKeep(CallRuntime cr) {
        I_Object o = cr.argsExt(this, new Class[][]{{I_AtomicValue.class, JMo_List.class}})[0];
        TypeTable2<String, Boolean> tab = null;
        if (o instanceof I_AtomicValue) {
            tab = ConvString.splitToTable(this.value, o.toString());
        } else if (o instanceof JMo_List) {
            JMo_List delimiters = (JMo_List)o;
            ArrayList<String> al = new ArrayList<String>();
            for (I_Object delimiter : delimiters.getInternalCollection()) {
                if (!(delimiter instanceof I_AtomicValue)) {
                    throw new ExecError(cr, "Non-Atomic Delimiter", "Got: " + Lib_Type.getName(delimiter.getClass(), delimiter));
                }
                al.add(Lib_Convert.getStringValue(cr, delimiter));
            }
            tab = ConvString.splitToTable(this.value, al.toArray(new String[al.size()]));
        } else {
            throw Err.todo(o);
        }
        I_List<String> data = tab.getCol1();
        JMo_List list = new JMo_List();
        for (String s : data) {
            list.internalAdd(new Str(s));
        }
        return list;
    }

    private Bool mStartsWith(CallRuntime cr) {
        I_Object[] args;
        I_Object[] i_ObjectArray = args = cr.argsVar(this, 1, 0);
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            I_Object o = i_ObjectArray[n2];
            String s = Lib_Convert.getStringValue(cr, cr.argType(o, I_AtomicValue.class));
            if (this.value.startsWith(s)) {
                return Bool.TRUE;
            }
            ++n2;
        }
        return Bool.FALSE;
    }

    private Str mSubtract(CallRuntime cr) {
        I_Object o = cr.args(this, I_Object.class)[0];
        return new Str(this.value.replace(Lib_Convert.getStringValue(cr, o), ""));
    }

    private Str mEndPos(CallRuntime cr) {
        I_Object arg = cr.args(this, A_IntNumber.class)[0];
        int to = Lib_Convert.getIntValue(cr, arg);
        if (to == 0) {
            throw new ExecError(cr, "Invalid position in string", "Position can't be 0");
        }
        if (to >= this.value.length()) {
            return new Str(this.value);
        }
        if (to < 0 && Math.abs(to) > this.value.length()) {
            return new Str("");
        }
        if (to < 0) {
            to = this.value.length() + to + 1;
        }
        String s = this.value.substring(0, to);
        return new Str(s);
    }

    private Str mToFirst(CallRuntime cr, boolean withDelimiter) {
        I_Object[] args = cr.argsVar(this, 1, 0);
        int idx = -1;
        int dlen = 0;
        I_Object[] i_ObjectArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            I_Object arg = i_ObjectArray[n2];
            String delimiter = Lib_Convert.getStringValue(cr, arg);
            int idx2 = this.value.indexOf(delimiter);
            if (idx2 >= 0 && (idx == -1 || idx2 < idx)) {
                idx = idx2;
                dlen = delimiter.length();
            }
            ++n2;
        }
        if (!withDelimiter) {
            dlen = 0;
        }
        return idx >= 0 ? new Str(this.value.substring(0, idx + dlen)) : this;
    }

    private Str mToLast(CallRuntime cr, boolean withDelimiter) {
        I_Object[] args = cr.argsVar(this, 1, 0);
        int idx = -1;
        int dlen = 0;
        I_Object[] i_ObjectArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            I_Object arg = i_ObjectArray[n2];
            String delimiter = Lib_Convert.getStringValue(cr, arg);
            int idx2 = this.value.lastIndexOf(delimiter);
            if (idx2 >= 0 && (idx == -1 || idx2 > idx)) {
                idx = idx2;
                dlen = delimiter.length();
            }
            ++n2;
        }
        if (!withDelimiter) {
            dlen = 0;
        }
        return idx >= 0 ? new Str(this.value.substring(0, idx + dlen)) : this;
    }

    private Str mTrim(CallRuntime cr, boolean left, boolean right) {
        I_Object[] args = cr.argsVar(this, 0, 0);
        if (args.length == 0) {
            String s = FilterString.trim(this.value, new char[]{' ', '\t', '\r', '\f', '\n'}, left, right);
            return new Str(s);
        }
        char[] ca = new char[args.length];
        int i = 0;
        while (i < args.length) {
            ca[i] = ((Char)cr.argType(args[i], Char.class)).getValue().charValue();
            ++i;
        }
        String s = FilterString.trim(this.value, ca, left, right);
        return new Str(s);
    }

    private Str mWidth(CallRuntime cr) {
        I_Object arg = cr.args(this, A_IntNumber.class)[0];
        int width = Lib_Convert.getIntValue(cr, arg);
        Lib_Error.ifTooSmall(cr, 0L, width);
        int len = this.value.length();
        if (len == width) {
            return this;
        }
        if (len > width) {
            return new Str(this.value.substring(0, width));
        }
        return new Str(String.valueOf(this.value) + Lib_String.sequence(' ', (long)(width - len)));
    }

    private I_Object mQuote(CallRuntime cr) {
        I_Object[] args = cr.argsFlex(this, 0, 1);
        int pari = 2;
        if (args.length == 1) {
            I_Object arg = cr.argType(args[0], A_IntNumber.class);
            pari = Lib_Convert.getIntValue(cr, arg);
        }
        switch (pari) {
            case 1: {
                return new Str(FormString.quote(this.value, '\'', '\\'));
            }
            case 2: {
                return new Str(FormString.quote(this.value, '\"', '\\'));
            }
            case 3: {
                return new Str(FormString.quote(this.value, '\'', '\''));
            }
            case 4: {
                return new Str(FormString.quote(this.value, '\"', '\"'));
            }
        }
        throw new ExecError(cr, "Invalid quote format", "Allowed are 1-4, but got: " + pari);
    }

    private I_Object mUnquote(CallRuntime cr) {
        I_Object[] args = cr.argsFlex(this, 0, 1);
        int pari = 2;
        if (args.length == 1) {
            I_Object arg = cr.argType(args[0], A_IntNumber.class);
            pari = Lib_Convert.getIntValue(cr, arg);
        }
        switch (pari) {
            case 1: {
                return new Str(FormString.unquote(this.value, '\'', '\\'));
            }
            case 2: {
                return new Str(FormString.unquote(this.value, '\"', '\\'));
            }
            case 3: {
                return new Str(FormString.unquote(this.value, '\'', '\''));
            }
            case 4: {
                return new Str(FormString.unquote(this.value, '\"', '\"'));
            }
        }
        throw new ExecError(cr, "Invalid quote format", "Allowed are 1-4, but got: " + pari);
    }

    private I_Object mReverse(CallRuntime cr) {
        cr.args();
        int len = this.value.length();
        char[] source = this.value.toCharArray();
        char[] target = new char[len];
        int i = 0;
        while (i < len) {
            target[i] = source[len - 1 - i];
            ++i;
        }
        return new Str(new String(target));
    }

    @Override
    public I_Object sequenceDeepGet(CallRuntime cr, I_Object[] keys, int offset, boolean lazy) {
        A_IntNumber oi = (A_IntNumber)cr.argType(keys[offset], A_IntNumber.class);
        int i = Lib_Convert.getIntValue(cr, oi);
        int pos = Lib_Sequence.realPos(cr, i, this.value.length(), lazy);
        if (pos == -1 || pos > this.value.length()) {
            if (lazy) {
                return Nil.NIL;
            }
            Lib_Error.ifNotBetween(cr, 1, this.value.length(), pos, "position in list");
        }
        if (offset == keys.length - 1) {
            return new Char(this.value.charAt(pos - 1));
        }
        StringBuilder sb = new StringBuilder();
        int j = 0;
        while (j <= offset) {
            if (j > 0) {
                sb.append(',');
            }
            sb.append(keys[j].toString());
            ++j;
        }
        throw new ExecError(cr, "Invalid type of item.", "Item at position (" + sb.toString() + ") is a single <Char>, so I can't go deeper!");
    }

    @Override
    public void sequenceDeepSet(CallRuntime cr, I_Object[] keys, int offset, I_Object value, boolean lazy) {
        throw new ExecError(cr, "Invalid type of item.", "A String is immutable, so it can't be modified!");
    }

    @Override
    protected JMo_List mSelect(CallRuntime cr, boolean lazy) {
        I_Object[] args = cr.argsVar(this, 0, 0);
        ArrayList<I_Object> list = new ArrayList<I_Object>();
        I_Object[] i_ObjectArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            I_Object arg = i_ObjectArray[n2];
            int pos = Lib_Convert.getIntValue(cr, cr.argType(arg, A_IntNumber.class));
            pos = Lib_Sequence.realPos(cr, pos, this.value.length(), lazy);
            if (lazy && (pos < 1 || pos > this.value.length())) {
                list.add(Nil.NIL);
            } else {
                list.add(new Char(this.value.charAt(pos - 1)));
            }
            ++n2;
        }
        return new JMo_List(list);
    }

    @Override
    protected final Str mUpdate(CallRuntime cr, boolean lazy) {
        I_Object[] oa = cr.argsVar(this, 1, 1);
        I_Object obj = cr.argType(oa[0], null);
        char c = Lib_Convert.getCharValue(cr, obj);
        StringBuilder sb = new StringBuilder(this.value);
        int i = 1;
        while (i < oa.length) {
            int pos1 = Lib_Convert.getIntValue(cr, cr.argType(oa[i], A_IntNumber.class));
            int pos2 = Lib_Sequence.realPos(cr, pos1, sb.length(), lazy);
            if (pos2 < 0 && lazy) {
                pos2 = pos1;
                while (pos2 > sb.length()) {
                    sb.append(' ');
                }
            }
            sb.setCharAt(pos2 - 1, c);
            ++i;
        }
        return new Str(sb.toString());
    }

    @Override
    protected boolean charsIsNumber() {
        char[] cArray = this.value.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (!Character.isDigit(c)) {
                return false;
            }
            ++n2;
        }
        return !this.value.isEmpty();
    }

    @Override
    protected boolean charsIsCaseUp() {
        char[] cArray = this.value.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (!Character.isUpperCase(c)) {
                return false;
            }
            ++n2;
        }
        return !this.value.isEmpty();
    }

    @Override
    protected boolean charsIsCaseDown() {
        char[] cArray = this.value.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (!Character.isLowerCase(c)) {
                return false;
            }
            ++n2;
        }
        return !this.value.isEmpty();
    }

    @Override
    protected boolean charsIsBlank() {
        return this.value.isBlank();
    }
}

