/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.object.atom;

import de.mn77.base.error.Err;
import org.jaymo_lang.error.CodeError;
import org.jaymo_lang.error.ExecError;
import org.jaymo_lang.model.ObjectCallResult;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.object.atom.A_DecNumber;
import org.jaymo_lang.object.atom.A_Number;
import org.jaymo_lang.object.atom.Dec;
import org.jaymo_lang.object.atom.I_Atomic;
import org.jaymo_lang.object.atom.I_AtomicValue;
import org.jaymo_lang.object.atom.I_Decimal;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.util.ATOMIC;
import org.jaymo_lang.util.Lib_AtomConv;
import org.jaymo_lang.util.Lib_Convert;

public class JMo_Float
extends A_DecNumber
implements I_Decimal,
I_Atomic {
    private final float value;

    public JMo_Float(float val) {
        this.value = val;
    }

    @Override
    protected ObjectCallResult call5(CallRuntime cr, String method) {
        return null;
    }

    @Override
    public I_AtomicValue convertTo(CallRuntime cr, ATOMIC to) {
        return Lib_AtomConv.convert(cr, ATOMIC.FLOAT, to, this, this.getValue());
    }

    @Override
    public Float getValue() {
        return Float.valueOf(this.value);
    }

    @Override
    public String toStringIdent() {
        return this.iToString(true);
    }

    @Override
    public String toString(boolean nested) {
        return this.iToString(false);
    }

    @Override
    protected A_Number number_op(CallRuntime cr, A_Number.NOP0 op) {
        switch (op) {
            case NEG: {
                return new Dec(-this.value - 1.0f);
            }
            case ABS: {
                return new Dec(Math.abs(this.value));
            }
        }
        throw Err.impossible(new Object[]{op});
    }

    @Override
    protected A_Number number_op(CallRuntime cr, A_Number.NOP01 op, I_Object[] args) {
        if (args.length == 0) {
            switch (op) {
                case INC: {
                    return new JMo_Float(this.value + 1.0f);
                }
                case DEC: {
                    return new JMo_Float(this.value - 1.0f);
                }
                case POW: {
                    return new Dec(this.value * this.value);
                }
                case SQR: {
                    return new Dec(Math.sqrt(this.value));
                }
            }
        } else {
            A_Number parn = (A_Number)cr.argType(args[0], A_Number.class);
            double arg = Lib_Convert.getDoubleValue(cr, parn);
            switch (op) {
                case INC: {
                    return new JMo_Float((float)((double)this.value + arg));
                }
                case DEC: {
                    return new JMo_Float((float)((double)this.value - arg));
                }
                case POW: {
                    return new Dec(Math.pow(this.value, arg));
                }
                case SQR: {
                    return new Dec(Math.exp(Math.log(this.value) / arg));
                }
            }
        }
        throw new CodeError(cr, "Unknown type or function", String.valueOf(this.value) + " " + (Object)((Object)op) + " " + args.length);
    }

    @Override
    protected A_Number number_op(CallRuntime cr, A_Number.NOP1 op, A_Number parn) {
        double val = this.value;
        double arg = Lib_Convert.getDoubleValue(cr, parn);
        switch (op) {
            case ADD: {
                return new Dec(val + arg);
            }
            case SUB: {
                return new Dec(val - arg);
            }
            case MUL: {
                return new Dec(val * arg);
            }
            case DIV: {
                if (arg == 0.0) {
                    throw new ExecError(cr, "Division by zero", val + "/" + arg);
                }
                return new Dec(val / arg);
            }
            case MOD: {
                return new Dec(val % arg);
            }
            case LOG: {
                return new Dec(Math.log(this.value) / Math.log(arg));
            }
        }
        throw Err.impossible(new Object[]{op});
    }

    private String iToString(boolean suffix) {
        if (Float.isNaN(this.value)) {
            return "not_a_number";
        }
        if (this.value == Float.POSITIVE_INFINITY) {
            return "+infinity";
        }
        if (this.value == Float.NEGATIVE_INFINITY) {
            return "-infinity";
        }
        return suffix ? String.valueOf(this.value) + "f" : "" + this.value;
    }
}

