/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.object.atom;

import de.mn77.base.error.Err;
import java.nio.ByteBuffer;
import org.jaymo_lang.error.CodeError;
import org.jaymo_lang.error.ExecError;
import org.jaymo_lang.model.ObjectCallResult;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.object.atom.A_IntNumber;
import org.jaymo_lang.object.atom.A_Number;
import org.jaymo_lang.object.atom.Dec;
import org.jaymo_lang.object.atom.I_Atomic;
import org.jaymo_lang.object.atom.I_AtomicValue;
import org.jaymo_lang.object.atom.I_Integer;
import org.jaymo_lang.object.atom.JMo_Long;
import org.jaymo_lang.object.struct.JMo_ByteArray;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.util.ATOMIC;
import org.jaymo_lang.util.Lib_AtomConv;
import org.jaymo_lang.util.Lib_Convert;
import org.jaymo_lang.util.Lib_Type;

public class Int
extends A_IntNumber
implements I_Integer,
I_Atomic {
    private final int value;

    public Int(int val) {
        this.value = val;
    }

    @Override
    protected ObjectCallResult call5(CallRuntime cr, String method) {
        return null;
    }

    @Override
    public I_AtomicValue convertTo(CallRuntime cr, ATOMIC to) {
        return Lib_AtomConv.convert(cr, ATOMIC.INT, to, this, this.getValue());
    }

    @Override
    public Integer getValue() {
        return this.value;
    }

    @Override
    public int getIntValue(CallRuntime cr) {
        return this.value;
    }

    @Override
    public String toStringDescribe(CallRuntime cr) {
        return "" + this.value + 'i';
    }

    @Override
    public String toStringIdent() {
        return "" + this.value;
    }

    @Override
    public String toString(boolean nested) {
        return "" + this.value;
    }

    @Override
    protected A_Number number_op(CallRuntime cr, A_Number.NOP0 op) {
        switch (op) {
            case NEG: {
                return new Int(~this.value);
            }
            case ABS: {
                return new Int(Math.abs(this.value));
            }
        }
        throw Err.impossible(new Object[]{op});
    }

    @Override
    protected A_Number number_op(CallRuntime cr, A_Number.NOP01 op, I_Object[] args) {
        if (args.length == 0) {
            switch (op) {
                case INC: {
                    return new Int(this.value + 1);
                }
                case DEC: {
                    return new Int(this.value - 1);
                }
                case POW: {
                    return new Int(this.value * this.value);
                }
                case SQR: {
                    return new Dec(Math.sqrt(this.value));
                }
            }
            throw Err.invalid(new Object[]{cr, op, args});
        }
        A_Number arg = (A_Number)cr.argType(args[0], A_Number.class);
        double argDouble = Lib_Convert.getDoubleValue(cr, arg);
        int argInt = Lib_Convert.getIntValue(cr, arg);
        switch (op) {
            case INC: {
                return new Int(this.value + argInt);
            }
            case DEC: {
                return new Int(this.value - argInt);
            }
            case POW: {
                if (arg instanceof JMo_Long) {
                    long parl = Lib_Convert.getLongValue(cr, arg);
                    return new JMo_Long(Math.round(Math.pow(this.value, parl)));
                }
                if (arg instanceof A_IntNumber) {
                    return new Int((int)Math.round(Math.pow(this.value, argInt)));
                }
                return new Dec(Math.pow(this.value, argDouble));
            }
            case SQR: {
                return new Dec(Math.exp(Math.log(this.value) / argDouble));
            }
        }
        throw new CodeError(cr, "Unknown type or function", String.valueOf(this.value) + " " + (Object)((Object)op) + " " + argDouble);
    }

    @Override
    protected A_Number number_op(CallRuntime cr, A_Number.NOP1 op, A_Number paro) {
        int val = this.value;
        if (paro instanceof JMo_Long) {
            long arg = Lib_Convert.getLongValue(cr, paro);
            switch (op) {
                case ADD: {
                    return new JMo_Long((long)this.value + arg);
                }
                case SUB: {
                    return new JMo_Long((long)this.value - arg);
                }
                case MUL: {
                    return new JMo_Long((long)this.value * arg);
                }
                case DIV: {
                    if (arg == 0L) {
                        throw new ExecError(cr, "Division by zero", this.value + "/" + arg);
                    }
                    return new Dec((double)this.value / (double)arg);
                }
                case MOD: {
                    return new JMo_Long((long)this.value % arg);
                }
                case LOG: {
                    return new Dec(Math.log(this.value) / Math.log(arg));
                }
            }
        } else if (paro instanceof A_IntNumber) {
            int arg = Lib_Convert.getIntValue(cr, paro);
            switch (op) {
                case ADD: {
                    return new Int(this.value + arg);
                }
                case SUB: {
                    return new Int(this.value - arg);
                }
                case MUL: {
                    return new Int(this.value * arg);
                }
                case DIV: {
                    if (arg == 0) {
                        throw new ExecError(cr, "Division by zero", this.value + "/" + arg);
                    }
                    return new Dec((double)this.value / (double)arg);
                }
                case MOD: {
                    return new Int(this.value % arg);
                }
                case LOG: {
                    return new Dec(Math.log(this.value) / Math.log(arg));
                }
            }
        } else {
            double arg = Lib_Convert.getDoubleValue(cr, paro);
            switch (op) {
                case ADD: {
                    return new Dec((double)val + arg);
                }
                case SUB: {
                    return new Dec((double)val - arg);
                }
                case MUL: {
                    return new Dec((double)val * arg);
                }
                case DIV: {
                    if (arg == 0.0) {
                        throw new ExecError(cr, "Division by zero", val + "/" + arg);
                    }
                    return new Dec((double)val / arg);
                }
                case MOD: {
                    return new Dec((double)val % arg);
                }
                case LOG: {
                    return new Dec(Math.log(this.value) / Math.log(arg));
                }
            }
        }
        throw new CodeError(cr, "Unknown type or function", String.valueOf(this.value) + " " + (Object)((Object)op) + " " + Lib_Type.getName(paro));
    }

    @Override
    protected JMo_ByteArray toByteArray(CallRuntime cr) {
        byte[] bytes = ByteBuffer.allocate(4).putInt(this.value).array();
        return new JMo_ByteArray(bytes);
    }
}

