/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.object.atom;

import de.mn77.base.data.Lib_Math;
import de.mn77.base.data.numsys.Binary;
import de.mn77.base.error.Err;
import java.util.ArrayList;
import org.jaymo_lang.model.I_AutoBlockDo;
import org.jaymo_lang.model.ObjectCallResult;
import org.jaymo_lang.object.A_Object;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.object.LoopHandle;
import org.jaymo_lang.object.atom.A_Chars;
import org.jaymo_lang.object.atom.A_Number;
import org.jaymo_lang.object.atom.Bool;
import org.jaymo_lang.object.atom.Char;
import org.jaymo_lang.object.atom.I_Integer;
import org.jaymo_lang.object.atom.Int;
import org.jaymo_lang.object.atom.JMo_Long;
import org.jaymo_lang.object.atom.Str;
import org.jaymo_lang.object.pseudo.Return;
import org.jaymo_lang.object.struct.JMo_ByteArray;
import org.jaymo_lang.object.struct.JMo_List;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.util.Lib_Convert;
import org.jaymo_lang.util.Lib_Exec;

public abstract class A_IntNumber
extends A_Number
implements I_AutoBlockDo,
I_Integer {
    @Override
    protected final ObjectCallResult call4(CallRuntime cr, String method) {
        switch (method) {
            case "<<": 
            case "shiftLeft": {
                return A_Object.stdResult(this.mShift(cr, false));
            }
            case ">>": 
            case "shiftRight": {
                return A_Object.stdResult(this.mShift(cr, true));
            }
            case "bitAnd": 
            case "&": {
                return A_Object.stdResult(this.mBitwise(cr, BITWISE.AND));
            }
            case "|": 
            case "bitOr": {
                return A_Object.stdResult(this.mBitwise(cr, BITWISE.OR));
            }
            case "bitXor": 
            case "^": {
                return A_Object.stdResult(this.mBitwise(cr, BITWISE.XOR));
            }
            case "toHex": {
                return A_Object.stdResult(this.mToHex(cr));
            }
            case "chr": {
                return A_Object.stdResult(this.mChr(cr));
            }
            case "toBin": {
                return A_Object.stdResult(this.mToBin(cr));
            }
            case "toByteArray": 
            case "getBytes": {
                cr.args();
                return A_Object.stdResult(this.toByteArray(cr));
            }
            case "timesUp": 
            case "each": 
            case "times": {
                return this.mTimes(cr, false);
            }
            case "timesDown": {
                return this.mTimes(cr, true);
            }
            case "for": {
                return this.mFor(cr);
            }
            case "isEven": {
                return A_Object.stdResult(this.mIsEven(cr));
            }
            case "isOdd": {
                return A_Object.stdResult(this.mIsOdd(cr));
            }
            case "isBetween": {
                return A_Object.stdResult(this.mIsBetween(cr));
            }
            case "divisible": {
                return A_Object.stdResult(this.mDivisible(cr));
            }
            case "checksum": {
                return A_Object.stdResult(this.mChecksum(cr));
            }
        }
        return this.call5(cr, method);
    }

    protected abstract JMo_ByteArray toByteArray(CallRuntime var1);

    protected abstract ObjectCallResult call5(CallRuntime var1, String var2);

    @Override
    public I_Object autoBlockDo(CallRuntime cr) {
        return this.mTimes((CallRuntime)cr, (boolean)false).obj;
    }

    protected ObjectCallResult mTimes(CallRuntime crOld, boolean reverse) {
        crOld.args();
        if (crOld.getStream() == null && crOld.getCallBlock() == null) {
            return new ObjectCallResult(reverse ? new JMo_Long(1L) : this, true);
        }
        int value = this.getIntValue(crOld);
        int start = reverse ? value : 1;
        int end = reverse ? 0 : value + 1;
        int step = reverse ? -1 : 1;
        LoopHandle handle = new LoopHandle(this, reverse ? "timesDown" : "timesUp");
        CallRuntime crNew = crOld.copyLoop(handle);
        I_Object result = this;
        int i = start;
        while (i != end) {
            handle.startLap();
            result = Lib_Exec.execBlockStream(crNew, new Int(i));
            result = Lib_Exec.loopResult(result);
            if (result instanceof Return) {
                return ((Return)result).getLoopResult();
            }
            i += step;
        }
        return new ObjectCallResult(result, true);
    }

    private ObjectCallResult mFor(CallRuntime crOld) {
        LoopHandle handle = new LoopHandle(this);
        CallRuntime crNew = crOld.copyLoop(handle);
        I_Object result = this;
        I_Object runObj = crOld.argEach(this, 0, result, Bool.class);
        boolean run = Lib_Convert.getBoolValue(crOld, runObj);
        while (run) {
            handle.startLap();
            result = Lib_Exec.execBlockStream(crNew, result);
            result = Lib_Exec.loopResult(result);
            if (result instanceof Return) {
                return ((Return)result).getLoopResult();
            }
            result = crOld.argEach(this, 1, result, I_Object.class);
            runObj = crOld.argEach(this, 0, result, Bool.class);
            run = Lib_Convert.getBoolValue(crOld, runObj);
        }
        return new ObjectCallResult(result, true);
    }

    private I_Object mBitwise(CallRuntime cr, BITWISE op) {
        Number val = (Number)this.getValue();
        I_Object arg = cr.args(this, A_IntNumber.class)[0];
        if (this instanceof JMo_Long || arg instanceof JMo_Long) {
            long parl = Lib_Convert.getLongValue(cr, arg);
            switch (op) {
                case AND: {
                    return new JMo_Long(val.longValue() & parl);
                }
                case OR: {
                    return new JMo_Long(val.longValue() | parl);
                }
                case XOR: {
                    return new JMo_Long(val.longValue() ^ parl);
                }
            }
        } else {
            int pari = Lib_Convert.getIntValue(cr, arg);
            switch (op) {
                case AND: {
                    return new Int(val.intValue() & pari);
                }
                case OR: {
                    return new Int(val.intValue() | pari);
                }
                case XOR: {
                    return new Int(val.intValue() ^ pari);
                }
            }
        }
        throw Err.impossible(new Object[]{op, val});
    }

    private I_Object mShift(CallRuntime cr, boolean right) {
        Int arg;
        Number val = (Number)this.getValue();
        I_Object[] args = cr.argsFlex(this, 0, 1);
        A_IntNumber a_IntNumber = arg = args.length == 0 ? new Int(1) : (A_IntNumber)cr.argType(args[0], A_IntNumber.class);
        if (this instanceof JMo_Long || arg instanceof JMo_Long) {
            long parl = Lib_Convert.getLongValue(cr, arg);
            if (right) {
                return new JMo_Long(val.longValue() >> (int)parl);
            }
            return new JMo_Long(val.longValue() << (int)parl);
        }
        int pari = Lib_Convert.getIntValue(cr, arg);
        if (right) {
            return new Int(val.intValue() >> pari);
        }
        return new Int(val.intValue() << pari);
    }

    private I_Object mToHex(CallRuntime cr) {
        cr.args();
        long value = ((Number)this.getValue()).longValue();
        String s = Long.toHexString(value);
        return new Str(s);
    }

    private Bool mIsEven(CallRuntime cr) {
        cr.args();
        long value = ((Number)this.getValue()).longValue();
        return Bool.getObject(value % 2L == 0L);
    }

    private Bool mIsOdd(CallRuntime cr) {
        cr.args();
        long value = ((Number)this.getValue()).longValue();
        return Bool.getObject(value % 2L != 0L);
    }

    private Bool mIsBetween(CallRuntime cr) {
        I_Object[] oa = cr.args(this, A_IntNumber.class, A_IntNumber.class);
        long value = ((Number)this.getValue()).longValue();
        long i1 = ((Number)((A_IntNumber)oa[0]).getValue()).longValue();
        long i2 = ((Number)((A_IntNumber)oa[1]).getValue()).longValue();
        return Bool.getObject(value >= i1 && value <= i2);
    }

    private JMo_List mDivisible(CallRuntime cr) {
        cr.args();
        ArrayList<I_Object> list = new ArrayList<I_Object>();
        if (this instanceof JMo_Long) {
            long value = ((Number)this.getValue()).longValue();
            long i = Math.abs(value);
            int fi = 1;
            while ((long)fi <= i / 2L) {
                if ((double)i / (double)fi == (double)(i / (long)fi)) {
                    list.add(new JMo_Long(fi));
                }
                ++fi;
            }
            if (i != 0L) {
                list.add(new JMo_Long(i));
            }
            return new JMo_List(list);
        }
        int iv = ((Number)this.getValue()).intValue();
        int i = Math.abs(iv);
        int fi = 1;
        while (fi <= i / 2) {
            if ((double)i / (double)fi == (double)(i / fi)) {
                list.add(new Int(fi));
            }
            ++fi;
        }
        if (i != 0) {
            list.add(new Int(i));
        }
        return new JMo_List(list);
    }

    private Int mChecksum(CallRuntime cr) {
        cr.args();
        long l = ((Number)this.getValue()).longValue();
        return new Int(Lib_Math.checksum(l));
    }

    private A_Chars mChr(CallRuntime cr) {
        cr.args();
        long ln = ((Number)this.getValue()).longValue();
        if (ln < 65536L) {
            return new Char((char)ln);
        }
        int high = (int)(ln >> 16);
        int low = (int)(ln - (long)(high << 16));
        return new Str("" + (char)high + (char)low);
    }

    private Str mToBin(CallRuntime cr) {
        cr.args();
        String s = Binary.toBin(this.getIntValue(cr));
        return new Str(s);
    }

    protected static enum BITWISE {
        AND,
        OR,
        XOR;

    }
}

