/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.model;

import java.util.HashMap;
import org.jaymo_lang.error.CodeError;
import org.jaymo_lang.error.DebugInfo;
import org.jaymo_lang.error.ParseError;
import org.jaymo_lang.model.Block;
import org.jaymo_lang.model.EventManager;
import org.jaymo_lang.model.FuncManager;
import org.jaymo_lang.model.FunctionPar;
import org.jaymo_lang.object.A_ObjectToString;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.object.immute.A_Immutable;
import org.jaymo_lang.object.immute.JMo_Enum;
import org.jaymo_lang.parser.Parser_Script;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.util.Lib_Output;
import org.jaymo_lang.util.Lib_Prefix;
import org.jaymo_lang.util.Lib_Type;

public class Type
extends A_ObjectToString {
    private final String name;
    private final Block mainblock;
    private final FuncManager functions;
    private final EventManager events;
    private final FunctionPar[] args;
    private final String autoBlockFunction;
    private final boolean control;
    private final boolean varargs;
    private final int defaultArgs;
    private HashMap<String, Type> selfTypes = null;
    private HashMap<String, A_Immutable> selfConst = null;
    private final I_Object parent;

    public Type(String name, FunctionPar[] args, String abf, boolean control, boolean varargs, Parser_Script parser, DebugInfo debug) {
        this(name, args, abf, control, varargs, parser, null, debug);
    }

    public Type(String name, FunctionPar[] args, String abf, boolean control, boolean varargs, Parser_Script parser, I_Object parent, DebugInfo debug) {
        this.name = Lib_Prefix.addPrefix(name, parser);
        if (parser != null) {
            Lib_Type.checkValidity(this.name, parser);
        }
        this.autoBlockFunction = abf;
        this.mainblock = new Block(this);
        this.parent = parent;
        this.functions = new FuncManager();
        this.events = new EventManager();
        this.control = control;
        this.varargs = varargs;
        this.args = args;
        int defArgCounter = 0;
        if (this.args != null) {
            FunctionPar[] functionParArray = args;
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                FunctionPar arg = functionParArray[n2];
                if (arg.isConst) {
                    this.mainblock.getConstManager().define(arg.name, debug);
                } else {
                    this.mainblock.getVarManager().define(arg.name, debug);
                }
                if (arg.defaultValue != null) {
                    ++defArgCounter;
                }
                ++n2;
            }
        }
        this.defaultArgs = defArgCounter;
    }

    public void addType(Type typ, DebugInfo debug) {
        String newName = typ.getName();
        String newNameLower = newName.toLowerCase();
        if (this.selfTypes == null) {
            this.selfTypes = new HashMap();
        }
        for (String s : this.selfTypes.keySet()) {
            if (!newNameLower.equals(s.toLowerCase())) continue;
            String m2 = newName.equals(s) ? "You cannot redefine: " : "You cannot redefine '" + s + "' with: ";
            throw new ParseError("Type-Name already used!", String.valueOf(m2) + newName, debug);
        }
        this.selfTypes.put(newName, typ);
    }

    public Block getBlock() {
        return this.mainblock;
    }

    public Type getType(String type) {
        return this.selfTypes == null ? null : (Type)this.selfTypes.getOrDefault(type, null);
    }

    public EventManager getEvents() {
        return this.events;
    }

    public FuncManager getFunctions() {
        return this.functions;
    }

    public String getName() {
        return this.name;
    }

    public boolean isVarArgs() {
        return this.varargs;
    }

    public FunctionPar[] getVars() {
        return this.args;
    }

    public String getAutoBlockFunction() {
        return this.autoBlockFunction;
    }

    public boolean isControl() {
        return this.control;
    }

    @Override
    public String toString(boolean nested) {
        return this.name;
    }

    @Override
    public String toStringIdent(CallRuntime cr) {
        return "::" + this.name;
    }

    @Override
    public String toStringDescribe(CallRuntime cr) {
        StringBuilder sb = new StringBuilder();
        if (this.functions != null) {
            String sf = this.functions.toStringDescribe(cr);
            sb.append(sf);
            sb.append('\n');
        }
        if (this.events != null) {
            String se = this.events.toStringDescribe(cr);
            sb.append(se);
            sb.append('\n');
        }
        if (this.mainblock != null) {
            String sm = this.mainblock.toStringDescribe(cr);
            sb.append(sm);
            sb.append('\n');
        }
        if (this.selfTypes != null) {
            for (Type t : this.selfTypes.values()) {
                String st = t.toStringDescribe(cr);
                sb.append(st);
                sb.append('\n');
            }
        }
        Lib_Output.removeEnd(sb, '\n');
        return Lib_Output.appShowPart(this.toStringIdent(cr), sb.toString());
    }

    public int getDefaultArgs() {
        return this.defaultArgs;
    }

    public I_Object getParent() {
        return this.parent;
    }

    public void addConstant(String name, A_Immutable value, DebugInfo debug) {
        if (this.selfConst == null) {
            this.selfConst = new HashMap();
        }
        if (this.selfConst.containsKey(name)) {
            throw new CodeError("Enum-Name already used!", "Enum is already set: " + name, debug);
        }
        this.selfConst.put(name, value);
        if (value instanceof JMo_Enum) {
            ((JMo_Enum)value).setOrdinal(this.selfConst.size());
        }
    }

    public A_Immutable getEnum(String name, DebugInfo debug) {
        A_Immutable result;
        A_Immutable a_Immutable = result = this.selfConst == null ? null : (A_Immutable)this.selfConst.getOrDefault(name, null);
        if (result == null) {
            throw new CodeError("Unknown Enum!", "Enum is not known: " + name, debug);
        }
        return result;
    }
}

