/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.model;

import de.mn77.base.data.search.SearchArray;
import org.jaymo_lang.api.SandBox;
import org.jaymo_lang.error.DebugInfo;
import org.jaymo_lang.error.ErrorBaseDebug;
import org.jaymo_lang.error.ParseError;
import org.jaymo_lang.model.App;
import org.jaymo_lang.model.Block;
import org.jaymo_lang.model.Call;
import org.jaymo_lang.model.Type;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.object.JMo_Cycle;
import org.jaymo_lang.object.JMo_Group;
import org.jaymo_lang.object.JMo_Random;
import org.jaymo_lang.object.JMo_Range;
import org.jaymo_lang.object.JMo_RegEx;
import org.jaymo_lang.object.JMo_Use;
import org.jaymo_lang.object.atom.Str;
import org.jaymo_lang.object.classic.JMo_Break;
import org.jaymo_lang.object.classic.JMo_Count;
import org.jaymo_lang.object.classic.JMo_Describe;
import org.jaymo_lang.object.classic.JMo_Each;
import org.jaymo_lang.object.classic.JMo_Echo;
import org.jaymo_lang.object.classic.JMo_EchoErr;
import org.jaymo_lang.object.classic.JMo_Exit;
import org.jaymo_lang.object.classic.JMo_For;
import org.jaymo_lang.object.classic.JMo_If;
import org.jaymo_lang.object.classic.JMo_IfNot;
import org.jaymo_lang.object.classic.JMo_Loop;
import org.jaymo_lang.object.classic.JMo_Next;
import org.jaymo_lang.object.classic.JMo_Print;
import org.jaymo_lang.object.classic.JMo_PrintErr;
import org.jaymo_lang.object.classic.JMo_Repeat;
import org.jaymo_lang.object.classic.JMo_Return;
import org.jaymo_lang.object.classic.JMo_Try;
import org.jaymo_lang.object.classic.JMo_Which;
import org.jaymo_lang.object.classic.JMo_While;
import org.jaymo_lang.object.filesys.JMo_Dir;
import org.jaymo_lang.object.filesys.JMo_File;
import org.jaymo_lang.object.filesys.JMo_Path;
import org.jaymo_lang.object.filesys.JMo_RandomAccessFile;
import org.jaymo_lang.object.immute.JMo_Enum;
import org.jaymo_lang.object.immute.JMo_KeyValue;
import org.jaymo_lang.object.immute.JMo_Type;
import org.jaymo_lang.object.immute.datetime.JMo_Date;
import org.jaymo_lang.object.immute.datetime.JMo_DateTime;
import org.jaymo_lang.object.immute.datetime.JMo_Time;
import org.jaymo_lang.object.pseudo.JMo_Error;
import org.jaymo_lang.object.pseudo.NonAtomic;
import org.jaymo_lang.object.pseudo.NonAtomicJava;
import org.jaymo_lang.object.pseudo.NonAtomicSelf;
import org.jaymo_lang.object.struct.JMo_ByteArray;
import org.jaymo_lang.object.struct.JMo_FunctionMap;
import org.jaymo_lang.object.struct.JMo_List;
import org.jaymo_lang.object.struct.JMo_Makro;
import org.jaymo_lang.object.struct.JMo_Map;
import org.jaymo_lang.object.struct.JMo_Set;
import org.jaymo_lang.object.struct.JMo_Table;
import org.jaymo_lang.object.struct.JMo_Tree;
import org.jaymo_lang.object.struct.JMo_TreeNode;
import org.jaymo_lang.object.sys.JMo_Cmd;
import org.jaymo_lang.object.sys.JMo_Input;
import org.jaymo_lang.object.sys.JMo_Java;
import org.jaymo_lang.object.sys.JMo_Sys;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.util.ATOMIC;
import org.jaymo_lang.util.BLOCKED;
import org.jaymo_lang.util.ClassFinder;
import org.jaymo_lang.util.Lib_Java;
import org.jaymo_lang.util.Lib_Prefix;

public class ObjectManager {
    private static final String JAVA_TYPE = "Java";

    public static I_Object createNew(App app, Block current, String name, Call[] args, DebugInfo debugInfo) {
        if (name.charAt(0) == 'J' && name.startsWith(JAVA_TYPE)) {
            int len = name.length();
            if (len == 4) {
                return ObjectManager.iJava(app, args, debugInfo);
            }
            if (len >= 5 && name.charAt(4) == '_') {
                String javaclass = null;
                javaclass = len >= 6 && name.charAt(5) == '{' ? Lib_Java.packConv_FullToClass(name) : Lib_Prefix.cutJava(name);
                Call[] args2 = new Call[]{new Call(current, new Str(javaclass), debugInfo), new Call(current, args == null ? new JMo_List() : new JMo_List(args), debugInfo)};
                return ObjectManager.iJava(app, args2, debugInfo);
            }
        }
        boolean nameWithPrefix = Lib_Prefix.isNameWithPrefix(name);
        return ObjectManager.createNew(app, name, nameWithPrefix, args, debugInfo);
    }

    private static I_Object createNew(App app, String name, boolean withPrefix, Call[] args, DebugInfo debugInfo) {
        Class<? extends I_Object> c;
        int n;
        if (!withPrefix) {
            String r;
            String[] stringArray = ATOMIC.ATOMIC_TYPENAMES;
            n = ATOMIC.ATOMIC_TYPENAMES.length;
            int n2 = 0;
            while (n2 < n) {
                r = stringArray[n2];
                if (name.equals(r)) {
                    throw ObjectManager.errorAtomic(name, debugInfo);
                }
                ++n2;
            }
            stringArray = ATOMIC.ABSTRACT_TYPES;
            n = ATOMIC.ABSTRACT_TYPES.length;
            n2 = 0;
            while (n2 < n) {
                r = stringArray[n2];
                if (name.equals(r)) {
                    throw ObjectManager.errorAtomic(name, debugInfo);
                }
                ++n2;
            }
        }
        if ((c = ObjectManager.iGetStaticType(app, name, debugInfo)) != null) {
            return new NonAtomic(c, args);
        }
        String[] stringArray = BLOCKED.TYPE_NAME;
        int n3 = BLOCKED.TYPE_NAME.length;
        n = 0;
        while (n < n3) {
            String block = stringArray[n];
            if (block.equals(name)) {
                throw new ParseError("Invalid type", "Type is private or forbidden: " + name, debugInfo);
            }
            ++n;
        }
        Class<?> c2 = ObjectManager.searchJavaJMoClass(name);
        if (c2 != null) {
            if (I_Object.class.isAssignableFrom(c2)) {
                return new NonAtomic(c2, args);
            }
            return new NonAtomic(SandBox.class, c2, args);
        }
        Type t = app.getType().getType(name);
        if (t != null) {
            return new NonAtomicSelf(t, args);
        }
        throw new ParseError("Unknown type", name, debugInfo);
    }

    private static I_Object iJava(App app, Call[] args, DebugInfo debugInfo) {
        app.strict.checkSave(debugInfo, JAVA_TYPE);
        return new NonAtomicJava(args);
    }

    public static Class<?> searchJavaJMoClass(String search) {
        return ClassFinder.getInstance().searchJMoClass("JMo_" + search);
    }

    private static Class<? extends I_Object> iGetStaticType(App app, String name, DebugInfo debug) {
        switch (name) {
            case "Break": {
                return JMo_Break.class;
            }
            case "Count": {
                return JMo_Count.class;
            }
            case "Describe": {
                return JMo_Describe.class;
            }
            case "Each": {
                return JMo_Each.class;
            }
            case "Echo": {
                return JMo_Echo.class;
            }
            case "EchoErr": {
                return JMo_EchoErr.class;
            }
            case "Exit": {
                return JMo_Exit.class;
            }
            case "For": {
                return JMo_For.class;
            }
            case "If": {
                return JMo_If.class;
            }
            case "IfNot": {
                return JMo_IfNot.class;
            }
            case "Loop": {
                return JMo_Loop.class;
            }
            case "Next": {
                return JMo_Next.class;
            }
            case "Print": {
                return JMo_Print.class;
            }
            case "PrintErr": {
                return JMo_PrintErr.class;
            }
            case "Repeat": {
                return JMo_Repeat.class;
            }
            case "Return": {
                return JMo_Return.class;
            }
            case "Try": {
                return JMo_Try.class;
            }
            case "Which": {
                return JMo_Which.class;
            }
            case "While": {
                return JMo_While.class;
            }
            case "Cycle": {
                app.strict.checkSave(debug, "Cycle");
                return JMo_Cycle.class;
            }
            case "Group": {
                return JMo_Group.class;
            }
            case "Random": {
                return JMo_Random.class;
            }
            case "Range": {
                return JMo_Range.class;
            }
            case "RegEx": 
            case "Regex": {
                return JMo_RegEx.class;
            }
            case "Use": {
                return JMo_Use.class;
            }
            case "Enum": {
                return JMo_Enum.class;
            }
            case "KeyValue": {
                return JMo_KeyValue.class;
            }
            case "Type": {
                return JMo_Type.class;
            }
            case "Date": {
                return JMo_Date.class;
            }
            case "DateTime": {
                return JMo_DateTime.class;
            }
            case "Time": {
                return JMo_Time.class;
            }
            case "Dir": {
                app.strict.checkSave(debug, "Dir");
                return JMo_Dir.class;
            }
            case "File": {
                app.strict.checkSave(debug, "File");
                return JMo_File.class;
            }
            case "Path": {
                app.strict.checkSave(debug, "Path");
                return JMo_Path.class;
            }
            case "RandomAccessFile": {
                app.strict.checkSave(debug, "RandomAccessFile");
                return JMo_RandomAccessFile.class;
            }
            case "ByteArray": {
                return JMo_ByteArray.class;
            }
            case "FunctionMap": {
                return JMo_FunctionMap.class;
            }
            case "List": {
                return JMo_List.class;
            }
            case "Makro": {
                return JMo_Makro.class;
            }
            case "Map": {
                return JMo_Map.class;
            }
            case "Set": {
                return JMo_Set.class;
            }
            case "Table": {
                return JMo_Table.class;
            }
            case "Tree": {
                return JMo_Tree.class;
            }
            case "TreeNode": {
                return JMo_TreeNode.class;
            }
            case "Error": {
                return JMo_Error.class;
            }
            case "Cmd": {
                app.strict.checkSave(debug, "Cmd");
                return JMo_Cmd.class;
            }
            case "Input": {
                app.strict.checkSave(debug, "Input");
                return JMo_Input.class;
            }
            case "Java": {
                app.strict.checkSave(debug, JAVA_TYPE);
                return JMo_Java.class;
            }
            case "Sys": {
                return JMo_Sys.class;
            }
        }
        return null;
    }

    private static ErrorBaseDebug errorAtomic(String type, DebugInfo debugInfo) {
        return new ParseError("Atomic types cannot created via typename!", type, debugInfo);
    }

    public static boolean isTypeKnown(CallRuntime cr, String type) {
        int len;
        if (SearchArray.knows(ATOMIC.ATOMIC_TYPENAMES, type, true) || SearchArray.knows(ATOMIC.ABSTRACT_TYPES, type, true)) {
            return true;
        }
        Type t = cr.getApp().getType().getType(type);
        if (t != null) {
            return true;
        }
        if (type.startsWith(JAVA_TYPE) && (len = type.length()) >= 5 && type.charAt(4) == '_') {
            Class<?> c3 = null;
            if (len >= 6 && type.charAt(5) == '{') {
                String javaType = Lib_Java.packConv_FullToClass(type);
                c3 = ClassFinder.getInstance().searchJavaClassPath(javaType);
            } else {
                String javaType = Lib_Prefix.cutJava(type);
                c3 = ClassFinder.getInstance().searchJavaClass(javaType);
            }
            if (c3 != null) {
                return true;
            }
        }
        return ObjectManager.searchJavaJMoClass(type) != null;
    }
}

